/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Messages;

public abstract class LegacyPropertyAdapter<L, N>
extends AbstractCollection<L> {
    protected final Collection<N> elements;
    private transient boolean warningOccurred;

    protected LegacyPropertyAdapter(Collection<N> collection) {
        this.elements = collection;
    }

    protected abstract N wrap(L var1);

    protected abstract L unwrap(N var1);

    protected abstract boolean update(N var1, L var2);

    public final LegacyPropertyAdapter<L, N> validOrNull() {
        return this.elements != null ? this : null;
    }

    public final void setValues(Collection<? extends L> collection) {
        Object var5_5;
        if (collection == null) {
            collection = Collections.emptySet();
        }
        Iterator<L> iterator = collection.iterator();
        Iterator<N> iterator2 = this.elements.iterator();
        boolean bl = iterator.hasNext();
        Object v0 = var5_5 = bl ? iterator.next() : null;
        while (iterator2.hasNext()) {
            N n = iterator2.next();
            if (!this.update(n, var5_5)) continue;
            bl = iterator.hasNext();
            Object v1 = var5_5 = bl ? iterator.next() : null;
            if (!LegacyPropertyAdapter.isEmpty(n)) continue;
            iterator2.remove();
        }
        if (bl) {
            this.elements.add(this.wrap(var5_5));
            while (iterator.hasNext()) {
                this.elements.add(this.wrap(iterator.next()));
            }
        }
    }

    public static <L> L getSingleton(Collection<? extends L> collection, Class<L> clazz, LegacyPropertyAdapter<L, ?> legacyPropertyAdapter, Class<?> clazz2, String string) {
        Iterator<L> iterator;
        if (collection != null && (iterator = collection.iterator()).hasNext()) {
            L l = iterator.next();
            if (iterator.hasNext()) {
                if (legacyPropertyAdapter != null) {
                    if (legacyPropertyAdapter.warningOccurred) {
                        return l;
                    }
                    legacyPropertyAdapter.warningOccurred = true;
                }
                LegacyPropertyAdapter.warnIgnoredExtraneous(clazz, clazz2, string);
            }
            return l;
        }
        return null;
    }

    public static void warnIgnoredExtraneous(Class<?> clazz, Class<?> clazz2, String string) {
        Context.warningOccured((Context)Context.current(), clazz2, (String)string, Messages.class, (short)6, (Object[])new Object[]{clazz});
    }

    public static <L> Collection<L> asCollection(L l) {
        return l != null ? Collections.singleton(l) : Collections.emptySet();
    }

    static boolean isEmpty(Object object) {
        return object instanceof AbstractMetadata && ((AbstractMetadata)object).isEmpty();
    }

    @Override
    public final boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public final int size() {
        int n = 0;
        Iterator<L> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    @Override
    public boolean add(L l) {
        ArgumentChecks.ensureNonNull((String)"value", l);
        return this.elements.add(this.wrap(l));
    }

    @Override
    public final Iterator<L> iterator() {
        final Iterator<N> iterator = this.elements.iterator();
        return new Iterator<L>(){
            private N container;
            private L next;

            @Override
            public final boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    this.container = iterator.next();
                    this.next = LegacyPropertyAdapter.this.unwrap(this.container);
                    if (this.next == null) continue;
                    return true;
                }
                this.container = null;
                return false;
            }

            @Override
            public final L next() {
                Object l = this.next;
                if (l == null) {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    l = this.next;
                }
                this.next = null;
                return l;
            }

            @Override
            public final void remove() {
                if (this.container == null) {
                    throw new IllegalStateException();
                }
                if (!LegacyPropertyAdapter.this.update(this.container, null)) {
                    throw new UnsupportedOperationException();
                }
                if (LegacyPropertyAdapter.isEmpty(this.container)) {
                    iterator.remove();
                }
            }
        };
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof LegacyPropertyAdapter)) {
            return false;
        }
        Iterator<L> iterator = ((LegacyPropertyAdapter)object).iterator();
        Iterator<L> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (iterator.hasNext() && Objects.equals(iterator2.next(), iterator.next())) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @Override
    public final int hashCode() {
        int n = 0;
        for (L l : this) {
            n = n * 31 + Objects.hashCode(l);
        }
        return n;
    }
}

