/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Date;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.PrimitiveTypeProperties;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilReason;

public final class MetadataUtilities
extends Static {
    private MetadataUtilities() {
    }

    public static long toMilliseconds(Date date) {
        return date != null ? date.getTime() : Long.MIN_VALUE;
    }

    public static Date toDate(long l) {
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public static boolean getInclusion(Boolean bl) throws InvalidMetadataException {
        if (bl == null) {
            return true;
        }
        boolean bl2 = bl;
        if (bl2 || bl == Boolean.FALSE || !(PrimitiveTypeProperties.property((Object)bl) instanceof NilReason)) {
            return bl2;
        }
        throw new InvalidMetadataException(Errors.format((short)64, (Object)"inclusion"));
    }

    public static boolean ensurePositive(Class<?> clazz, String string, boolean bl, Number number) throws IllegalArgumentException {
        if (number != null) {
            double d = number.doubleValue();
            if (!(!bl ? d >= 0.0 : d > 0.0) && NilReason.forObject((Object)number) == null) {
                String string2 = MetadataUtilities.logOrFormat(clazz, string, bl ? (short)132 : 67, string, number);
                if (string2 != null) {
                    throw new IllegalArgumentException(string2);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean ensureInRange(Class<?> clazz, String string, Number number, Number number2, Number number3) throws IllegalArgumentException {
        double d;
        if (!(number3 == null || (d = number3.doubleValue()) >= number.doubleValue() && d <= number2.doubleValue() || NilReason.forObject((Object)number3) != null)) {
            String string2 = MetadataUtilities.logOrFormat(clazz, string, (short)133, string, number, number2, number3);
            if (string2 != null) {
                throw new IllegalArgumentException(string2);
            }
            return false;
        }
        return true;
    }

    private static String logOrFormat(Class<?> clazz, String string, short s, Object ... objectArray) {
        Context context = Context.current();
        if (context == null) {
            return Errors.format((short)s, (Object)objectArray);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 3).append("set").append(string);
        stringBuilder.setCharAt(3, Character.toUpperCase(stringBuilder.charAt(3)));
        Context.warningOccured((Context)context, clazz, (String)stringBuilder.toString(), Errors.class, (short)s, (Object[])objectArray);
        return null;
    }
}

