/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.opengis.referencing.cs.CoordinateSystem;

final class Element
implements Serializable {
    private static final long serialVersionUID = 2366817541632131955L;
    private static final int NUMERIC = 1;
    private static final int TEMPORAL = 2;
    private static final String[] TIME_KEYWORDS = new String[]{"TimeOrigin", "TimeExtent"};
    final int offset;
    private byte keywordIndex;
    public final String keyword;
    private final List<Object> list;
    private final Locale locale;

    Element(String string, Element element) {
        this.keyword = string;
        this.offset = element.offset;
        this.locale = element.locale;
        this.list = new LinkedList<Object>();
        this.list.add(element);
    }

    private Element(Element element) {
        this.keyword = element.keyword;
        this.offset = element.offset;
        this.locale = element.locale;
        this.list = new LinkedList<Object>(element.list);
        ListIterator<Object> listIterator = this.list.listIterator();
        while (listIterator.hasNext()) {
            Object object = listIterator.next();
            if (!(object instanceof Element)) continue;
            Element element2 = (Element)object;
            if (element2.list == null) continue;
            listIterator.set(new Element(element2));
        }
    }

    Element(AbstractParser abstractParser, String string, ParsePosition parsePosition, Map<Object, Object> map) throws ParseException {
        int n;
        this.locale = abstractParser.errorLocale;
        this.offset = parsePosition.getIndex();
        int n2 = string.length();
        int n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)this.offset, (int)n2);
        int n4 = string.codePointAt(n3);
        if (!Character.isUnicodeIdentifierStart(n4)) {
            this.keyword = string;
            parsePosition.setErrorIndex(n3);
            throw this.unparsableString(string, parsePosition);
        }
        int n5 = n3;
        while ((n5 += Character.charCount(n4)) < n2 && Character.isUnicodeIdentifierPart(n4 = string.codePointAt(n5))) {
        }
        this.keyword = string.substring(n3, n5);
        n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)n5, (int)n2);
        n4 = 0;
        if (n3 >= n2 || (n = abstractParser.symbols.matchingBracket(n5 = string.codePointAt(n3))) < 0) {
            parsePosition.setIndex(n3);
            this.list = null;
            return;
        }
        n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n3 + Character.charCount(n5)), (int)n2);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String string2 = abstractParser.symbols.trimmedSeparator();
        while (n3 < n2) {
            int n6;
            int n7 = string.codePointAt(n3);
            if (n7 == 36) {
                int n8;
                for (n6 = ++n3; n6 < n2 && Character.isUnicodeIdentifierPart(n8 = string.codePointAt(n6)); n6 += Character.charCount(n8)) {
                }
                String string3 = string.substring(n3, n6);
                Element element = abstractParser.fragments.get(string3);
                if (element == null) {
                    parsePosition.setIndex(this.offset);
                    parsePosition.setErrorIndex(n3);
                    throw new LocalizedParseException(this.locale, 196, new Object[]{string3}, n3);
                }
                if (element.list != null) {
                    element = new Element(element);
                }
                linkedList.add(element);
                n3 = n6;
            } else if (Character.isUnicodeIdentifierStart(n7)) {
                if (n3 != (n3 = Element.regionMatches(string, n3, "true"))) {
                    linkedList.add(Boolean.TRUE);
                } else if (n3 != (n3 = Element.regionMatches(string, n3, "false"))) {
                    linkedList.add(Boolean.FALSE);
                } else {
                    parsePosition.setIndex(n3);
                    linkedList.add(new Element(abstractParser, string, parsePosition, map));
                    n3 = parsePosition.getIndex();
                }
            } else {
                Object object;
                Object object2;
                int n9 = abstractParser.symbols.matchingQuote(n7);
                if (n9 >= 0) {
                    int n10;
                    int n11 = Character.charCount(n9);
                    n3 += Character.charCount(n7) - n11;
                    CharSequence charSequence = null;
                    do {
                        if ((n10 = string.indexOf(n9, n3 += n11)) < n3) {
                            throw this.missingCharacter(n9, n3, parsePosition);
                        }
                        if (charSequence == null) {
                            charSequence = string.substring(n3, n10);
                            continue;
                        }
                        if (charSequence instanceof String) {
                            charSequence = new StringBuilder((String)charSequence);
                        }
                        ((StringBuilder)charSequence).appendCodePoint(n9).append(string, n3, n10);
                    } while ((n3 = n10 + n11) < string.length() && string.codePointAt(n3) == n9);
                    object2 = CharSequences.trimWhitespaces((CharSequence)charSequence).toString();
                } else {
                    parsePosition.setIndex(n3);
                    if (n4 == 0) {
                        n4 = ArraysExt.containsIgnoreCase((String[])TIME_KEYWORDS, (String)this.keyword) ? 2 : 1;
                    }
                    switch (n4) {
                        case 2: {
                            object2 = abstractParser.parseDate(string, parsePosition);
                            break;
                        }
                        case 1: {
                            object2 = abstractParser.parseNumber(string, parsePosition);
                            break;
                        }
                        default: {
                            throw new AssertionError(n4);
                        }
                    }
                    if (object2 == null) {
                        throw this.unparsableString(string, parsePosition);
                    }
                    n3 = parsePosition.getIndex();
                }
                if (map != null && (object = JDK8.putIfAbsent(map, (Object)object2, (Object)object2)) != null) {
                    object2 = object;
                }
                linkedList.add(object2);
            }
            n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)n3, (int)n2);
            if (string.regionMatches(n3, string2, 0, string2.length())) {
                n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n3 + string2.length()), (int)n2);
                continue;
            }
            if (n3 >= n2) break;
            n6 = string.codePointAt(n3);
            if (n6 == n) {
                parsePosition.setIndex(n3 + Character.charCount(n6));
                this.list = map != null ? UnmodifiableArrayList.wrap((Object[])linkedList.toArray()) : linkedList;
                return;
            }
            parsePosition.setErrorIndex(n3);
            throw this.unparsableString(string, parsePosition);
        }
        throw this.missingCharacter(n, n3, parsePosition);
    }

    private static int regionMatches(String string, int n, String string2) {
        int n2;
        if (string.regionMatches(true, n, string2, 0, string2.length()) && ((n2 = n + string2.length()) >= string.length() || !Character.isUnicodeIdentifierPart(string.codePointAt(n2)))) {
            return n2;
        }
        return n;
    }

    final ParseException parseFailed(Exception exception) {
        return (ParseException)new LocalizedParseException(this.locale, 190, (Object[])new String[]{this.keyword, Exceptions.getLocalizedMessage((Throwable)exception, (Locale)this.locale)}, this.offset).initCause((Throwable)exception);
    }

    private ParseException unparsableString(String string, ParsePosition parsePosition) {
        CharSequence[] charSequenceArray;
        short s;
        int n;
        int n2 = Math.max(this.offset, parsePosition.getErrorIndex());
        if (n2 == (n = string.length())) {
            s = 110;
            charSequenceArray = new String[]{this.keyword};
        } else {
            s = 187;
            charSequenceArray = new CharSequence[]{this.keyword, CharSequences.token((CharSequence)string, (int)n2)};
        }
        parsePosition.setIndex(this.offset);
        return new LocalizedParseException(this.locale, s, (Object[])charSequenceArray, n2);
    }

    private ParseException missingCharacter(int n, int n2, ParsePosition parsePosition) {
        parsePosition.setIndex(this.offset);
        parsePosition.setErrorIndex(n2);
        StringBuilder stringBuilder = new StringBuilder(2).appendCodePoint(n);
        return new LocalizedParseException(this.locale, 188, (Object[])new CharSequence[]{this.keyword, stringBuilder}, n2);
    }

    final ParseException missingComponent(String string) {
        int n = this.offset;
        if (this.keyword != null) {
            n += this.keyword.length();
        }
        return new LocalizedParseException(this.locale, 189, (Object[])new String[]{this.keyword, string}, n);
    }

    /*
     * WARNING - void declaration
     */
    final ParseException missingOrUnknownComponent(String string) {
        void var4_8;
        short s;
        String string2 = null;
        for (Object objectArray2 : this.list) {
            if (objectArray2 instanceof Element && (string2 = ((Element)objectArray2).keyword) != null) break;
        }
        if (string2 != null) {
            s = 192;
            String[] stringArray = new String[]{string2};
        } else {
            s = 189;
            String[] stringArray = new String[]{this.keyword, string};
        }
        return new LocalizedParseException(this.locale, s, (Object[])var4_8, this.offset);
    }

    final ParseException illegalCS(CoordinateSystem coordinateSystem) {
        String string;
        short s;
        if (coordinateSystem == null) {
            s = 95;
            string = "coordinateSystem";
        } else {
            s = 193;
            string = coordinateSystem.getName().getCode();
        }
        return new LocalizedParseException(this.locale, s, (Object[])new String[]{string}, this.offset);
    }

    public Object peekValue() {
        for (Object object : this.list) {
            if (object instanceof Element) continue;
            return object;
        }
        return null;
    }

    public Date pullDate(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Date)) continue;
            iterator.remove();
            return (Date)object;
        }
        throw this.missingComponent(string);
    }

    public double pullDouble(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingComponent(string);
    }

    public int pullInteger(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new LocalizedParseException(this.locale, 124, new Object[]{Integer.class, number}, this.offset);
            }
            return number.intValue();
        }
        throw this.missingComponent(string);
    }

    public boolean pullBoolean(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Boolean)) continue;
            iterator.remove();
            return (Boolean)object;
        }
        throw this.missingComponent(string);
    }

    public String pullString(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        throw this.missingComponent(string);
    }

    public Object pullObject(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            iterator.remove();
            return object;
        }
        throw this.missingComponent(string);
    }

    public Element pullElement(int n, String ... stringArray) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!element.keyword.equalsIgnoreCase(stringArray[i])) continue;
                element.keywordIndex = (byte)i;
                iterator.remove();
                return element;
            }
            if (n != 0) continue;
            return null;
        }
        if (n != 2) {
            return null;
        }
        throw this.missingComponent(stringArray[0]);
    }

    public Element pullVoidElement(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list != null) continue;
            iterator.remove();
            return element;
        }
        throw this.missingComponent(string);
    }

    public <T> T pullOptional(Class<T> clazz) {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!clazz.isInstance(object)) continue;
            iterator.remove();
            return (T)object;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    final int getKeywordIndex() {
        return this.keywordIndex;
    }

    final void close(Map<String, List<String>> map) throws ParseException {
        if (this.list != null) {
            for (Object object : this.list) {
                if (object instanceof Element) {
                    CollectionsExt.addToMultiValuesMap(map, (Object)((Element)object).keyword, (Object)this.keyword);
                    continue;
                }
                throw new LocalizedParseException(this.locale, 191, new Object[]{this.keyword, object}, this.offset + this.keyword.length());
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, 0, JDK7.lineSeparator());
        return stringBuilder.toString();
    }

    private void format(StringBuilder stringBuilder, int n, String string) {
        stringBuilder.append(CharSequences.spaces((int)n)).append(this.keyword);
        if (this.list != null) {
            stringBuilder.append('[');
            n += 4;
            boolean bl = false;
            for (Object object : this.list) {
                if (object instanceof Element) {
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string);
                    ((Element)object).format(stringBuilder, n, string);
                } else {
                    boolean bl2 = object instanceof CharSequence;
                    if (bl) {
                        stringBuilder.append(", ");
                    }
                    if (bl2) {
                        stringBuilder.append('\u201c');
                    }
                    stringBuilder.append(object);
                    if (bl2) {
                        stringBuilder.append('\u201d');
                    }
                }
                bl = true;
            }
            stringBuilder.append(']');
        }
    }
}

