/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;

final class VerticalInfo {
    private VerticalInfo next;
    private final DefaultVerticalExtent extent;
    final Unit<Length> unit;
    private VerticalCRS compatibleCRS;

    VerticalInfo(VerticalInfo verticalInfo, DefaultExtent defaultExtent, double d, double d2, Unit<Length> unit) {
        this.next = verticalInfo;
        this.unit = unit;
        this.extent = new DefaultVerticalExtent(d, d2, null);
        defaultExtent.getVerticalElements().add(this.extent);
    }

    final VerticalInfo resolve(VerticalCRS verticalCRS) {
        if (verticalCRS != null && VerticalDatumType.GEOIDAL.equals((Object)verticalCRS.getDatum().getVerticalDatumType())) {
            return this.resolve(verticalCRS, verticalCRS.getCoordinateSystem().getAxis(0));
        }
        return this;
    }

    private VerticalInfo resolve(VerticalCRS verticalCRS, CoordinateSystemAxis coordinateSystemAxis) {
        if (this.next != null) {
            this.next = this.next.resolve(verticalCRS, coordinateSystemAxis);
        }
        Unit unit = coordinateSystemAxis.getUnit();
        if (AxisDirection.UP.equals((Object)coordinateSystemAxis.getDirection()) && this.unit.equals((Object)unit)) {
            this.extent.setVerticalCRS(verticalCRS);
            return this.next;
        }
        if (this.unit.isCompatible(unit)) {
            this.compatibleCRS = verticalCRS;
        }
        return this;
    }

    final VerticalInfo complete(CRSFactory cRSFactory, CSFactory cSFactory) throws FactoryException {
        String string;
        String string2;
        if (this.next != null) {
            this.next = this.next.complete(cRSFactory, cSFactory);
        }
        if (this.compatibleCRS == null) {
            return this;
        }
        CoordinateSystemAxis coordinateSystemAxis = this.compatibleCRS.getCoordinateSystem().getAxis(0);
        boolean bl = AxisDirection.UP.equals((Object)coordinateSystemAxis.getDirection());
        if (bl) {
            string2 = coordinateSystemAxis.getName();
            string = coordinateSystemAxis.getAbbreviation();
        } else {
            string2 = "Gravity-related height";
            string = "H";
        }
        coordinateSystemAxis = cSFactory.createCoordinateSystemAxis(VerticalInfo.properties(string2), string, AxisDirection.UP, this.unit);
        VerticalCS verticalCS = cSFactory.createVerticalCS(VerticalInfo.properties(coordinateSystemAxis.getName()), coordinateSystemAxis);
        this.extent.setVerticalCRS(cRSFactory.createVerticalCRS(VerticalInfo.properties((bl ? this.compatibleCRS : coordinateSystemAxis).getName()), this.compatibleCRS.getDatum(), verticalCS));
        return this.next;
    }

    private static Map<String, ?> properties(Object object) {
        return Collections.singletonMap("name", object);
    }
}

