/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Warnings
implements Localized,
Serializable {
    private static final long serialVersionUID = -1825161781642905329L;
    private final Locale errorLocale;
    private final boolean isParsing;
    private String root;
    private List<Object> messages;
    private Map<Exception, String[]> exceptionSources;
    private Map<String, List<String>> ignoredElements;
    private boolean published;

    Warnings(Locale locale, boolean bl, Map<String, List<String>> map) {
        this.errorLocale = locale;
        this.isParsing = bl;
        this.ignoredElements = map;
    }

    final void setRoot(Object object) {
        ReferenceIdentifier referenceIdentifier;
        if (object instanceof IdentifiedObject && (referenceIdentifier = ((IdentifiedObject)object).getName()) != null && (this.root = referenceIdentifier.getCode()) != null) {
            return;
        }
        this.root = Classes.getShortClassName((Object)object);
    }

    final void add(InternationalString internationalString, Exception exception, String[] stringArray) {
        assert (internationalString != null || exception != null);
        if (this.messages == null) {
            this.messages = new ArrayList<Object>(4);
        }
        this.messages.add(internationalString);
        this.messages.add(exception);
        if (exception != null) {
            if (this.exceptionSources == null) {
                this.exceptionSources = new LinkedHashMap<Exception, String[]>(4);
            }
            this.exceptionSources.put(exception, stringArray);
        }
    }

    final void publish() {
        if (!this.published) {
            this.ignoredElements = this.ignoredElements.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, List<String>>(this.ignoredElements);
            this.published = true;
        }
    }

    public Locale getLocale() {
        return this.errorLocale;
    }

    public String getRootElement() {
        return this.root;
    }

    public final int getNumMessages() {
        return this.messages != null ? this.messages.size() / 2 : 0;
    }

    public String getMessage(int n) {
        ArgumentChecks.ensureValidIndex((int)this.getNumMessages(), (int)n);
        InternationalString internationalString = (InternationalString)this.messages.get(n *= 2);
        if (internationalString != null) {
            return internationalString.toString(this.errorLocale);
        }
        Exception exception = (Exception)this.messages.get(n + 1);
        String[] stringArray = this.exceptionSources.get(exception);
        if (stringArray != null) {
            return Errors.getResources((Locale)this.errorLocale).getString((short)187, (Object)stringArray);
        }
        return exception.toString();
    }

    public Exception getException(int n) {
        ArgumentChecks.ensureValidIndex((int)this.getNumMessages(), (int)n);
        return (Exception)this.messages.get(n * 2 + 1);
    }

    public Set<Exception> getExceptions() {
        return this.exceptionSources != null ? this.exceptionSources.keySet() : Collections.emptySet();
    }

    public String[] getExceptionSource(Exception exception) {
        return this.exceptionSources != null ? this.exceptionSources.get(exception) : null;
    }

    public Set<String> getUnknownElements() {
        return this.ignoredElements.keySet();
    }

    public Collection<String> getUnknownElementLocations(String string) {
        return this.ignoredElements.get(string);
    }

    public String toString() {
        return this.toString(this.errorLocale);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Locale locale) {
        String string;
        Vocabulary vocabulary;
        StringBuilder stringBuilder = new StringBuilder(250);
        String string2 = JDK7.lineSeparator();
        Messages messages = Messages.getResources((Locale)locale);
        stringBuilder.append(messages.getString(this.isParsing ? (short)14 : 15, (Object)this.root)).append(string2);
        if (this.messages != null) {
            vocabulary = this.messages.iterator();
            while (vocabulary.hasNext()) {
                void object2;
                Object object;
                InternationalString internationalString = (InternationalString)vocabulary.next();
                Exception exception = (Exception)vocabulary.next();
                if (internationalString != null) {
                    string = internationalString.toString(locale);
                } else {
                    object = this.exceptionSources.get(exception);
                    if (object != null) {
                        string = Errors.getResources((Locale)locale).getString((short)187, object);
                    } else {
                        string = exception.toString();
                        Object var7_9 = null;
                    }
                }
                stringBuilder.append("\u00a0\u2022\u00a0").append(string).append(string2);
                if (object2 == null) continue;
                object = Exceptions.getLocalizedMessage((Throwable)object2, (Locale)locale);
                if (object == null) {
                    object = object2.toString();
                }
                stringBuilder.append("\u00a0\u00a0\u00a0").append((String)object).append(string2);
            }
        }
        if (!this.ignoredElements.isEmpty()) {
            vocabulary = Vocabulary.getResources((Locale)locale);
            stringBuilder.append("\u00a0\u2022\u00a0").append(messages.getString((short)13)).append(string2);
            for (Map.Entry entry : this.ignoredElements.entrySet()) {
                stringBuilder.append("\u00a0\u00a0\u00a0\u00a0\u2023\u00a0").append(vocabulary.getString((short)86, entry.getKey()));
                string = vocabulary.getString((short)87);
                for (String string3 : (List)entry.getValue()) {
                    stringBuilder.append(string).append(string3);
                    string = ", ";
                }
                stringBuilder.append('.').append(string2);
            }
        }
        return stringBuilder.toString();
    }
}

