/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.util.collection.Containers;

final class Cloner
extends org.apache.sis.internal.util.Cloner {
    Cloner() {
    }

    protected boolean isCloneRequired(Object object) {
        return false;
    }

    public Object clone(Object object) throws CloneNotSupportedException {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection<Object> collection = (List<Object>)object;
            boolean bl = collection instanceof Set;
            if (collection.isEmpty()) {
                collection = bl ? Collections.EMPTY_SET : Collections.EMPTY_LIST;
            } else {
                Object[] objectArray = collection.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.clone(objectArray[i]);
                }
                if (bl) {
                    collection = CollectionsExt.immutableSet((boolean)false, (Object[])objectArray);
                } else {
                    switch (objectArray.length) {
                        case 0: {
                            collection = Collections.EMPTY_LIST;
                            break;
                        }
                        case 1: {
                            collection = Collections.singletonList(objectArray[0]);
                            break;
                        }
                        default: {
                            collection = Containers.unmodifiableList((Object[])objectArray);
                        }
                    }
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap linkedHashMap = new LinkedHashMap((Map)object);
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                entry.setValue(this.clone(entry.getValue()));
            }
            return CollectionsExt.unmodifiableOrCopy(linkedHashMap);
        }
        if (object instanceof Cloneable) {
            return super.clone(object);
        }
        return object;
    }
}

