/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sis.internal.jdk8.BiFunction;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.metadata.InformationMap;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.NameMap;
import org.apache.sis.metadata.ObjectPair;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.RecursivityGuard;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.StandardImplementation;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeMap;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.ValueMap;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.Citation;

public class MetadataStandard
implements Serializable {
    private static final long serialVersionUID = 7549790450195184843L;
    static final boolean IMPLEMENTATION_CAN_ALTER_API = true;
    private static final MetadataStandard[] INSTANCES;
    public static final MetadataStandard ISO_19111;
    public static final MetadataStandard ISO_19115;
    public static final MetadataStandard ISO_19123;
    final Citation citation;
    final String interfacePackage;
    private final MetadataStandard[] dependencies;
    private final transient ConcurrentMap<Class<?>, Object> accessors;

    public MetadataStandard(Citation citation, Package package_, MetadataStandard ... metadataStandardArray) {
        ArgumentChecks.ensureNonNull((String)"citation", (Object)citation);
        ArgumentChecks.ensureNonNull((String)"interfacePackage", (Object)package_);
        ArgumentChecks.ensureNonNull((String)"dependencies", (Object)metadataStandardArray);
        this.citation = citation;
        this.interfacePackage = package_.getName() + '.';
        this.accessors = new ConcurrentHashMap();
        if (metadataStandardArray.length == 0) {
            this.dependencies = null;
        } else {
            metadataStandardArray = (MetadataStandard[])metadataStandardArray.clone();
            this.dependencies = metadataStandardArray;
            for (int i = 0; i < metadataStandardArray.length; ++i) {
                ArgumentChecks.ensureNonNullElement((String)"dependencies", (int)i, (Object)metadataStandardArray[i]);
            }
        }
    }

    MetadataStandard(String string, String string2, MetadataStandard[] metadataStandardArray) {
        this.citation = new SimpleCitation(string);
        this.interfacePackage = string2;
        this.accessors = new ConcurrentHashMap();
        this.dependencies = metadataStandardArray;
    }

    final boolean isSupported(String string) {
        return string.startsWith(this.interfacePackage);
    }

    public static MetadataStandard forClass(Class<?> clazz) {
        String string = clazz.getName();
        for (MetadataStandard serializable : INSTANCES) {
            if (!serializable.isSupported(string)) continue;
            return serializable;
        }
        for (Serializable serializable : Classes.getAllInterfaces(clazz)) {
            string = ((Class)serializable).getName();
            for (MetadataStandard metadataStandard : INSTANCES) {
                if (!metadataStandard.isSupported(string)) continue;
                return metadataStandard;
            }
        }
        return null;
    }

    static void clearCache() {
        for (MetadataStandard metadataStandard : INSTANCES) {
            metadataStandard.accessors.clear();
        }
    }

    public Citation getCitation() {
        return this.citation;
    }

    final PropertyAccessor getAccessor(final Class<?> clazz, boolean bl) {
        Class<?> clazz2;
        Object v = this.accessors.get(clazz);
        if (v instanceof PropertyAccessor) {
            return (PropertyAccessor)v;
        }
        if (v instanceof Class) {
            clazz2 = (Class<?>)v;
            assert (clazz2 == this.findInterface(clazz)) : clazz;
        } else {
            clazz2 = this.findInterface(clazz);
            if (clazz2 == null) {
                if (this.dependencies != null) {
                    for (MetadataStandard metadataStandard : this.dependencies) {
                        PropertyAccessor propertyAccessor = metadataStandard.getAccessor(clazz, false);
                        if (propertyAccessor == null) continue;
                        this.accessors.put(clazz, propertyAccessor);
                        return propertyAccessor;
                    }
                }
                if (bl) {
                    throw new ClassCastException(Errors.format((short)118, clazz));
                }
                return null;
            }
        }
        return (PropertyAccessor)JDK8.compute(this.accessors, clazz, (BiFunction)new BiFunction<Class<?>, Object, Object>(){

            public Object apply(Class<?> clazz3, Object object) {
                if (object instanceof PropertyAccessor) {
                    return object;
                }
                PropertyAccessor propertyAccessor = SpecialCases.isSpecialCase(clazz2) ? new SpecialCases(MetadataStandard.this.citation, clazz2, clazz) : new PropertyAccessor(MetadataStandard.this.citation, clazz2, clazz);
                return propertyAccessor;
            }
        });
    }

    public boolean isMetadata(Class<?> clazz) {
        if (clazz != null) {
            Object object;
            if (this.accessors.containsKey(clazz)) {
                return true;
            }
            if (this.dependencies != null) {
                object = this.dependencies;
                int n = ((MetadataStandard[])object).length;
                for (int i = 0; i < n; ++i) {
                    MetadataStandard metadataStandard = object[i];
                    if (!metadataStandard.isMetadata(clazz)) continue;
                    this.accessors.putIfAbsent(clazz, metadataStandard);
                    return true;
                }
            }
            if ((object = this.findInterface(clazz)) != null) {
                this.accessors.putIfAbsent(clazz, object);
                return true;
            }
        }
        return false;
    }

    boolean isPendingAPI(Class<?> clazz) {
        return false;
    }

    private Class<?> findInterface(Class<?> clazz) {
        if (clazz != null) {
            if (clazz.isInterface()) {
                if (this.isSupported(clazz.getName())) {
                    return clazz;
                }
            } else {
                Class clazz2;
                Iterator iterator;
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                for (iterator = clazz; iterator != null; iterator = ((Class)((Object)iterator)).getSuperclass()) {
                    this.getInterfaces((Class<?>)((Object)iterator), linkedHashSet);
                }
                iterator = linkedHashSet.iterator();
                block1: while (iterator.hasNext()) {
                    clazz2 = (Class)iterator.next();
                    for (Class clazz3 : linkedHashSet) {
                        if (clazz2 == clazz3 || !clazz2.isAssignableFrom(clazz3)) continue;
                        iterator.remove();
                        continue block1;
                    }
                }
                iterator = linkedHashSet.iterator();
                if (iterator.hasNext()) {
                    clazz2 = (Class)iterator.next();
                    if (!iterator.hasNext()) {
                        return clazz2;
                    }
                } else if (this.isPendingAPI(clazz)) {
                    return clazz;
                }
            }
        }
        return null;
    }

    private void getInterfaces(Class<?> clazz, Collection<Class<?>> collection) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (this.isSupported(clazz2.getName())) {
                collection.add(clazz2);
            }
            this.getInterfaces(clazz2, collection);
        }
    }

    public <T> Class<? super T> getInterface(Class<T> clazz) throws ClassCastException {
        Class<T> clazz2;
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        Object v = this.accessors.get(clazz);
        if (v instanceof PropertyAccessor) {
            clazz2 = ((PropertyAccessor)v).type;
        } else if (v instanceof Class) {
            clazz2 = (Class<T>)v;
        } else if (v instanceof MetadataStandard) {
            clazz2 = ((MetadataStandard)v).getInterface(clazz);
        } else {
            clazz2 = this.findInterface(clazz);
            if (clazz2 != null) {
                this.accessors.putIfAbsent(clazz, clazz2);
            } else {
                if (this.dependencies != null) {
                    for (MetadataStandard metadataStandard : this.dependencies) {
                        if (!metadataStandard.isMetadata(clazz)) continue;
                        this.accessors.putIfAbsent(clazz, metadataStandard);
                        return metadataStandard.getInterface(clazz);
                    }
                }
                throw new ClassCastException(Errors.format((short)118, clazz));
            }
        }
        assert (clazz2.isAssignableFrom(clazz)) : clazz;
        return clazz2;
    }

    public <T> Class<? extends T> getImplementation(Class<T> clazz) {
        return null;
    }

    public Map<String, String> asNameMap(Class<?> clazz, KeyNamePolicy keyNamePolicy, KeyNamePolicy keyNamePolicy2) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"keyPolicy", (Object)((Object)keyNamePolicy));
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)keyNamePolicy2));
        Class<?> clazz2 = this.getImplementation(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        return new NameMap(this.getAccessor(clazz, true), keyNamePolicy, keyNamePolicy2);
    }

    public Map<String, Class<?>> asTypeMap(Class<?> clazz, KeyNamePolicy keyNamePolicy, TypeValuePolicy typeValuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"keyPolicy", (Object)((Object)keyNamePolicy));
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)typeValuePolicy));
        Class<?> clazz2 = this.getImplementation(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        return new TypeMap(this.getAccessor(clazz, true), keyNamePolicy, typeValuePolicy);
    }

    public Map<String, ExtendedElementInformation> asInformationMap(Class<?> clazz, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"keyNames", (Object)((Object)keyNamePolicy));
        Class<?> clazz2 = this.getImplementation(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        return new InformationMap(this.getAccessor(clazz, true), keyNamePolicy);
    }

    public Map<String, Object> asValueMap(Object object, KeyNamePolicy keyNamePolicy, ValueExistencePolicy valueExistencePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"metadata", (Object)object);
        ArgumentChecks.ensureNonNull((String)"keyPolicy", (Object)((Object)keyNamePolicy));
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)valueExistencePolicy));
        return new ValueMap(object, this.getAccessor(object.getClass(), true), keyNamePolicy, valueExistencePolicy);
    }

    public TreeTable asTreeTable(Object object, ValueExistencePolicy valueExistencePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"metadata", (Object)object);
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)valueExistencePolicy));
        return new TreeTableView(this, object, valueExistencePolicy);
    }

    final void freeze(Object object) throws ClassCastException {
        this.getAccessor(object.getClass(), true).freeze(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object, Object object2, ComparisonMode comparisonMode) throws ClassCastException {
        Class<?> clazz;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2 != (clazz = object2.getClass()) && comparisonMode == ComparisonMode.STRICT) {
            return false;
        }
        PropertyAccessor propertyAccessor = this.getAccessor(clazz2, true);
        if (!(clazz2 == clazz || propertyAccessor.type.isAssignableFrom(clazz) && propertyAccessor.type == this.getAccessor(clazz, (boolean)false).type)) {
            return false;
        }
        ObjectPair objectPair = new ObjectPair(object, object2);
        Set<ObjectPair> set = ObjectPair.CURRENT.get();
        if (set.add(objectPair)) {
            boolean bl = Semaphores.queryAndSet((byte)4);
            try {
                boolean bl2 = propertyAccessor.equals(object, object2, comparisonMode);
                return bl2;
            }
            finally {
                set.remove(objectPair);
                if (!bl) {
                    Semaphores.clear((byte)4);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode(Object object) throws ClassCastException {
        Map map;
        if (object != null && (map = (Map)RecursivityGuard.HASH_CODES.get()).put(object, Boolean.TRUE) == null) {
            boolean bl = Semaphores.queryAndSet((byte)4);
            try {
                int n = this.getAccessor(object.getClass(), true).hashCode(object);
                return n;
            }
            finally {
                map.remove(object);
                if (!bl) {
                    Semaphores.clear((byte)4);
                }
            }
        }
        return 0;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.citation.getTitle() + ']';
    }

    final void setMapForField(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            field.set(this, new ConcurrentHashMap());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setMapForField(MetadataStandard.class, "accessors");
    }

    static {
        String[] stringArray = new String[]{"Default", "Abstract"};
        String[] stringArray2 = new String[]{"CoordinateSystem", "CS", "CoordinateReferenceSystem", "CRS"};
        ISO_19115 = new StandardImplementation("ISO 19115", "org.opengis.metadata.", "org.apache.sis.metadata.iso.", stringArray, null, null);
        ISO_19111 = new StandardImplementation("ISO 19111", "org.opengis.referencing.", "org.apache.sis.referencing.", stringArray, stringArray2, new MetadataStandard[]{ISO_19115});
        ISO_19123 = new MetadataStandard("ISO 19123", "org.opengis.coverage.", new MetadataStandard[]{ISO_19111});
        INSTANCES = new MetadataStandard[]{ISO_19111, ISO_19115, ISO_19123};
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.metadata"){

            protected void classpathChanged() {
                MetadataStandard.clearCache();
            }
        });
    }
}

