/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.internal.util.CheckedHashSet;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.CodeList;

@XmlTransient
public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final int INITIAL_CAPACITY = 4;
    private static final ModifiableMetadata FREEZING = new Null();
    private transient ModifiableMetadata unmodifiable;

    protected ModifiableMetadata() {
    }

    public final boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata modifiableMetadata;
            try {
                modifiableMetadata = this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.metadata"), this.getClass(), (String)"unmodifiable", (Throwable)cloneNotSupportedException);
                return this;
            }
            modifiableMetadata.freeze();
            this.unmodifiable = modifiableMetadata;
        }
        assert (!this.unmodifiable.isModifiable());
        return this.unmodifiable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze() {
        if (this.isModifiable()) {
            ModifiableMetadata modifiableMetadata = null;
            boolean bl = Semaphores.queryAndSet((byte)4);
            try {
                this.unmodifiable = FREEZING;
                this.getStandard().freeze(this);
                modifiableMetadata = this;
            }
            finally {
                this.unmodifiable = modifiableMetadata;
                if (!bl) {
                    Semaphores.clear((byte)4);
                }
            }
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        if (!this.isModifiable()) {
            throw new UnmodifiableMetadataException(Errors.format((short)122));
        }
        this.unmodifiable = null;
    }

    protected final <E> List<E> writeList(Collection<? extends E> collection, List<E> checkedArrayList, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != checkedArrayList) {
            if (this.unmodifiable == FREEZING) {
                return (List)collection;
            }
            this.checkWritePermission();
            if (Containers.isNullOrEmpty(collection)) {
                checkedArrayList = null;
            } else {
                if (checkedArrayList != null) {
                    checkedArrayList.clear();
                } else {
                    checkedArrayList = new CheckedArrayList(clazz, collection.size());
                }
                checkedArrayList.addAll(collection);
            }
        }
        return checkedArrayList;
    }

    protected final <E> Set<E> writeSet(Collection<? extends E> collection, Set<E> checkedHashSet, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != checkedHashSet) {
            if (this.unmodifiable == FREEZING) {
                return (Set)collection;
            }
            this.checkWritePermission();
            if (Containers.isNullOrEmpty(collection)) {
                checkedHashSet = null;
            } else {
                if (checkedHashSet != null) {
                    checkedHashSet.clear();
                } else {
                    checkedHashSet = new CheckedHashSet(clazz, collection.size());
                }
                checkedHashSet.addAll(collection);
            }
        }
        return checkedHashSet;
    }

    protected final <E> Collection<E> writeCollection(Collection<? extends E> collection, Collection<E> object, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != object) {
            if (this.unmodifiable == FREEZING) {
                assert (this.collectionType(clazz).isInstance(collection));
                return collection;
            }
            this.checkWritePermission();
            if (Containers.isNullOrEmpty(collection)) {
                object = null;
            } else {
                if (object != null) {
                    object.clear();
                } else {
                    int n = collection.size();
                    object = this.useSet(clazz) ? this.createSet(clazz, n) : new CheckedArrayList(clazz, n);
                }
                object.addAll(collection);
            }
        }
        return object;
    }

    protected final <E> List<E> copyList(Collection<? extends E> collection, Class<E> clazz) {
        if (Containers.isNullOrEmpty(collection)) {
            return null;
        }
        CheckedArrayList checkedArrayList = new CheckedArrayList(clazz, collection.size());
        checkedArrayList.addAll(collection);
        return checkedArrayList;
    }

    protected final <E> Set<E> copySet(Collection<? extends E> collection, Class<E> clazz) {
        if (Containers.isNullOrEmpty(collection)) {
            return null;
        }
        CheckedHashSet checkedHashSet = new CheckedHashSet(clazz, collection.size());
        checkedHashSet.addAll(collection);
        return checkedHashSet;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> collection, Class<E> clazz) {
        if (Containers.isNullOrEmpty(collection)) {
            return null;
        }
        int n = collection.size();
        CheckedArrayList checkedArrayList = this.useSet(clazz) ? this.createSet(clazz, n) : new CheckedArrayList(clazz, n);
        checkedArrayList.addAll(collection);
        return checkedArrayList;
    }

    protected final <E> Collection<E> singleton(E e, Class<E> clazz) {
        if (e == null) {
            return null;
        }
        CheckedArrayList checkedArrayList = this.useSet(clazz) ? this.createSet(clazz, 4) : new CheckedArrayList(clazz, 1);
        checkedArrayList.add(e);
        return checkedArrayList;
    }

    private static boolean emptyCollectionAsNull() {
        return Semaphores.query((byte)4);
    }

    protected final <E> List<E> nonNullList(List<E> list, Class<E> clazz) {
        if (list != null) {
            return list.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : list;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.isModifiable()) {
            return new CheckedArrayList(clazz);
        }
        return Collections.emptyList();
    }

    protected final <E> Set<E> nonNullSet(Set<E> set, Class<E> clazz) {
        if (set != null) {
            return set.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : set;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.isModifiable()) {
            return this.createSet(clazz, 4);
        }
        return Collections.emptySet();
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> collection, Class<E> clazz) {
        if (collection != null) {
            assert (this.collectionType(clazz).isInstance(collection));
            return collection.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : collection;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        boolean bl = this.isModifiable();
        if (this.useSet(clazz)) {
            if (bl) {
                return this.createSet(clazz, 4);
            }
            return Collections.emptySet();
        }
        if (bl) {
            return new CheckedArrayList(clazz);
        }
        return Collections.emptyList();
    }

    private <E> Set<E> createSet(Class<E> clazz, int n) {
        if (Enum.class.isAssignableFrom(clazz)) {
            return EnumSet.noneOf(clazz);
        }
        if (CodeList.class.isAssignableFrom(clazz) && Modifier.isFinal(clazz.getModifiers())) {
            return new CodeListSet(clazz);
        }
        return new CheckedHashSet(clazz, n);
    }

    private <E> boolean useSet(Class<E> clazz) {
        Class<Collection<E>> clazz2 = this.collectionType(clazz);
        if (Set.class == clazz2) {
            return true;
        }
        if (List.class == clazz2) {
            return false;
        }
        throw new NoSuchElementException(Errors.format((short)129, clazz2));
    }

    protected <E> Class<? extends Collection<E>> collectionType(Class<E> clazz) {
        return CodeList.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || Charset.class.isAssignableFrom(clazz) || String.class == clazz || Locale.class == clazz || Currency.class == clazz ? Set.class : List.class;
    }

    protected ModifiableMetadata clone() throws CloneNotSupportedException {
        return (ModifiableMetadata)super.clone();
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        @Override
        public MetadataStandard getStandard() {
            return null;
        }
    }
}

