/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.List;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.citation.Citation;

public final class Citations
extends Static {
    @Deprecated
    public static final Citation ISO = new SimpleCitation("ISO");
    public static final List<Citation> ISO_19115 = UnmodifiableArrayList.wrap((Object[])new CitationConstant[]{new CitationConstant("ISO 19115-1"), new CitationConstant("ISO 19115-2")});
    @Deprecated
    public static final Citation OGP = new SimpleCitation("OGP");
    public static final IdentifierSpace<Integer> EPSG = new CitationConstant.Authority("EPSG");
    public static final IdentifierSpace<String> OGC = new CitationConstant.Authority("OGC");
    public static final IdentifierSpace<String> ESRI = new CitationConstant.Authority("ESRI");
    @Deprecated
    public static final Citation ORACLE = new CitationConstant("Oracle");
    public static final IdentifierSpace<String> NETCDF = new CitationConstant.Authority("NetCDF");
    public static final IdentifierSpace<Integer> GEOTIFF = new CitationConstant.Authority("GeoTIFF");
    public static final IdentifierSpace<String> PROJ4 = new CitationConstant.Authority("Proj4");
    public static final IdentifierSpace<Integer> MAP_INFO = new CitationConstant.Authority("MapInfo");
    public static final IdentifierSpace<Integer> S57 = new CitationConstant.Authority("S57");
    public static final IdentifierSpace<String> ISBN = new NonMarshalledAuthority("ISBN", 5);
    public static final IdentifierSpace<String> ISSN = new NonMarshalledAuthority("ISSN", 4);
    public static final Citation SIS = new CitationConstant("SIS");
    private static final SimpleCitation[] CITATIONS = new SimpleCitation[]{(SimpleCitation)EPSG, (SimpleCitation)OGC, (SimpleCitation)ESRI, (SimpleCitation)NETCDF, (SimpleCitation)GEOTIFF, (SimpleCitation)PROJ4, (SimpleCitation)MAP_INFO, (SimpleCitation)S57, (SimpleCitation)ISBN, (SimpleCitation)ISSN, (SimpleCitation)SIS, (SimpleCitation)ISO_19115.get(0), (SimpleCitation)ISO_19115.get(1), (SimpleCitation)OGP, (SimpleCitation)ISO, (SimpleCitation)ORACLE};

    private Citations() {
    }

    static void refresh() {
        for (SimpleCitation simpleCitation : CITATIONS) {
            if (!(simpleCitation instanceof CitationConstant)) continue;
            ((CitationConstant)simpleCitation).refresh();
        }
    }

    public static Citation fromName(String string) {
        if (string == null || (string = CharSequences.trimWhitespaces((String)string)).isEmpty()) {
            return null;
        }
        for (SimpleCitation simpleCitation : CITATIONS) {
            if (!org.apache.sis.internal.util.Citations.equalsFiltered((CharSequence)string, (CharSequence)simpleCitation.title)) continue;
            return simpleCitation;
        }
        if (org.apache.sis.internal.util.Citations.equalsFiltered((CharSequence)string, (CharSequence)"IOGP")) {
            return OGP;
        }
        return new SimpleCitation(string);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        return org.apache.sis.internal.util.Citations.titleMatches((Citation)citation, (Citation)citation2);
    }

    public static boolean titleMatches(Citation citation, String string) {
        return org.apache.sis.internal.util.Citations.titleMatches((Citation)citation, (CharSequence)string);
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        return org.apache.sis.internal.util.Citations.identifierMatches((Citation)citation, (Citation)citation2);
    }

    public static boolean identifierMatches(Citation citation, String string) {
        return org.apache.sis.internal.util.Citations.identifierMatches((Citation)citation, null, (CharSequence)string);
    }

    public static String getIdentifier(Citation citation) {
        return org.apache.sis.internal.util.Citations.getIdentifier((Citation)citation, (boolean)false);
    }

    public static String getUnicodeIdentifier(Citation citation) {
        return org.apache.sis.internal.util.Citations.getUnicodeIdentifier((Citation)citation);
    }

    static {
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.metadata"){

            protected void classpathChanged() {
                Citations.refresh();
            }

            protected void databaseChanged() {
                Citations.refresh();
            }
        });
    }
}

