/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.IdentifierMap;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Citation_Type", propOrder={"title", "alternateTitles", "dates", "edition", "editionDate", "identifiers", "citedResponsibleParties", "presentationForms", "series", "otherCitationDetails", "collectiveTitle", "ISBN", "ISSN"})
@XmlRootElement(name="CI_Citation")
public class DefaultCitation
extends ISOMetadata
implements Citation {
    private static final long serialVersionUID = 3490090845236158848L;
    private InternationalString title;
    private Collection<InternationalString> alternateTitles;
    private Collection<CitationDate> dates;
    private InternationalString edition;
    private long editionDate = Long.MIN_VALUE;
    private Collection<ResponsibleParty> citedResponsibleParties;
    private Collection<PresentationForm> presentationForms;
    private Series series;
    private InternationalString otherCitationDetails;
    @Deprecated
    private InternationalString collectiveTitle;
    private Collection<OnlineResource> onlineResources;
    private Collection<BrowseGraphic> graphics;

    public DefaultCitation() {
    }

    public DefaultCitation(CharSequence charSequence) {
        this.title = Types.toInternationalString((CharSequence)charSequence);
    }

    @Deprecated
    public DefaultCitation(ResponsibleParty responsibleParty) {
        if (responsibleParty != null) {
            this.citedResponsibleParties = this.singleton(responsibleParty, ResponsibleParty.class);
            this.title = responsibleParty.getOrganisationName();
            if (this.title == null) {
                String string;
                this.title = responsibleParty.getPositionName();
                if (this.title == null && (string = responsibleParty.getIndividualName()) != null) {
                    this.title = new SimpleInternationalString(string);
                }
            }
        }
    }

    public DefaultCitation(Citation citation) {
        super(citation);
        if (citation != null) {
            Object object;
            this.title = citation.getTitle();
            this.alternateTitles = this.copyCollection(citation.getAlternateTitles(), InternationalString.class);
            this.dates = this.copyCollection(citation.getDates(), CitationDate.class);
            this.edition = citation.getEdition();
            this.editionDate = MetadataUtilities.toMilliseconds(citation.getEditionDate());
            this.identifiers = this.copyCollection(citation.getIdentifiers(), Identifier.class);
            this.citedResponsibleParties = this.copyCollection(citation.getCitedResponsibleParties(), ResponsibleParty.class);
            this.presentationForms = this.copyCollection(citation.getPresentationForms(), PresentationForm.class);
            this.series = citation.getSeries();
            this.otherCitationDetails = citation.getOtherCitationDetails();
            this.collectiveTitle = citation.getCollectiveTitle();
            if (citation instanceof DefaultCitation) {
                object = (DefaultCitation)citation;
                this.onlineResources = this.copyCollection(((DefaultCitation)object).getOnlineResources(), OnlineResource.class);
                this.graphics = this.copyCollection(((DefaultCitation)object).getGraphics(), BrowseGraphic.class);
            }
            object = citation.getISBN();
            String string = citation.getISSN();
            if (object != null || string != null) {
                IdentifierMap identifierMap = super.getIdentifierMap();
                if (object != null) {
                    identifierMap.putSpecialized(Citations.ISBN, object);
                }
                if (string != null) {
                    identifierMap.putSpecialized(Citations.ISSN, (Object)string);
                }
            }
        }
    }

    public static DefaultCitation castOrCopy(Citation citation) {
        if (citation == null || citation instanceof DefaultCitation) {
            return (DefaultCitation)citation;
        }
        return new DefaultCitation(citation);
    }

    @XmlElement(name="title", required=true)
    public InternationalString getTitle() {
        return this.title;
    }

    public void setTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.title = internationalString;
    }

    @XmlElement(name="alternateTitle")
    public Collection<InternationalString> getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public void setAlternateTitles(Collection<? extends InternationalString> collection) {
        this.alternateTitles = this.writeCollection(collection, this.alternateTitles, InternationalString.class);
    }

    @XmlElement(name="date", required=true)
    public Collection<CitationDate> getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public void setDates(Collection<? extends CitationDate> collection) {
        this.dates = this.writeCollection(collection, this.dates, CitationDate.class);
    }

    @XmlElement(name="edition")
    public InternationalString getEdition() {
        return this.edition;
    }

    public void setEdition(InternationalString internationalString) {
        this.checkWritePermission();
        this.edition = internationalString;
    }

    @XmlElement(name="editionDate")
    public Date getEditionDate() {
        return MetadataUtilities.toDate(this.editionDate);
    }

    public void setEditionDate(Date date) {
        this.checkWritePermission();
        this.editionDate = MetadataUtilities.toMilliseconds(date);
    }

    @Override
    @XmlElement(name="identifier")
    public Collection<Identifier> getIdentifiers() {
        return NonMarshalledAuthority.excludeOnMarshalling(super.getIdentifiers());
    }

    public void setIdentifiers(Collection<? extends Identifier> collection) {
        Collection collection2 = NonMarshalledAuthority.filteredCopy((Collection)this.identifiers);
        this.identifiers = this.writeCollection(collection, this.identifiers, Identifier.class);
        NonMarshalledAuthority.replace((Collection)this.identifiers, (Collection)collection2);
    }

    @XmlElement(name="citedResponsibleParty")
    public Collection<ResponsibleParty> getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public void setCitedResponsibleParties(Collection<? extends ResponsibleParty> collection) {
        this.citedResponsibleParties = this.writeCollection(collection, this.citedResponsibleParties, ResponsibleParty.class);
    }

    @XmlElement(name="presentationForm")
    public Collection<PresentationForm> getPresentationForms() {
        this.presentationForms = this.nonNullCollection(this.presentationForms, PresentationForm.class);
        return this.presentationForms;
    }

    public void setPresentationForms(Collection<? extends PresentationForm> collection) {
        this.presentationForms = this.writeCollection(collection, this.presentationForms, PresentationForm.class);
    }

    @XmlElement(name="series")
    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.checkWritePermission();
        this.series = series;
    }

    @XmlElement(name="otherCitationDetails")
    public InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public void setOtherCitationDetails(InternationalString internationalString) {
        this.checkWritePermission();
        this.otherCitationDetails = internationalString;
    }

    @Deprecated
    @XmlElement(name="collectiveTitle")
    public InternationalString getCollectiveTitle() {
        return this.collectiveTitle;
    }

    @Deprecated
    public void setCollectiveTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.collectiveTitle = internationalString;
    }

    @XmlElement(name="ISBN")
    public String getISBN() {
        return Containers.isNullOrEmpty((Collection)this.identifiers) ? null : (String)this.getIdentifierMap().get(Citations.ISBN);
    }

    public void setISBN(String string) {
        this.checkWritePermission();
        if (string != null || !Containers.isNullOrEmpty((Collection)this.identifiers)) {
            this.getIdentifierMap().putSpecialized(Citations.ISBN, (Object)string);
        }
    }

    @XmlElement(name="ISSN")
    public String getISSN() {
        return Containers.isNullOrEmpty((Collection)this.identifiers) ? null : (String)this.getIdentifierMap().get(Citations.ISSN);
    }

    public void setISSN(String string) {
        this.checkWritePermission();
        if (string != null || !Containers.isNullOrEmpty((Collection)this.identifiers)) {
            this.getIdentifierMap().putSpecialized(Citations.ISSN, (Object)string);
        }
    }

    @UML(identifier="onlineResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getOnlineResources() {
        this.onlineResources = this.nonNullCollection(this.onlineResources, OnlineResource.class);
        return this.onlineResources;
    }

    public void setOnlineResources(Collection<? extends OnlineResource> collection) {
        this.onlineResources = this.writeCollection(collection, this.onlineResources, OnlineResource.class);
    }

    @UML(identifier="graphic", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<BrowseGraphic> getGraphics() {
        this.graphics = this.nonNullCollection(this.graphics, BrowseGraphic.class);
        return this.graphics;
    }

    public void setGraphics(Collection<? extends BrowseGraphic> collection) {
        this.graphics = this.writeCollection(collection, this.graphics, BrowseGraphic.class);
    }
}

