/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gmi.MI_Georectified;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.util.resources.Messages;
import org.opengis.geometry.primitive.Point;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Georectified_Type", propOrder={"checkPointAvailable", "checkPointDescription", "cornerPoints", "centerPoint", "pointInPixel", "transformationDimensionDescription", "transformationDimensionMapping", "checkPoints"})
@XmlRootElement(name="MD_Georectified")
@XmlSeeAlso(value={MI_Georectified.class})
public class DefaultGeorectified
extends DefaultGridSpatialRepresentation
implements Georectified {
    private static final long serialVersionUID = -2924562334097446037L;
    private static final byte CHECK_POINT_MASK = 2;
    private InternationalString checkPointDescription;
    private List<Point> cornerPoints;
    private Point centerPoint;
    private PixelOrientation pointInPixel;
    private InternationalString transformationDimensionDescription;
    private Collection<InternationalString> transformationDimensionMapping;
    private Collection<GCP> checkPoints;

    public DefaultGeorectified() {
    }

    public DefaultGeorectified(Georectified georectified) {
        super((GridSpatialRepresentation)georectified);
        if (georectified != null) {
            this.checkPointDescription = georectified.getCheckPointDescription();
            this.cornerPoints = this.copyList(georectified.getCornerPoints(), Point.class);
            this.centerPoint = georectified.getCenterPoint();
            this.pointInPixel = georectified.getPointInPixel();
            this.transformationDimensionDescription = georectified.getTransformationDimensionDescription();
            this.transformationDimensionMapping = this.copyCollection(georectified.getTransformationDimensionMapping(), InternationalString.class);
            this.checkPoints = this.copyCollection(georectified.getCheckPoints(), GCP.class);
            if (this.checkPointDescription != null || georectified.isCheckPointAvailable()) {
                this.booleans = (byte)(this.booleans | 2);
            }
        }
    }

    public static DefaultGeorectified castOrCopy(Georectified georectified) {
        if (georectified == null || georectified instanceof DefaultGeorectified) {
            return (DefaultGeorectified)georectified;
        }
        return new DefaultGeorectified(georectified);
    }

    @XmlElement(name="checkPointAvailability", required=true)
    public boolean isCheckPointAvailable() {
        return (this.booleans & 2) != 0;
    }

    public void setCheckPointAvailable(boolean bl) {
        this.checkWritePermission();
        if (bl) {
            this.booleans = (byte)(this.booleans | 2);
        } else {
            if (this.checkPointDescription != null && (this.booleans & 2) != 0) {
                Context.warningOccured((Context)Context.current(), DefaultGeorectified.class, (String)"setCheckPointAvailable", Messages.class, (short)4, (Object[])new Object[]{"checkPointDescription", "checkPointAvailability"});
            }
            this.booleans = (byte)(this.booleans & 0xFFFFFFFD);
        }
    }

    @XmlElement(name="checkPointDescription")
    public InternationalString getCheckPointDescription() {
        return (this.booleans & 2) != 0 ? this.checkPointDescription : null;
    }

    public void setCheckPointDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.checkPointDescription = internationalString;
        if (internationalString != null) {
            this.booleans = (byte)(this.booleans | 2);
        }
    }

    @XmlElement(name="cornerPoints", required=true)
    public List<Point> getCornerPoints() {
        this.cornerPoints = this.nonNullList(this.cornerPoints, Point.class);
        return this.cornerPoints;
    }

    public void setCornerPoints(List<? extends Point> list) {
        this.cornerPoints = this.writeList(list, this.cornerPoints, Point.class);
    }

    @XmlElement(name="centerPoint")
    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point point) {
        this.checkWritePermission();
        this.centerPoint = point;
    }

    @XmlElement(name="pointInPixel", required=true)
    public PixelOrientation getPointInPixel() {
        return this.pointInPixel;
    }

    public void setPointInPixel(PixelOrientation pixelOrientation) {
        this.checkWritePermission();
        this.pointInPixel = pixelOrientation;
    }

    @XmlElement(name="transformationDimensionDescription")
    public InternationalString getTransformationDimensionDescription() {
        return this.transformationDimensionDescription;
    }

    public void setTransformationDimensionDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.transformationDimensionDescription = internationalString;
    }

    @XmlElement(name="transformationDimensionMapping")
    public Collection<InternationalString> getTransformationDimensionMapping() {
        this.transformationDimensionMapping = this.nonNullCollection(this.transformationDimensionMapping, InternationalString.class);
        return this.transformationDimensionMapping;
    }

    public void setTransformationDimensionMapping(Collection<? extends InternationalString> collection) {
        this.transformationDimensionMapping = this.writeCollection(collection, this.transformationDimensionMapping, InternationalString.class);
    }

    @XmlElement(name="checkPoint", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<GCP> getCheckPoints() {
        this.checkPoints = this.nonNullCollection(this.checkPoints, GCP.class);
        return this.checkPoints;
    }

    public void setCheckPoints(Collection<? extends GCP> collection) {
        this.checkPoints = this.writeCollection(collection, this.checkPoints, GCP.class);
    }
}

