/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class SQLUtilities
extends Static {
    private SQLUtilities() {
    }

    public static String getSimplifiedURL(DatabaseMetaData databaseMetaData) throws SQLException {
        int n;
        String string = databaseMetaData.getURL();
        int n2 = string.indexOf(63);
        if (n2 < 0) {
            n2 = string.length();
        }
        if ((n = string.indexOf(59)) < 0) {
            n = string.length();
        }
        return string.substring(0, Math.min(n2, n));
    }

    public static Boolean toBoolean(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (string.length()) {
            case 0: {
                return null;
            }
            case 1: {
                switch (string.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                    case '1': 
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                }
                break;
            }
            default: {
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
                    return Boolean.TRUE;
                }
                if (!string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no")) break;
                return Boolean.FALSE;
            }
        }
        throw new SQLDataException(Errors.format((short)8, (Object)string, Boolean.class));
    }

    public static String toLikePattern(String string) {
        int n;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isLetterOrDigit(n)) {
                stringBuilder.appendCodePoint(n);
                bl = true;
                continue;
            }
            if (bl) {
                bl = false;
                stringBuilder.append('%');
                continue;
            }
            int n2 = stringBuilder.length();
            if (n2 != 0 && stringBuilder.charAt(n2 - 1) == '%') continue;
            stringBuilder.appendCodePoint(n != 37 ? n : 95);
        }
        return stringBuilder.toString();
    }

    public static boolean filterFalsePositive(String string, String string2) {
        return CharSequences.equalsFiltered((CharSequence)string, (CharSequence)string2, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)false);
    }
}

