/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.Address;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Address_Type", propOrder={"deliveryPoints", "city", "administrativeArea", "postalCode", "country", "electronicMailAddresses"})
@XmlRootElement(name="CI_Address")
public class DefaultAddress
extends ISOMetadata
implements Address {
    private static final long serialVersionUID = 1357443146723845129L;
    private InternationalString administrativeArea;
    private InternationalString city;
    private InternationalString country;
    private String postalCode;
    private Collection<String> deliveryPoints;
    private Collection<String> electronicMailAddresses;

    public DefaultAddress() {
    }

    public DefaultAddress(Address address) {
        super(address);
        if (address != null) {
            this.deliveryPoints = this.copyCollection(address.getDeliveryPoints(), String.class);
            this.city = address.getCity();
            this.administrativeArea = address.getAdministrativeArea();
            this.postalCode = address.getPostalCode();
            this.country = address.getCountry();
            this.electronicMailAddresses = this.copyCollection(address.getElectronicMailAddresses(), String.class);
        }
    }

    public static DefaultAddress castOrCopy(Address address) {
        if (address == null || address instanceof DefaultAddress) {
            return (DefaultAddress)address;
        }
        return new DefaultAddress(address);
    }

    @XmlElement(name="administrativeArea")
    public InternationalString getAdministrativeArea() {
        return this.administrativeArea;
    }

    public void setAdministrativeArea(InternationalString internationalString) {
        this.checkWritePermission();
        this.administrativeArea = internationalString;
    }

    @XmlElement(name="city")
    public InternationalString getCity() {
        return this.city;
    }

    public void setCity(InternationalString internationalString) {
        this.checkWritePermission();
        this.city = internationalString;
    }

    @XmlElement(name="country")
    public InternationalString getCountry() {
        return this.country;
    }

    public void setCountry(InternationalString internationalString) {
        this.checkWritePermission();
        this.country = internationalString;
    }

    @XmlElement(name="deliveryPoint")
    public Collection<String> getDeliveryPoints() {
        this.deliveryPoints = this.nonNullCollection(this.deliveryPoints, String.class);
        return this.deliveryPoints;
    }

    public void setDeliveryPoints(Collection<? extends String> collection) {
        this.deliveryPoints = this.writeCollection(collection, this.deliveryPoints, String.class);
    }

    @XmlElement(name="electronicMailAddress")
    public Collection<String> getElectronicMailAddresses() {
        this.electronicMailAddresses = this.nonNullCollection(this.electronicMailAddresses, String.class);
        return this.electronicMailAddresses;
    }

    public void setElectronicMailAddresses(Collection<? extends String> collection) {
        this.electronicMailAddresses = this.writeCollection(collection, this.electronicMailAddresses, String.class);
    }

    @XmlElement(name="postalCode")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String string) {
        this.checkWritePermission();
        this.postalCode = string;
    }
}

