/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk8.BiConsumer;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Format_Type", propOrder={"name", "version", "amendmentNumber", "specification", "fileDecompressionTechnique", "formatDistributors"})
@XmlRootElement(name="MD_Format")
public class DefaultFormat
extends ISOMetadata
implements Format {
    private static final long serialVersionUID = -8346373589075887348L;
    private Citation formatSpecificationCitation;
    private InternationalString amendmentNumber;
    private InternationalString fileDecompressionTechnique;
    private Collection<Medium> media;
    private Collection<Distributor> formatDistributors;

    public DefaultFormat() {
    }

    @Deprecated
    public DefaultFormat(CharSequence charSequence, CharSequence charSequence2) {
        DefaultCitation defaultCitation = new DefaultCitation();
        if (charSequence != null) {
            defaultCitation.setAlternateTitles(Collections.singleton(Types.toInternationalString((CharSequence)charSequence)));
        }
        defaultCitation.setEdition(Types.toInternationalString((CharSequence)charSequence2));
        this.formatSpecificationCitation = defaultCitation;
    }

    public DefaultFormat(Format format) {
        super(format);
        if (format != null) {
            this.amendmentNumber = format.getAmendmentNumber();
            this.fileDecompressionTechnique = format.getFileDecompressionTechnique();
            this.formatDistributors = this.copyCollection(format.getFormatDistributors(), Distributor.class);
            if (format instanceof DefaultFormat) {
                this.formatSpecificationCitation = ((DefaultFormat)format).getFormatSpecificationCitation();
                this.media = this.copyCollection(((DefaultFormat)format).getMedia(), Medium.class);
            } else {
                this.setSpecification(format.getSpecification());
                this.setVersion(format.getVersion());
                this.setName(format.getName());
            }
        }
    }

    public static DefaultFormat castOrCopy(Format format) {
        if (format == null || format instanceof DefaultFormat) {
            return (DefaultFormat)format;
        }
        return new DefaultFormat(format);
    }

    @UML(identifier="formatSpecificationCitation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Citation getFormatSpecificationCitation() {
        return this.formatSpecificationCitation;
    }

    public void setFormatSpecificationCitation(Citation citation) {
        this.checkWritePermission();
        this.formatSpecificationCitation = citation;
    }

    private <T> void setFormatSpecificationCitation(BiConsumer<DefaultCitation, T> biConsumer, T t) {
        Citation citation = this.formatSpecificationCitation;
        if (citation != null || t != null) {
            if (!(citation instanceof DefaultCitation)) {
                citation = new DefaultCitation(citation);
            }
            biConsumer.accept((Object)((DefaultCitation)citation), t);
            if (t == null && ((DefaultCitation)citation).isEmpty()) {
                citation = null;
            }
        }
        if (citation != this.formatSpecificationCitation) {
            this.setFormatSpecificationCitation(citation);
        }
    }

    @Deprecated
    @XmlElement(name="specification")
    @Dependencies(value={"getFormatSpecificationCitation"})
    public InternationalString getSpecification() {
        Citation citation = this.getFormatSpecificationCitation();
        return citation != null ? citation.getTitle() : null;
    }

    @Deprecated
    public void setSpecification(InternationalString internationalString) {
        this.checkWritePermission();
        this.setFormatSpecificationCitation(new BiConsumer<DefaultCitation, InternationalString>(){

            public void accept(DefaultCitation defaultCitation, InternationalString internationalString) {
                defaultCitation.setTitle(internationalString);
            }
        }, internationalString);
    }

    @Deprecated
    @XmlElement(name="name", required=true)
    @Dependencies(value={"getFormatSpecificationCitation"})
    public InternationalString getName() {
        Citation citation = this.getFormatSpecificationCitation();
        if (citation != null) {
            return LegacyPropertyAdapter.getSingleton(citation.getAlternateTitles(), InternationalString.class, null, DefaultFormat.class, "getName");
        }
        return null;
    }

    @Deprecated
    public void setName(InternationalString internationalString) {
        this.checkWritePermission();
        this.setFormatSpecificationCitation(new BiConsumer<DefaultCitation, InternationalString>(){

            public void accept(DefaultCitation defaultCitation, InternationalString internationalString) {
                defaultCitation.setAlternateTitles(LegacyPropertyAdapter.asCollection(internationalString));
            }
        }, internationalString);
    }

    @Deprecated
    @XmlElement(name="version", required=true)
    @Dependencies(value={"getFormatSpecificationCitation"})
    public InternationalString getVersion() {
        Citation citation = this.getFormatSpecificationCitation();
        return citation != null ? citation.getEdition() : null;
    }

    @Deprecated
    public void setVersion(InternationalString internationalString) {
        this.checkWritePermission();
        this.setFormatSpecificationCitation(new BiConsumer<DefaultCitation, InternationalString>(){

            public void accept(DefaultCitation defaultCitation, InternationalString internationalString) {
                defaultCitation.setEdition(internationalString);
            }
        }, internationalString);
    }

    @XmlElement(name="amendmentNumber")
    public InternationalString getAmendmentNumber() {
        return this.amendmentNumber;
    }

    public void setAmendmentNumber(InternationalString internationalString) {
        this.checkWritePermission();
        this.amendmentNumber = internationalString;
    }

    @XmlElement(name="fileDecompressionTechnique")
    public InternationalString getFileDecompressionTechnique() {
        return this.fileDecompressionTechnique;
    }

    public void setFileDecompressionTechnique(InternationalString internationalString) {
        this.checkWritePermission();
        this.fileDecompressionTechnique = internationalString;
    }

    @UML(identifier="medium", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Medium> getMedia() {
        this.media = this.nonNullCollection(this.media, Medium.class);
        return this.media;
    }

    public void setMedia(Collection<? extends Medium> collection) {
        this.media = this.writeCollection(collection, this.media, Medium.class);
    }

    @XmlElement(name="formatDistributor")
    public Collection<Distributor> getFormatDistributors() {
        this.formatDistributors = this.nonNullCollection(this.formatDistributors, Distributor.class);
        return this.formatDistributors;
    }

    public void setFormatDistributors(Collection<? extends Distributor> collection) {
        this.formatDistributors = this.writeCollection(collection, this.formatDistributors, Distributor.class);
    }
}

