/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@XmlTransient
public final class PositionalAccuracyConstant
extends DefaultAbsoluteExternalPositionalAccuracy {
    private static final long serialVersionUID = -2554090935254116470L;
    private static final double UNKNOWN_ACCURACY = 3000.0;
    private static final double DATUM_SHIFT_ACCURACY = 25.0;
    public static final PositionalAccuracy DATUM_SHIFT_APPLIED;
    public static final PositionalAccuracy DATUM_SHIFT_OMITTED;

    private PositionalAccuracyConstant(InternationalString internationalString, InternationalString internationalString2, boolean bl) {
        DefaultConformanceResult defaultConformanceResult = new DefaultConformanceResult(Citations.SIS, (CharSequence)internationalString2, bl);
        defaultConformanceResult.freeze();
        this.setResults(Collections.singleton(defaultConformanceResult));
        this.setMeasureDescription(internationalString);
        this.setEvaluationMethodDescription(internationalString2);
        this.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
        this.freeze();
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.equals(DATUM_SHIFT_APPLIED)) {
            return DATUM_SHIFT_APPLIED;
        }
        if (this.equals(DATUM_SHIFT_OMITTED)) {
            return DATUM_SHIFT_OMITTED;
        }
        return this;
    }

    public static double getLinearAccuracy(CoordinateOperation coordinateOperation) {
        Collection collection = coordinateOperation.getCoordinateOperationAccuracy();
        for (PositionalAccuracy positionalAccuracy : collection) {
            for (Result result : positionalAccuracy.getResults()) {
                Unit unit;
                QuantitativeResult quantitativeResult;
                Collection collection2;
                if (!(result instanceof QuantitativeResult) || (collection2 = (quantitativeResult = (QuantitativeResult)result).getValues()) == null || !Units.isLinear((Unit)(unit = quantitativeResult.getValueUnit()))) continue;
                Unit unit2 = unit.asType(Length.class);
                for (Record record : collection2) {
                    for (Object v : record.getAttributes().values()) {
                        if (!(v instanceof Number)) continue;
                        double d = ((Number)v).doubleValue();
                        d = unit2.getConverterTo((Unit)SI.METRE).convert(d);
                        return d;
                    }
                }
            }
        }
        if (coordinateOperation instanceof Conversion) {
            return 0.0;
        }
        if (coordinateOperation instanceof Transformation) {
            if (collection.contains(DATUM_SHIFT_APPLIED)) {
                return 25.0;
            }
            if (collection.contains(DATUM_SHIFT_OMITTED)) {
                return 3000.0;
            }
        }
        double d = Double.NaN;
        if (coordinateOperation instanceof ConcatenatedOperation) {
            for (Result result : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                double d2 = Math.abs(PositionalAccuracyConstant.getLinearAccuracy((CoordinateOperation)result));
                if (Double.isNaN(d2)) continue;
                if (Double.isNaN(d)) {
                    d = d2;
                    continue;
                }
                d += d2;
            }
        }
        return d;
    }

    static {
        InternationalString internationalString = Vocabulary.formatInternational((short)81);
        InternationalString internationalString2 = Messages.formatInternational((short)8);
        DATUM_SHIFT_APPLIED = new PositionalAccuracyConstant(internationalString, internationalString2, true);
        DATUM_SHIFT_OMITTED = new PositionalAccuracyConstant(internationalString, internationalString2, false);
    }
}

