/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Collections;
import javax.measure.quantity.Angle;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;

public final class ReferencingUtilities
extends Static {
    private ReferencingUtilities() {
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian instanceof DefaultPrimeMeridian) {
            return ((DefaultPrimeMeridian)primeMeridian).getGreenwichLongitude(unit);
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static Unit<?> getUnit(CoordinateSystem coordinateSystem) {
        Unit unit = null;
        if (coordinateSystem != null) {
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                Unit unit2;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
                if (coordinateSystemAxis == null || (unit2 = coordinateSystemAxis.getUnit()) == null) continue;
                if (unit == null) {
                    unit = unit2;
                    continue;
                }
                if (unit.equals((Object)unit2)) continue;
                return null;
            }
        }
        return unit;
    }

    public static int getDimension(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            return coordinateSystem.getDimension();
        }
        return 0;
    }

    public static boolean getSingleComponents(Iterable<? extends CoordinateReferenceSystem> iterable, Collection<? super SingleCRS> collection) throws ClassCastException {
        boolean bl = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : iterable) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                ReferencingUtilities.getSingleComponents(((CompoundCRS)coordinateReferenceSystem).getComponents(), collection);
                bl = false;
                continue;
            }
            collection.add((SingleCRS)((SingleCRS)coordinateReferenceSystem));
        }
        return bl;
    }

    public static Ellipsoid getEllipsoidOfGeographicCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (!(coordinateReferenceSystem instanceof GeographicCRS)) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                coordinateReferenceSystem = (CoordinateReferenceSystem)((CompoundCRS)coordinateReferenceSystem).getComponents().get(0);
                continue;
            }
            return null;
        }
        return ((GeographicCRS)coordinateReferenceSystem).getDatum().getEllipsoid();
    }

    public static GeographicCRS toNormalizedGeographicCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
        }
        if (coordinateReferenceSystem instanceof GeodeticCRS) {
            if (coordinateReferenceSystem instanceof DefaultGeographicCRS && coordinateReferenceSystem.getCoordinateSystem().getDimension() == 2) {
                return ((DefaultGeographicCRS)coordinateReferenceSystem).forConvention(AxesConvention.NORMALIZED);
            }
            EllipsoidalCS ellipsoidalCS = CommonCRS.defaultGeographic().getCoordinateSystem();
            if (coordinateReferenceSystem instanceof GeographicCRS && Utilities.equalsIgnoreMetadata((Object)ellipsoidalCS, (Object)coordinateReferenceSystem.getCoordinateSystem())) {
                return (GeographicCRS)coordinateReferenceSystem;
            }
            return new DefaultGeographicCRS(Collections.singletonMap("name", NilReferencingObject.UNNAMED), ((GeodeticCRS)coordinateReferenceSystem).getDatum(), ellipsoidalCS);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem2);
                if (geographicCRS == null) continue;
                return geographicCRS;
            }
        }
        return null;
    }

    public static StringBuilder toPropertyName(Class<?> clazz, Class<?> clazz2) {
        Object object;
        int n;
        StringBuilder stringBuilder;
        UML uML = clazz2.getAnnotation(UML.class);
        if (uML != null && uML.specification() == Specification.ISO_19111 && (stringBuilder = new StringBuilder(n = ((String)(object = uML.identifier())).length()).append((CharSequence)object, ((String)object).indexOf(95) + 1, n)).length() != 0) {
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
            return stringBuilder;
        }
        for (Class<?> clazz3 : clazz2.getInterfaces()) {
            StringBuilder stringBuilder2;
            if (!clazz.isAssignableFrom(clazz3) || (stringBuilder2 = ReferencingUtilities.toPropertyName(clazz, clazz3)) == null) continue;
            return stringBuilder2;
        }
        return null;
    }

    public static String toWKTType(Class<?> clazz, Class<?> clazz2) {
        int n;
        StringBuilder stringBuilder;
        if (clazz2 != clazz && (stringBuilder = ReferencingUtilities.toPropertyName(clazz, clazz2)) != null && CharSequences.regionMatches((CharSequence)stringBuilder, (int)(n = stringBuilder.length() - 2), (CharSequence)"CS")) {
            stringBuilder.setLength(n);
            if ("time".contentEquals(stringBuilder)) {
                return "temporal";
            }
            if (CharSequences.regionMatches((CharSequence)stringBuilder, (int)0, (CharSequence)"cartesian")) {
                stringBuilder.setCharAt(0, 'C');
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static void propertyAlreadySet(Class<?> clazz, String string, String string2) throws IllegalStateException {
        Context context = Context.current();
        if (context == null) {
            throw new IllegalStateException(Errors.format((short)19, (Object)string2));
        }
        Context.warningOccured((Context)context, clazz, (String)string, Errors.class, (short)19, (Object[])new Object[]{string2});
    }
}

