/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.AffineTransform;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.system.Semaphores;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public final class ParameterizedAffine
extends AffineTransform2D {
    private static final long serialVersionUID = 906346920928432466L;
    private final ParameterValueGroup parameters;
    private final boolean isDefinitive;

    public ParameterizedAffine(AffineTransform affineTransform, ParameterValueGroup parameterValueGroup, boolean bl) {
        super(affineTransform);
        this.parameters = parameterValueGroup;
        this.isDefinitive = bl;
    }

    public MathTransform newTransform(MathTransform mathTransform) {
        if (mathTransform instanceof AffineTransform) {
            return new ParameterizedAffine((AffineTransform)mathTransform, this.parameters, false);
        }
        return mathTransform;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.isDefinitive || Semaphores.query((byte)2) ? this.parameters.getDescriptor() : super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.isDefinitive || Semaphores.query((byte)2) ? this.parameters : super.getParameterValues();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            if (object instanceof ParameterizedAffine) {
                ParameterizedAffine parameterizedAffine = (ParameterizedAffine)object;
                return this.isDefinitive == parameterizedAffine.isDefinitive && Objects.equals((Object)this.parameters, (Object)parameterizedAffine.parameters);
            }
            return true;
        }
        return false;
    }
}

