/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.jaxb.metadata.replace.ServiceParameter;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.MemberName;

@XmlTransient
public abstract class Parameters
implements ParameterValueGroup,
Cloneable {
    protected Parameters() {
    }

    public static Parameters castOrWrap(ParameterValueGroup parameterValueGroup) {
        if (parameterValueGroup == null || parameterValueGroup instanceof Parameters) {
            return (Parameters)parameterValueGroup;
        }
        return new Wrapper(parameterValueGroup);
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> parameterDescriptor, Class<T> clazz) throws ClassCastException {
        Class clazz2;
        ArgumentChecks.ensureNonNull((String)"valueClass", clazz);
        if (parameterDescriptor != null && !clazz.equals(clazz2 = parameterDescriptor.getValueClass())) {
            throw new ClassCastException(Errors.format((short)143, (Object)Verifier.getDisplayName(parameterDescriptor), (Object)clazz2));
        }
        return parameterDescriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameterValue, Class<T> clazz) throws ClassCastException {
        ParameterDescriptor parameterDescriptor;
        Class clazz2;
        ArgumentChecks.ensureNonNull((String)"valueClass", clazz);
        if (parameterValue != null && !clazz.equals(clazz2 = (parameterDescriptor = parameterValue.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format((short)143, (Object)Verifier.getDisplayName((GeneralParameterDescriptor)parameterDescriptor), (Object)clazz2));
        }
        return parameterValue;
    }

    public static GeneralParameterDescriptor[] getDescriptors(GeneralParameterValue ... generalParameterValueArray) {
        if (generalParameterValueArray == null) {
            return null;
        }
        GeneralParameterDescriptor[] generalParameterDescriptorArray = new GeneralParameterDescriptor[generalParameterValueArray.length];
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            GeneralParameterValue generalParameterValue = generalParameterValueArray[i];
            if (generalParameterValue == null) continue;
            generalParameterDescriptorArray[i] = generalParameterValue.getDescriptor();
        }
        return generalParameterDescriptorArray;
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameterDescriptor) {
        return ServiceParameter.getMemberName(parameterDescriptor);
    }

    public static Range<?> getValueDomain(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor != null) {
            if (parameterDescriptor instanceof DefaultParameterDescriptor) {
                return ((DefaultParameterDescriptor)parameterDescriptor).getValueDomain();
            }
            Class clazz = parameterDescriptor.getValueClass();
            Comparable comparable = parameterDescriptor.getMinimumValue();
            Comparable comparable2 = parameterDescriptor.getMaximumValue();
            if ((comparable == null || clazz.isInstance(comparable)) && (comparable2 == null || clazz.isInstance(comparable2))) {
                if (Number.class.isAssignableFrom(clazz)) {
                    Unit unit = parameterDescriptor.getUnit();
                    if (unit != null) {
                        return new MeasurementRange(clazz, (Number)((Object)comparable), true, (Number)((Object)comparable2), true, unit);
                    }
                    if (comparable != null || comparable2 != null) {
                        return new NumberRange(clazz, (Number)((Object)comparable), true, (Number)((Object)comparable2), true);
                    }
                } else if (comparable != null || comparable2 != null) {
                    return new Range(clazz, comparable, true, comparable2, true);
                }
            }
        }
        return null;
    }

    private String getName(GeneralParameterDescriptor generalParameterDescriptor) {
        Citation citation;
        String string;
        ReferenceIdentifier referenceIdentifier;
        ParameterDescriptorGroup parameterDescriptorGroup = this.getDescriptor();
        if (parameterDescriptorGroup != null && (referenceIdentifier = parameterDescriptorGroup.getName()) != null && ((string = IdentifiedObjects.getName((IdentifiedObject)generalParameterDescriptor, citation = referenceIdentifier.getAuthority())) != null || citation == null)) {
            return string;
        }
        return IdentifiedObjects.getName((IdentifiedObject)generalParameterDescriptor, null);
    }

    ParameterValue<?> parameterIfExist(String string) throws ParameterNotFoundException {
        for (GeneralParameterValue generalParameterValue : this.values()) {
            if (!(generalParameterValue instanceof ParameterValue) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)generalParameterValue.getDescriptor(), string)) continue;
            return (ParameterValue)generalParameterValue;
        }
        return null;
    }

    private ParameterValue<?> getParameter(ParameterDescriptor<?> parameterDescriptor) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"parameter", parameterDescriptor);
        String string = this.getName((GeneralParameterDescriptor)parameterDescriptor);
        ParameterValue<?> parameterValue = this.parameterIfExist(string);
        if (parameterValue == null || this.isKnownImplementation()) {
            return parameterValue;
        }
        return this.parameter(string);
    }

    boolean isKnownImplementation() {
        return false;
    }

    public <T> T getValue(ParameterDescriptor<T> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            Class clazz = parameterDescriptor.getValueClass();
            Unit unit = parameterDescriptor.getUnit();
            Object object = unit == null ? parameterValue.getValue() : (clazz.isArray() ? (Object)parameterValue.doubleValueList(unit) : Double.valueOf(parameterValue.doubleValue(unit)));
            if (object != null) {
                return (T)ObjectConverters.convert((Object)object, (Class)clazz);
            }
        }
        return (T)parameterDescriptor.getDefaultValue();
    }

    private static <T> T defaultValue(ParameterDescriptor<T> parameterDescriptor) throws IllegalStateException {
        Object object = parameterDescriptor.getDefaultValue();
        if (object != null) {
            return (T)object;
        }
        throw new IllegalStateException(Errors.format((short)142, (Object)Verifier.getDisplayName(parameterDescriptor)));
    }

    public boolean booleanValue(ParameterDescriptor<Boolean> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.booleanValue() : Parameters.defaultValue(parameterDescriptor).booleanValue();
    }

    public int intValue(ParameterDescriptor<? extends Number> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.intValue() : Parameters.defaultValue(parameterDescriptor).intValue();
    }

    public int[] intValueList(ParameterDescriptor<int[]> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.intValueList() : Parameters.defaultValue(parameterDescriptor);
    }

    public double doubleValue(ParameterDescriptor<? extends Number> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            Unit unit = parameterDescriptor.getUnit();
            return unit != null ? parameterValue.doubleValue(unit) : parameterValue.doubleValue();
        }
        return Parameters.defaultValue(parameterDescriptor).doubleValue();
    }

    public double[] doubleValueList(ParameterDescriptor<double[]> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            Unit unit = parameterDescriptor.getUnit();
            return unit != null ? parameterValue.doubleValueList(unit) : parameterValue.doubleValueList();
        }
        return Parameters.defaultValue(parameterDescriptor);
    }

    public String stringValue(ParameterDescriptor<? extends CharSequence> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.stringValue() : Parameters.defaultValue(parameterDescriptor).toString();
    }

    public <T> ParameterValue<T> getOrCreate(ParameterDescriptor<T> parameterDescriptor) throws ParameterNotFoundException {
        return Parameters.cast(this.parameter(this.getName((GeneralParameterDescriptor)parameterDescriptor)), parameterDescriptor.getValueClass());
    }

    public Parameters clone() {
        try {
            return (Parameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) throws InvalidParameterNameException, InvalidParameterValueException {
        Integer n = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            Object object;
            String string = generalParameterValue.getDescriptor().getName().getCode();
            int n2 = (Integer)JDK8.getOrDefault(hashMap, (Object)string, (Object)n);
            if (generalParameterValue instanceof ParameterValueGroup) {
                object = parameterValueGroup2.groups(string);
                Parameters.copy((ParameterValueGroup)generalParameterValue, n2 < object.size() ? (ParameterValueGroup)object.get(n2) : parameterValueGroup2.addGroup(string));
            } else {
                ParameterValue parameterValue;
                object = (ParameterValue)generalParameterValue;
                if (n2 == 0) {
                    try {
                        parameterValue = parameterValueGroup2.parameter(string);
                    }
                    catch (ParameterNotFoundException parameterNotFoundException) {
                        throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)152, (Object)string), string).initCause((Throwable)parameterNotFoundException);
                    }
                } else {
                    parameterValue = (ParameterValue)Parameters.getOrCreate(parameterValueGroup2, string, n2);
                }
                Object object2 = object.getValue();
                Unit unit = object.getUnit();
                if (unit == null) {
                    parameterValue.setValue(object2);
                } else if (object2 instanceof Number) {
                    parameterValue.setValue(((Number)object2).doubleValue(), unit);
                } else if (object2 instanceof double[]) {
                    parameterValue.setValue((double[])object2, unit);
                } else {
                    throw new InvalidParameterValueException(Errors.format((short)31, (Object)string, (Object)object2), string, object2);
                }
            }
            hashMap.put(string, n2 + 1);
        }
    }

    private static GeneralParameterValue getOrCreate(ParameterValueGroup parameterValueGroup, String string, int n) {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            if (!string.equals(generalParameterValue.getDescriptor().getName().getCode()) || --n >= 0) continue;
            return generalParameterValue;
        }
        if (n == 0) {
            GeneralParameterValue generalParameterValue = parameterValueGroup.getDescriptor().descriptor(string).createValue();
            parameterValueGroup.values().add(generalParameterValue);
            return generalParameterValue;
        }
        throw new IndexOutOfBoundsException(string);
    }

    private static final class Wrapper
    extends Parameters
    implements Serializable {
        private static final long serialVersionUID = -5491790565456920471L;
        private final ParameterValueGroup delegate;

        Wrapper(ParameterValueGroup parameterValueGroup) {
            this.delegate = parameterValueGroup;
        }

        public ParameterDescriptorGroup getDescriptor() {
            return this.delegate.getDescriptor();
        }

        public List<GeneralParameterValue> values() {
            return this.delegate.values();
        }

        public ParameterValue<?> parameter(String string) {
            return this.delegate.parameter(string);
        }

        public List<ParameterValueGroup> groups(String string) {
            return this.delegate.groups(string);
        }

        public ParameterValueGroup addGroup(String string) {
            return this.delegate.addGroup(string);
        }

        @Override
        public Parameters clone() {
            return new Wrapper(this.delegate.clone());
        }
    }
}

