/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultUserDefinedCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.cs.SubTypes;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlType(name="AbstractCoordinateSystemType")
@XmlRootElement(name="AbstractCoordinateSystem")
@XmlSeeAlso(value={DefaultAffineCS.class, DefaultCartesianCS.class, DefaultSphericalCS.class, DefaultEllipsoidalCS.class, DefaultCylindricalCS.class, DefaultPolarCS.class, DefaultLinearCS.class, DefaultVerticalCS.class, DefaultTimeCS.class, DefaultUserDefinedCS.class})
public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    static final int VALID = 0;
    static final int INVALID_DIRECTION = 1;
    static final int INVALID_UNIT = 2;
    @XmlElement(name="axis")
    private final CoordinateSystemAxis[] axes;
    private transient Map<AxesConvention, AbstractCS> derived;
    private static final CoordinateSystemAxis[] EMPTY = new CoordinateSystemAxis[0];

    public AbstractCS(Map<String, ?> map, CoordinateSystemAxis ... coordinateSystemAxisArray) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"axes", (Object)coordinateSystemAxisArray);
        coordinateSystemAxisArray = (CoordinateSystemAxis[])coordinateSystemAxisArray.clone();
        this.axes = coordinateSystemAxisArray;
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystemAxisArray[i];
            ArgumentChecks.ensureNonNullElement((String)"axes", (int)i, (Object)coordinateSystemAxis);
            ReferenceIdentifier referenceIdentifier = coordinateSystemAxis.getName();
            ArgumentChecks.ensureNonNullElement((String)"axes[#].name", (int)i, (Object)referenceIdentifier);
            AxisDirection axisDirection = coordinateSystemAxis.getDirection();
            ArgumentChecks.ensureNonNullElement((String)"axes[#].direction", (int)i, (Object)axisDirection);
            Unit unit = coordinateSystemAxis.getUnit();
            ArgumentChecks.ensureNonNullElement((String)"axes[#].unit", (int)i, (Object)unit);
            switch (this.validateAxis(axisDirection, unit)) {
                case 1: {
                    throw new IllegalArgumentException(Errors.getResources(map).getString((short)32, this.getClass(), (Object)axisDirection));
                }
                case 2: {
                    throw new IllegalArgumentException(Errors.getResources(map).getString((short)43, (Object)referenceIdentifier, (Object)unit));
                }
            }
            AxisDirection axisDirection2 = AxisDirections.absolute((AxisDirection)axisDirection);
            if (axisDirection2.equals((Object)AxisDirection.OTHER)) continue;
            int n = i;
            while (--n >= 0) {
                AxisDirection axisDirection3 = coordinateSystemAxisArray[n].getDirection();
                AxisDirection axisDirection4 = AxisDirections.absolute((AxisDirection)axisDirection3);
                if (!axisDirection2.equals((Object)axisDirection4) || axisDirection4.equals((Object)AxisDirection.FUTURE)) continue;
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)14, (Object)axisDirection, (Object)axisDirection3));
            }
        }
    }

    protected AbstractCS(CoordinateSystem coordinateSystem) {
        super((IdentifiedObject)coordinateSystem);
        if (coordinateSystem instanceof AbstractCS) {
            this.axes = ((AbstractCS)coordinateSystem).axes;
        } else {
            this.axes = new CoordinateSystemAxis[coordinateSystem.getDimension()];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axes[i] = coordinateSystem.getAxis(i);
            }
        }
    }

    public static AbstractCS castOrCopy(CoordinateSystem coordinateSystem) {
        return SubTypes.castOrCopy(coordinateSystem);
    }

    int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        return 0;
    }

    public Class<? extends CoordinateSystem> getInterface() {
        return CoordinateSystem.class;
    }

    public final int getDimension() {
        return this.axes.length;
    }

    public final CoordinateSystemAxis getAxis(int n) throws IndexOutOfBoundsException {
        return this.axes[n];
    }

    public synchronized AbstractCS forConvention(AxesConvention axesConvention) {
        AbstractCS abstractCS;
        ArgumentChecks.ensureNonNull((String)"convention", (Object)axesConvention);
        if (this.derived == null) {
            this.derived = new EnumMap<AxesConvention, AbstractCS>(AxesConvention.class);
        }
        if ((abstractCS = this.derived.get(axesConvention)) == null) {
            abstractCS = Normalizer.forConvention(this, axesConvention);
            if (abstractCS == null) {
                abstractCS = this;
            }
            for (AbstractCS abstractCS2 : this.derived.values()) {
                if (!abstractCS.equals(abstractCS2)) continue;
                abstractCS = abstractCS2;
                break;
            }
            this.derived.put(axesConvention, abstractCS);
        }
        return abstractCS;
    }

    AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        return new AbstractCS(map, coordinateSystemAxisArray);
    }

    static IllegalArgumentException unexpectedDimension(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray, int n) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)59, (Object)"filter(cs)", (Object)n, (Object)coordinateSystemAxisArray.length));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                return Arrays.equals(this.axes, ((AbstractCS)object).axes);
            }
        }
        CoordinateSystem coordinateSystem = (CoordinateSystem)object;
        int n = this.getDimension();
        if (n != coordinateSystem.getDimension()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Utilities.deepEquals((Object)this.getAxis(i), (Object)coordinateSystem.getAxis(i), (ComparisonMode)comparisonMode)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Arrays.hashCode(this.axes);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String string = ReferencingUtilities.toWKTType(CoordinateSystem.class, this.getInterface());
        if (string == null) {
            formatter.setInvalidWKT((IdentifiedObject)this, null);
        }
        formatter.append(string, ElementKind.CODE_LIST);
        formatter.append((long)this.getDimension());
        return "CS";
    }

    AbstractCS() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.axes = EMPTY;
    }
}

