/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

final class Normalizer
implements Comparable<Normalizer> {
    private static final String[] EXCLUDES = new String[]{"identifiers"};
    private final CoordinateSystemAxis axis;
    private final DirectionAlongMeridian meridian;

    private Normalizer(CoordinateSystemAxis coordinateSystemAxis) {
        this.axis = coordinateSystemAxis;
        AxisDirection axisDirection = coordinateSystemAxis.getDirection();
        this.meridian = AxisDirections.isUserDefined((AxisDirection)axisDirection) ? DirectionAlongMeridian.parse(axisDirection) : null;
    }

    @Override
    public int compareTo(Normalizer normalizer) {
        AxisDirection axisDirection = this.axis.getDirection();
        AxisDirection axisDirection2 = normalizer.axis.getDirection();
        int n = AxisDirections.angleForCompass((AxisDirection)axisDirection2, (AxisDirection)axisDirection);
        if (n != Integer.MIN_VALUE) {
            return n;
        }
        if (this.meridian != null) {
            if (normalizer.meridian != null) {
                return this.meridian.compareTo(normalizer.meridian);
            }
            return -1;
        }
        if (normalizer.meridian != null) {
            return 1;
        }
        return axisDirection.ordinal() - axisDirection2.ordinal();
    }

    static boolean sort(CoordinateSystemAxis[] coordinateSystemAxisArray) {
        boolean bl;
        Object[] objectArray = new Normalizer[coordinateSystemAxisArray.length];
        for (bl = false; bl < coordinateSystemAxisArray.length; bl += 1) {
            objectArray[bl] = new Normalizer(coordinateSystemAxisArray[bl]);
        }
        Arrays.sort(objectArray);
        bl = false;
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = ((Normalizer)objectArray[i]).axis;
            bl |= coordinateSystemAxisArray[i] != coordinateSystemAxis;
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        return bl;
    }

    static CoordinateSystemAxis normalize(CoordinateSystemAxis coordinateSystemAxis, AxisFilter axisFilter) {
        UnitConverter unitConverter;
        String string;
        Unit unit = coordinateSystemAxis.getUnit();
        AxisDirection axisDirection = coordinateSystemAxis.getDirection();
        Unit<?> unit2 = axisFilter.getUnitReplacement(unit);
        AxisDirection axisDirection2 = axisFilter.getDirectionReplacement(axisDirection);
        boolean bl = axisDirection2.equals((Object)axisDirection);
        if (bl && unit2.equals((Object)unit)) {
            return coordinateSystemAxis;
        }
        String string2 = string = coordinateSystemAxis.getAbbreviation();
        if (!bl) {
            if (AxisDirections.isCompass((AxisDirection)axisDirection)) {
                if (CharSequences.isAcronymForWords((CharSequence)string, (CharSequence)axisDirection.name())) {
                    if (axisDirection2.equals((Object)AxisDirection.EAST)) {
                        string2 = "E";
                    } else if (axisDirection2.equals((Object)AxisDirection.NORTH)) {
                        string2 = "N";
                    }
                }
            } else if (axisDirection2.equals((Object)AxisDirection.UP)) {
                string2 = "z";
            } else if (axisDirection2.equals((Object)AxisDirection.FUTURE)) {
                string2 = "t";
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string2.equals(string)) {
            hashMap.putAll(IdentifiedObjects.getProperties((IdentifiedObject)coordinateSystemAxis, EXCLUDES));
        } else {
            hashMap.put("name", NilReferencingObject.UNNAMED);
        }
        try {
            unitConverter = unit.getConverterToAny(unit2);
        }
        catch (ConversionException conversionException) {
            throw new IllegalStateException(Errors.format((short)43, (Object)"axis", (Object)unit), conversionException);
        }
        hashMap.put("minimumValue", unitConverter.convert(coordinateSystemAxis.getMinimumValue()));
        hashMap.put("maximumValue", unitConverter.convert(coordinateSystemAxis.getMaximumValue()));
        hashMap.put("rangeMeaning", coordinateSystemAxis.getRangeMeaning());
        return new DefaultCoordinateSystemAxis(hashMap, string2, axisDirection2, unit2);
    }

    static AbstractCS normalize(CoordinateSystem coordinateSystem, AxisFilter axisFilter, boolean bl) {
        Object object;
        boolean bl2 = false;
        int n = coordinateSystem.getDimension();
        Object[] objectArray = new CoordinateSystemAxis[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            object = coordinateSystem.getAxis(i);
            if (axisFilter != null) {
                if (!axisFilter.accept((CoordinateSystemAxis)object)) continue;
                bl2 |= object != (object = Normalizer.normalize(object, axisFilter));
            }
            objectArray[n2++] = object;
        }
        objectArray = (CoordinateSystemAxis[])ArraysExt.resize((Object[])objectArray, (int)n2);
        if (bl) {
            bl2 |= Normalizer.sort((CoordinateSystemAxis[])objectArray);
        }
        if (!bl2 && n2 == n) {
            return null;
        }
        AbstractCS abstractCS = Normalizer.castOrCopy(coordinateSystem);
        object = (StringBuilder)CharSequences.camelCaseToSentence((CharSequence)abstractCS.getInterface().getSimpleName());
        return abstractCS.createForAxes(Collections.singletonMap("name", AxisDirections.appendTo((StringBuilder)object, (CoordinateSystemAxis[])objectArray)), (CoordinateSystemAxis[])objectArray);
    }

    private static AbstractCS shiftAxisRange(CoordinateSystem coordinateSystem) {
        boolean bl = false;
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[coordinateSystem.getDimension()];
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            double d;
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            RangeMeaning rangeMeaning = coordinateSystemAxis.getRangeMeaning();
            if (RangeMeaning.WRAPAROUND.equals((Object)rangeMeaning) && (d = coordinateSystemAxis.getMinimumValue()) < 0.0) {
                double d2 = coordinateSystemAxis.getMaximumValue();
                double d3 = (d2 - d) / 2.0;
                if ((d -= (d3 *= Math.floor(d / d3 + 1.0E-10))) < (d2 -= d3)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.putAll(IdentifiedObjects.getProperties((IdentifiedObject)coordinateSystemAxis, EXCLUDES));
                    hashMap.put("minimumValue", d);
                    hashMap.put("maximumValue", d2);
                    hashMap.put("rangeMeaning", rangeMeaning);
                    coordinateSystemAxis = new DefaultCoordinateSystemAxis(hashMap, coordinateSystemAxis.getAbbreviation(), coordinateSystemAxis.getDirection(), coordinateSystemAxis.getUnit());
                    bl = true;
                }
            }
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        if (!bl) {
            return null;
        }
        return Normalizer.castOrCopy(coordinateSystem).createForAxes(IdentifiedObjects.getProperties((IdentifiedObject)coordinateSystem, EXCLUDES), coordinateSystemAxisArray);
    }

    private static AbstractCS castOrCopy(CoordinateSystem coordinateSystem) {
        return coordinateSystem instanceof AbstractCS ? (AbstractCS)coordinateSystem : AbstractCS.castOrCopy(coordinateSystem);
    }

    static AbstractCS forConvention(CoordinateSystem coordinateSystem, AxesConvention axesConvention) {
        switch (axesConvention) {
            case NORMALIZED: 
            case CONVENTIONALLY_ORIENTED: {
                return Normalizer.normalize(coordinateSystem, axesConvention, true);
            }
            case RIGHT_HANDED: {
                return Normalizer.normalize(coordinateSystem, null, true);
            }
            case POSITIVE_RANGE: {
                return Normalizer.shiftAxisRange(coordinateSystem);
            }
        }
        throw new AssertionError(axesConvention);
    }
}

