/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.referencing.datum.DefaultEllipsoid;

@XmlTransient
final class Sphere
extends DefaultEllipsoid {
    private static final long serialVersionUID = 7867565381280669821L;

    protected Sphere(Map<String, ?> map, double d, boolean bl, Unit<Length> unit) {
        super(map, d, d, Double.POSITIVE_INFINITY, bl, unit);
    }

    @Override
    public boolean isSphere() {
        return true;
    }

    @Override
    public double getAuthalicRadius() {
        return this.getSemiMajorAxis();
    }

    @Override
    public double getEccentricity() {
        return 0.0;
    }

    @Override
    public double orthodromicDistance(double d, double d2, double d3, double d4) {
        d2 = Math.toRadians(d2);
        d4 = Math.toRadians(d4);
        double d5 = Math.toRadians(Math.abs(d3 - d) % 360.0);
        double d6 = Math.sin(d2) * Math.sin(d4) + Math.cos(d2) * Math.cos(d4) * Math.cos(d5);
        assert (Math.abs(d6) < 1.0000001) : d6;
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        if (d6 < -1.0) {
            d6 = -1.0;
        }
        return Math.acos(d6) * this.getSemiMajorAxis();
    }
}

