/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.AbstractMap;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.MismatchedDatumException;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="ConversionType")
@XmlRootElement(name="Conversion")
public class DefaultConversion
extends AbstractSingleOperation
implements Conversion {
    private static final long serialVersionUID = -2148164324805562793L;

    public DefaultConversion(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, MathTransform mathTransform) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform);
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)coordinateReferenceSystem2);
    }

    public DefaultConversion(Map<String, ?> map, OperationMethod operationMethod, MathTransform mathTransform, ParameterValueGroup parameterValueGroup) {
        super(map, operationMethod, mathTransform, parameterValueGroup);
    }

    DefaultConversion(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws FactoryException {
        super((SingleOperation)conversion, coordinateReferenceSystem, coordinateReferenceSystem2, DefaultConversion.createMathTransform(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransformFactory));
    }

    protected DefaultConversion(Conversion conversion) {
        super((SingleOperation)conversion);
    }

    public static DefaultConversion castOrCopy(Conversion conversion) {
        return SubTypes.forConversion(conversion);
    }

    public Class<? extends Conversion> getInterface() {
        return Conversion.class;
    }

    public <T extends Conversion> T specialize(Class<T> clazz, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"baseType", clazz);
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)coordinateReferenceSystem2);
        ArgumentChecks.ensureNonNull((String)"factory", (Object)mathTransformFactory);
        DefaultConversion.ensureCompatibleDatum("sourceCRS", super.getSourceCRS(), coordinateReferenceSystem);
        if (!(coordinateReferenceSystem2 instanceof GeneralDerivedCRS)) {
            DefaultConversion.ensureCompatibleDatum("targetCRS", super.getTargetCRS(), coordinateReferenceSystem2);
        } else if (super.getTargetCRS() != null) {
            DefaultConversion.ensureCompatibleDatum("targetCRS", coordinateReferenceSystem, super.getTargetCRS());
        }
        return SubTypes.create(clazz, this, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransformFactory);
    }

    private static void ensureCompatibleDatum(String string, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        Datum datum;
        if (coordinateReferenceSystem instanceof SingleCRS && coordinateReferenceSystem2 instanceof SingleCRS && (datum = ((SingleCRS)coordinateReferenceSystem).getDatum()) != null && !Utilities.equalsIgnoreMetadata((Object)datum, (Object)((SingleCRS)coordinateReferenceSystem2).getDatum())) {
            throw new MismatchedDatumException(Errors.format((short)186, (Object)datum.getName(), (Object)string));
        }
    }

    private static Map.Entry<ParameterValueGroup, MathTransform> createMathTransform(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws FactoryException {
        AbstractMap.SimpleEntry<Object, MathTransform> simpleEntry;
        int n = ReferencingUtilities.getDimension(DefaultConversion.getInterpolationCRS((CoordinateOperation)conversion));
        MathTransform mathTransform = conversion.getMathTransform();
        if (mathTransform == null) {
            ParameterValueGroup parameterValueGroup = conversion.getParameterValues();
            if (parameterValueGroup == null) {
                throw new IllegalArgumentException(Errors.format((short)185));
            }
            mathTransform = mathTransformFactory.createBaseToDerived(coordinateReferenceSystem, parameterValueGroup, coordinateReferenceSystem2.getCoordinateSystem());
            simpleEntry = new AbstractMap.SimpleEntry<ParameterValueGroup, MathTransform>(parameterValueGroup, mathTransform);
        } else {
            simpleEntry = new AbstractMap.SimpleEntry<Object, MathTransform>(null, mathTransform);
            CoordinateReferenceSystem coordinateReferenceSystem3 = conversion.getSourceCRS();
            CoordinateReferenceSystem coordinateReferenceSystem4 = conversion.getTargetCRS();
            if (coordinateReferenceSystem3 == null && coordinateReferenceSystem4 == null && mathTransformFactory instanceof DefaultMathTransformFactory) {
                mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createBaseToDerived(coordinateReferenceSystem.getCoordinateSystem(), mathTransform, coordinateReferenceSystem2.getCoordinateSystem());
            } else {
                mathTransform = DefaultConversion.swapAndScaleAxes(mathTransform, coordinateReferenceSystem, coordinateReferenceSystem3, n, true, mathTransformFactory);
                mathTransform = DefaultConversion.swapAndScaleAxes(mathTransform, coordinateReferenceSystem4, coordinateReferenceSystem2, n, false, mathTransformFactory);
                simpleEntry.setValue(mathTransform);
                return simpleEntry;
            }
        }
        if (n != 0) {
            mathTransform = mathTransformFactory.createPassThroughTransform(n, mathTransform, 0);
        }
        simpleEntry.setValue(mathTransform);
        return simpleEntry;
    }

    private static MathTransform swapAndScaleAxes(MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, int n, boolean bl, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (coordinateReferenceSystem != null && coordinateReferenceSystem2 != null && coordinateReferenceSystem != coordinateReferenceSystem2) {
            try {
                Matrix matrix = CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem.getCoordinateSystem(), coordinateReferenceSystem2.getCoordinateSystem());
                if (!matrix.isIdentity()) {
                    if (n != 0) {
                        matrix = Matrices.createPassThrough(n, matrix, 0);
                    }
                    MathTransform mathTransform2 = mathTransformFactory.createAffineTransform(matrix);
                    mathTransform = mathTransformFactory.createConcatenatedTransform(bl ? mathTransform2 : mathTransform, bl ? mathTransform : mathTransform2);
                }
            }
            catch (ConversionException conversionException) {
                throw new IllegalArgumentException(Errors.format((short)31, (Object)(bl ? "sourceCRS" : "targetCRS"), (Object)(bl ? coordinateReferenceSystem : coordinateReferenceSystem2).getName()), conversionException);
            }
        }
        return mathTransform;
    }

    private DefaultConversion() {
    }
}

