/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.ParameterizedAffine;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.Providers;
import org.apache.sis.internal.referencing.provider.VerticalOffset;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.OperationMethodSet;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultMathTransformFactory
extends AbstractFactory
implements MathTransformFactory,
Parser {
    private static final double ELLIPSOID_PRECISION = 0.01;
    private static volatile Constructor<? extends Parser> parserConstructor;
    private final Iterable<? extends OperationMethod> methods;
    private final ConcurrentMap<String, OperationMethod> methodsByName;
    private final Map<Class<?>, OperationMethodSet> methodsByType;
    private final ThreadLocal<OperationMethod> lastMethod;
    private final WeakHashSet<MathTransform> pool;
    private final AtomicReference<Parser> parser;

    public DefaultMathTransformFactory() {
        this((Iterable<? extends OperationMethod>)((Object)new Providers()));
    }

    public DefaultMathTransformFactory(Iterable<? extends OperationMethod> iterable) {
        ArgumentChecks.ensureNonNull((String)"methods", iterable);
        this.methods = iterable;
        this.methodsByName = new ConcurrentHashMap<String, OperationMethod>();
        this.methodsByType = new IdentityHashMap();
        this.lastMethod = new ThreadLocal();
        this.pool = new WeakHashSet(MathTransform.class);
        this.parser = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OperationMethod> getAvailableMethods(Class<? extends SingleOperation> clazz) {
        Object object;
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        Object object2 = this.methodsByType;
        synchronized (object2) {
            object = this.methodsByType.get(clazz);
        }
        if (object == null) {
            object2 = this.methods;
            synchronized (object2) {
                object = new OperationMethodSet(clazz, this.methods);
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                object2 = (OperationMethodSet)((Object)JDK8.putIfAbsent(this.methodsByType, clazz, (Object)object));
            }
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationMethod getOperationMethod(String string) throws NoSuchIdentifierException {
        string = CharSequences.trimWhitespaces((String)string);
        ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)string);
        OperationMethod operationMethod = (OperationMethod)this.methodsByName.get(string);
        if (operationMethod == null) {
            ReferencingServices referencingServices = ReferencingServices.getInstance();
            OperationMethod operationMethod2 = this.methods;
            synchronized (operationMethod2) {
                operationMethod = referencingServices.getOperationMethod(this.methods, string);
            }
            if (operationMethod == null) {
                throw new NoSuchIdentifierException(Resources.format((short)50, string), string);
            }
            operationMethod2 = this.methodsByName.putIfAbsent(string.intern(), operationMethod);
            if (operationMethod2 != null) {
                operationMethod = operationMethod2;
            }
        }
        return operationMethod;
    }

    public ParameterValueGroup getDefaultParameters(String string) throws NoSuchIdentifierException {
        return this.getOperationMethod(string).getParameters().createValue();
    }

    @Deprecated
    public MathTransform createParameterizedTransform(ParameterValueGroup parameterValueGroup) throws NoSuchIdentifierException, FactoryException {
        return this.createParameterizedTransform(parameterValueGroup, null);
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameterValueGroup, Context context) throws NoSuchIdentifierException, FactoryException {
        MathTransform mathTransform;
        OperationMethod operationMethod = null;
        RuntimeException runtimeException = null;
        try {
            ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterValueGroup);
            ParameterDescriptorGroup parameterDescriptorGroup = parameterValueGroup.getDescriptor();
            String string = parameterDescriptorGroup.getName().getCode();
            String string2 = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier((IdentifiedObject)parameterDescriptorGroup, (Citation)Citations.EPSG));
            if (string2 == null) {
                string2 = string;
            }
            try {
                operationMethod = this.getOperationMethod(string2);
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {
                if (string2.equals(string)) {
                    throw noSuchIdentifierException;
                }
                operationMethod = this.getOperationMethod(string);
                Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.referencing.operation"), DefaultMathTransformFactory.class, (String)"createParameterizedTransform", (Throwable)noSuchIdentifierException);
            }
            if (!(operationMethod instanceof MathTransformProvider)) {
                throw new NoSuchIdentifierException(Errors.format((short)160, (Object)Classes.getClass((Object)operationMethod)), string);
            }
            try {
                if (context != null) {
                    runtimeException = context.completeParameters(this, operationMethod, parameterValueGroup);
                    parameterValueGroup = context.parameters;
                    operationMethod = context.provider;
                }
                mathTransform = ((MathTransformProvider)operationMethod).createMathTransform(this, parameterValueGroup);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException2) {
                throw new InvalidGeodeticParameterException(runtimeException2.getLocalizedMessage(), runtimeException2);
            }
            mathTransform = this.unique(mathTransform);
            operationMethod = DefaultOperationMethod.redimension(operationMethod, mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions());
            if (context != null) {
                mathTransform = this.swapAndScaleAxes(mathTransform, context);
            }
            this.lastMethod.set(operationMethod);
            if (context != null) {
                context.provider = null;
            }
        }
        catch (FactoryException factoryException) {
            try {
                if (runtimeException != null) {
                    factoryException.addSuppressed(runtimeException);
                }
                throw factoryException;
            }
            catch (Throwable throwable) {
                this.lastMethod.set(operationMethod);
                if (context != null) {
                    context.provider = null;
                }
                throw throwable;
            }
        }
        return mathTransform;
    }

    public MathTransform swapAndScaleAxes(MathTransform mathTransform, Context context) throws FactoryException {
        MatrixSIS matrixSIS;
        int n;
        int n2;
        int n3;
        ArgumentChecks.ensureNonNull((String)"parameterized", (Object)mathTransform);
        ArgumentChecks.ensureNonNull((String)"context", (Object)context);
        Matrix matrix = context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        Matrix matrix2 = context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        MathTransform mathTransform2 = matrix != null ? this.createAffineTransform(matrix) : MathTransforms.identity(mathTransform.getSourceDimensions());
        MathTransform mathTransform3 = matrix2 != null ? this.createAffineTransform(matrix2) : MathTransforms.identity(mathTransform.getTargetDimensions());
        MathTransform mathTransform4 = mathTransform;
        if (context.provider instanceof VerticalOffset) {
            mathTransform4 = VerticalOffset.postCreate(mathTransform4, matrix2);
        }
        if ((n3 = mathTransform3.getSourceDimensions() - mathTransform4.getTargetDimensions()) > 0) {
            mathTransform4 = this.createPassThroughTransform(0, mathTransform4, n3);
        }
        if ((n2 = mathTransform2.getTargetDimensions()) > (n = mathTransform4.getSourceDimensions())) {
            matrixSIS = Matrices.createDiagonal(n + 1, n2 + 1);
            matrixSIS.setElement(n, n2, 1.0);
            mathTransform2 = this.createConcatenatedTransform(this.createAffineTransform(matrixSIS), mathTransform2);
        }
        matrixSIS = this.createConcatenatedTransform(this.createConcatenatedTransform(mathTransform2, mathTransform4), mathTransform3);
        if (mathTransform instanceof ParameterizedAffine && !(matrixSIS instanceof ParameterizedAffine)) {
            matrixSIS = ((ParameterizedAffine)mathTransform).newTransform((MathTransform)matrixSIS);
        }
        return matrixSIS;
    }

    @Deprecated
    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, ParameterValueGroup parameterValueGroup, CoordinateSystem coordinateSystem) throws NoSuchIdentifierException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"baseCRS", (Object)coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterValueGroup);
        ArgumentChecks.ensureNonNull((String)"derivedCS", (Object)coordinateSystem);
        Context context = ReferencingUtilities.createTransformContext(coordinateReferenceSystem, null, null);
        context.setTarget(coordinateSystem);
        return this.createParameterizedTransform(parameterValueGroup, context);
    }

    @Deprecated
    public MathTransform createCoordinateSystemChange(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws FactoryException {
        return this.createCoordinateSystemChange(coordinateSystem, coordinateSystem2, null);
    }

    public MathTransform createCoordinateSystemChange(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2, Ellipsoid ellipsoid) throws FactoryException {
        boolean bl;
        ArgumentChecks.ensureNonNull((String)"source", (Object)coordinateSystem);
        ArgumentChecks.ensureNonNull((String)"target", (Object)coordinateSystem2);
        if (ellipsoid != null && (bl = coordinateSystem instanceof EllipsoidalCS) != coordinateSystem2 instanceof EllipsoidalCS && (bl ? coordinateSystem2 : coordinateSystem) instanceof CartesianCS) {
            EllipsoidalCS ellipsoidalCS;
            String string;
            Context context = new Context();
            if (bl) {
                string = "Ellipsoid_To_Geocentric";
                ellipsoidalCS = (EllipsoidalCS)coordinateSystem;
                context.setSource(ellipsoidalCS, ellipsoid);
                context.setTarget(coordinateSystem2);
            } else {
                string = "Geocentric_To_Ellipsoid";
                context.setSource(coordinateSystem);
                ellipsoidalCS = (EllipsoidalCS)coordinateSystem2;
                context.setTarget(ellipsoidalCS, ellipsoid);
            }
            ParameterValueGroup parameterValueGroup = this.getDefaultParameters(string);
            if (ellipsoidalCS.getDimension() < 3) {
                parameterValueGroup.parameter("dim").setValue(2);
            }
            return this.createParameterizedTransform(parameterValueGroup, context);
        }
        return CoordinateSystemTransform.create(this, coordinateSystem, coordinateSystem2);
    }

    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        this.lastMethod.remove();
        return this.unique(MathTransforms.linear(matrix));
    }

    public MathTransform createConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        MathTransform mathTransform3;
        this.lastMethod.remove();
        ArgumentChecks.ensureNonNull((String)"tr1", (Object)mathTransform);
        ArgumentChecks.ensureNonNull((String)"tr2", (Object)mathTransform2);
        try {
            mathTransform3 = ConcatenatedTransform.create(mathTransform, mathTransform2, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(mathTransform3))) : mathTransform3;
        return this.unique(mathTransform3);
    }

    public MathTransform createPassThroughTransform(int n, MathTransform mathTransform, int n2) throws FactoryException {
        MathTransform mathTransform2;
        this.lastMethod.remove();
        try {
            mathTransform2 = PassThroughTransform.create(n, mathTransform, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
        }
        return this.unique(mathTransform2);
    }

    @Deprecated
    public MathTransform createFromXML(String string) throws FactoryException {
        this.lastMethod.remove();
        throw new FactoryException(Errors.format((short)162, (Object)"createFromXML"));
    }

    public MathTransform createFromWKT(String string) throws FactoryException {
        Constructor<Parser> constructor;
        this.lastMethod.remove();
        Parser parser = this.parser.getAndSet(null);
        if (parser == null) {
            try {
                constructor = parserConstructor;
                if (constructor == null) {
                    final Constructor<Parser> constructor2 = constructor = Class.forName("org.apache.sis.io.wkt.MathTransformParser").asSubclass(Parser.class).getConstructor(MathTransformFactory.class);
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            constructor2.setAccessible(true);
                            return null;
                        }
                    });
                    parserConstructor = constructor;
                }
                parser = (Parser)constructor.newInstance(new Object[]{this});
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new FactoryException((Throwable)reflectiveOperationException);
            }
        }
        try {
            constructor = parser.createFromWKT(string);
        }
        catch (FactoryException factoryException) {
            for (Throwable throwable = factoryException.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof ParameterNotFoundException)) continue;
                throw new InvalidGeodeticParameterException(factoryException.getLocalizedMessage(), throwable);
            }
            throw factoryException;
        }
        this.parser.set(parser);
        return (MathTransform)constructor;
    }

    private MathTransform unique(MathTransform mathTransform) {
        return (MathTransform)this.pool.unique((Object)mathTransform);
    }

    public OperationMethod getLastMethodUsed() {
        return this.lastMethod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Iterable<? extends OperationMethod> iterable = this.methods;
        synchronized (iterable) {
            this.methodsByName.clear();
            Iterable<? extends OperationMethod> iterable2 = this.methods;
            if (iterable2 instanceof LazySet) {
                ((LazySet)((Object)iterable2)).reload();
            }
            if (iterable2 instanceof ServiceLoader) {
                ((ServiceLoader)iterable2).reload();
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                for (OperationMethodSet operationMethodSet : this.methodsByType.values()) {
                    operationMethodSet.reset();
                }
            }
            this.pool.clear();
        }
    }

    public static class Context
    implements Serializable {
        private static final long serialVersionUID = 6963581151055917955L;
        private CoordinateSystem sourceCS;
        private CoordinateSystem targetCS;
        private Ellipsoid sourceEllipsoid;
        private Ellipsoid targetEllipsoid;
        OperationMethod provider;
        ParameterValueGroup parameters;

        public void setSource(CoordinateSystem coordinateSystem) {
            this.sourceCS = coordinateSystem;
            this.sourceEllipsoid = null;
        }

        public void setSource(EllipsoidalCS ellipsoidalCS, Ellipsoid ellipsoid) {
            this.sourceCS = ellipsoidalCS;
            this.sourceEllipsoid = ellipsoid;
        }

        public void setTarget(CoordinateSystem coordinateSystem) {
            this.targetCS = coordinateSystem;
            this.targetEllipsoid = null;
        }

        public void setTarget(EllipsoidalCS ellipsoidalCS, Ellipsoid ellipsoid) {
            this.targetCS = ellipsoidalCS;
            this.targetEllipsoid = ellipsoid;
        }

        public CoordinateSystem getSourceCS() {
            return this.sourceCS;
        }

        public Ellipsoid getSourceEllipsoid() {
            return this.sourceEllipsoid;
        }

        public CoordinateSystem getTargetCS() {
            return this.targetCS;
        }

        public Ellipsoid getTargetEllipsoid() {
            return this.targetEllipsoid;
        }

        public Matrix getMatrix(ContextualParameters.MatrixRole matrixRole) throws FactoryException {
            CoordinateSystem coordinateSystem;
            boolean bl = false;
            switch (matrixRole) {
                default: {
                    throw new IllegalArgumentException(Errors.format((short)45, (Object)"role", (Object)((Object)matrixRole)));
                }
                case INVERSE_NORMALIZATION: {
                    bl = true;
                }
                case NORMALIZATION: {
                    coordinateSystem = this.getSourceCS();
                    break;
                }
                case INVERSE_DENORMALIZATION: {
                    bl = true;
                }
                case DENORMALIZATION: {
                    bl = !bl;
                    coordinateSystem = this.getTargetCS();
                }
            }
            if (coordinateSystem == null) {
                return null;
            }
            CoordinateSystem coordinateSystem2 = CoordinateSystems.replaceAxes(coordinateSystem, AxesConvention.NORMALIZED);
            try {
                if (bl) {
                    return CoordinateSystems.swapAndScaleAxes(coordinateSystem2, coordinateSystem);
                }
                return CoordinateSystems.swapAndScaleAxes(coordinateSystem, coordinateSystem2);
            }
            catch (IllegalArgumentException | IncommensurableException throwable) {
                throw new InvalidGeodeticParameterException(throwable.getLocalizedMessage(), throwable);
            }
        }

        public ParameterValueGroup getCompletedParameters() {
            if (this.parameters != null) {
                return this.parameters;
            }
            throw new IllegalStateException(Resources.format((short)70));
        }

        private void ensureCompatibleParameters(boolean bl) throws IllegalArgumentException {
            ParameterDescriptorGroup parameterDescriptorGroup = this.provider.getParameters();
            if (this.parameters.getDescriptor() != parameterDescriptorGroup || bl && this.parameters instanceof Parameters && !(this.parameters instanceof DefaultParameterValueGroup)) {
                ParameterValueGroup parameterValueGroup = parameterDescriptorGroup.createValue();
                Parameters.copy(this.parameters, parameterValueGroup);
                this.parameters = parameterValueGroup;
            }
        }

        private static double getValue(ParameterValue<?> parameterValue, Unit<Length> unit) {
            return parameterValue.getValue() != null ? parameterValue.doubleValue(unit) : Double.NaN;
        }

        private static boolean ensureSet(ParameterValue<?> parameterValue, double d, double d2, Unit<?> unit, double d3) {
            if (Math.abs(d - d2) <= d3) {
                return false;
            }
            if (Double.isNaN(d)) {
                parameterValue.setValue(d2, unit);
                return false;
            }
            return true;
        }

        private RuntimeException setEllipsoid(Ellipsoid ellipsoid, String string, String string2, boolean bl, RuntimeException runtimeException) {
            if (ellipsoid != null) {
                boolean bl2;
                Object object;
                this.ensureCompatibleParameters(true);
                Object object2 = null;
                double d = 0.0;
                try {
                    ParameterValue parameterValue = this.parameters.parameter(string);
                    object = this.parameters.parameter(string2);
                    Unit unit = ellipsoid.getAxisUnit();
                    double d2 = Context.getValue(parameterValue, (Unit<Length>)unit);
                    double d3 = Context.getValue(object, (Unit<Length>)unit);
                    double d4 = Units.METRE.getConverterTo(unit).convert(0.01);
                    if (Context.ensureSet(parameterValue, d2, ellipsoid.getSemiMajorAxis(), unit, d4)) {
                        object2 = parameterValue;
                        d = d2;
                    }
                    if (Context.ensureSet(object, d3, ellipsoid.getSemiMinorAxis(), unit, d4)) {
                        object2 = object;
                        d = d3;
                    }
                }
                catch (IllegalArgumentException | IllegalStateException runtimeException2) {
                    if (runtimeException == null) {
                        runtimeException = runtimeException2;
                    }
                    runtimeException.addSuppressed(runtimeException2);
                }
                if (object2 != null) {
                    object = Resources.forLocale(null).getLogRecord(Level.WARNING, (short)33, ellipsoid.getName().getCode(), object2.getDescriptor().getName().getCode(), d);
                    ((LogRecord)object).setLoggerName("org.apache.sis.referencing.operation");
                    Logging.log(DefaultMathTransformFactory.class, (String)"createParameterizedTransform", (LogRecord)object);
                    bl2 = false;
                } else {
                    boolean bl3 = bl2 = bl && ellipsoid.isIvfDefinitive();
                }
                if (bl2) {
                    try {
                        this.parameters.parameter("inverse_flattening").setValue(ellipsoid.getInverseFlattening());
                    }
                    catch (ParameterNotFoundException parameterNotFoundException) {
                        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.referencing.operation"), DefaultMathTransformFactory.class, (String)"createParameterizedTransform", (Throwable)parameterNotFoundException);
                    }
                }
            }
            return runtimeException;
        }

        final RuntimeException completeParameters(DefaultMathTransformFactory defaultMathTransformFactory, OperationMethod operationMethod, ParameterValueGroup parameterValueGroup) throws FactoryException, IllegalArgumentException {
            int n;
            Serializable serializable;
            Object object;
            if (operationMethod instanceof AbstractProvider && (object = ((AbstractProvider)operationMethod).resolveAmbiguity(this)) != null) {
                operationMethod = defaultMathTransformFactory.getOperationMethod((String)object);
            }
            this.provider = operationMethod;
            this.parameters = parameterValueGroup;
            if (operationMethod instanceof DefaultOperationMethod && operationMethod.getClass() != DefaultOperationMethod.class) {
                object = this.sourceCS != null ? this.sourceCS.getDimension() : operationMethod.getSourceDimensions().intValue();
                serializable = this.targetCS != null ? this.targetCS.getDimension() : operationMethod.getTargetDimensions().intValue();
                if (object != null && serializable != null && (operationMethod = ((DefaultOperationMethod)operationMethod).redimension((Integer)object, (int)serializable)) instanceof MathTransformProvider) {
                    this.provider = operationMethod;
                }
            }
            this.ensureCompatibleParameters(false);
            if (this.provider instanceof AbstractProvider) {
                n = ((AbstractProvider)this.provider).getEllipsoidsMask();
            } else {
                n = 0;
                if (this.sourceEllipsoid != null) {
                    n = 1;
                }
                if (this.targetEllipsoid != null) {
                    n |= 2;
                }
            }
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.setEllipsoid(this.getSourceEllipsoid(), "semi_major", "semi_minor", true, null);
                }
                case 2: {
                    return this.setEllipsoid(this.getTargetEllipsoid(), "semi_major", "semi_minor", true, null);
                }
                case 3: {
                    serializable = null;
                    if (this.sourceCS != null) {
                        try {
                            this.ensureCompatibleParameters(true);
                            ParameterValue parameterValue = this.parameters.parameter("dim");
                            if (parameterValue.getValue() == null) {
                                parameterValue.setValue(this.sourceCS.getDimension());
                            }
                        }
                        catch (IllegalArgumentException | IllegalStateException runtimeException) {
                            serializable = runtimeException;
                        }
                    }
                    serializable = this.setEllipsoid(this.getSourceEllipsoid(), "src_semi_major", "src_semi_minor", false, (RuntimeException)serializable);
                    serializable = this.setEllipsoid(this.getTargetEllipsoid(), "tgt_semi_major", "tgt_semi_minor", false, (RuntimeException)serializable);
                    return serializable;
                }
            }
            throw new AssertionError(n);
        }
    }
}

