/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.awt.image.DataBuffer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.internal.coverage.RasterFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Raster;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.storage.AbstractGridResource;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public final class RasterResource
extends AbstractGridResource
implements ResourceOnFileSystem {
    private static final String[] VECTOR_COMPONENT_NAMES = new String[]{"eastward", "westward", "northward", "southward", "upward", "downward"};
    private GenericName identifier;
    private final GridGeometry gridGeometry;
    private final SampleDimension[] ranges;
    private final Variable[] data;
    private final int bandDimension;
    private final Path location;
    private final Object lock;

    private RasterResource(Decoder decoder, String string, GridGeometry gridGeometry, List<Variable> list, int n, int n2, Object object) {
        super(decoder.listeners);
        this.data = list.toArray(new Variable[list.size()]);
        this.ranges = new SampleDimension[n];
        this.identifier = decoder.nameFactory.createLocalName(decoder.namespace, (CharSequence)string);
        this.location = decoder.location;
        this.gridGeometry = gridGeometry;
        this.bandDimension = n2;
        this.lock = object;
        assert (this.data.length == (this.bandDimension >= 0 ? 1 : this.ranges.length));
    }

    public static List<Resource> create(Decoder decoder, Object object) throws IOException, DataStoreException {
        assert (Thread.holdsLock(object));
        Variable[] variableArray = (Variable[])decoder.getVariables().clone();
        ArrayList<Variable> arrayList = new ArrayList<Variable>(4);
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>(variableArray.length);
        HashMap<GenericName, Object> hashMap = new HashMap<GenericName, Object>();
        for (int i = 0; i < variableArray.length; ++i) {
            int n;
            Object object2;
            int n2;
            GridGeometry gridGeometry;
            Variable variable = variableArray[i];
            if (variable == null || variable.getRole() != VariableRole.COVERAGE || (gridGeometry = variable.getGridGeometry()) == null) continue;
            arrayList.add(variable);
            String string = variable.getStandardName();
            List<Dimension> list = variable.getGridDimensions();
            int n3 = list.size();
            int n4 = gridGeometry.getDimension();
            if (n3 != n4) {
                n2 = variable.bandDimension;
                object2 = list.get(n3 - 1 - n2);
                n = Math.toIntExact(((Dimension)object2).length());
                if (n3 != n4 + 1 || n2 > 0 && n2 != n4) {
                    throw new DataStoreContentException(Resources.forLocale(decoder.listeners.getLocale()).getString((short)19, string, decoder.getFilename(), n3, n4));
                }
            } else {
                n2 = -1;
                object2 = variable.getDataType();
                for (String string2 : VECTOR_COMPONENT_NAMES) {
                    int n5 = string.indexOf(string2);
                    if (n5 < 0) continue;
                    int n6 = n5 + string2.length();
                    int n7 = string.length() - n6;
                    int n8 = i;
                    block2: while (++n8 < variableArray.length) {
                        Variable variable2 = variableArray[n8];
                        if (variable2 == null || variable2.getRole() != VariableRole.COVERAGE) {
                            variableArray[n8] = null;
                            continue;
                        }
                        String string3 = variable2.getStandardName();
                        if (!string3.regionMatches(string3.length() - n7, string, n6, n7) || !string3.regionMatches(0, string, 0, n5) || variable2.getDataType() != object2 || !gridGeometry.equals((Object)variable2.getGridGeometry())) continue;
                        for (String string4 : VECTOR_COMPONENT_NAMES) {
                            if (!string3.regionMatches(n5, string4, 0, string4.length())) continue;
                            arrayList.add(variable2);
                            variableArray[n8] = null;
                            continue block2;
                        }
                    }
                    if (arrayList.size() <= 1) continue;
                    if (n7 != 0) {
                        n8 = string.codePointAt(n6);
                        if (n5 != 0 ? n8 == string.codePointBefore(n5) : n8 == 95) {
                            n6 += Character.charCount(n8);
                        }
                    }
                    string = new StringBuilder(string).delete(n5, n6).toString();
                }
                n = arrayList.size();
            }
            object2 = new RasterResource(decoder, string.trim(), gridGeometry, arrayList, n, n2, object);
            super.resolveNameCollision((RasterResource)((Object)hashMap.putIfAbsent(((RasterResource)((Object)object2)).identifier, object2)), decoder);
            arrayList2.add((Resource)object2);
            arrayList.clear();
        }
        return arrayList2;
    }

    private void resolveNameCollision(RasterResource rasterResource, Decoder decoder) {
        if (rasterResource != null) {
            if (this.identifier.equals(rasterResource.identifier)) {
                rasterResource.resolveNameCollision(decoder);
            }
            this.resolveNameCollision(decoder);
        }
    }

    private void resolveNameCollision(Decoder decoder) {
        String string = this.identifier + " (" + this.data[0].getName() + ')';
        this.identifier = decoder.nameFactory.createLocalName(decoder.namespace, (CharSequence)string);
    }

    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier);
    }

    public GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    private Variable getVariable(int n) {
        return this.data[this.bandDimension >= 0 ? 0 : n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        SampleDimension.Builder builder = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i < this.ranges.length; ++i) {
                    if (this.ranges[i] != null) continue;
                    if (builder == null) {
                        builder = new SampleDimension.Builder();
                    }
                    this.ranges[i] = this.createSampleDimension(builder, this.getVariable(i), i);
                    builder.clear();
                }
            }
        }
        catch (TransformException transformException) {
            throw new DataStoreReferencingException((Throwable)transformException);
        }
        return UnmodifiableArrayList.wrap((Object[])this.ranges);
    }

    private SampleDimension createSampleDimension(SampleDimension.Builder builder, Variable variable, int n) throws TransformException {
        NumberRange numberRange;
        if (!RasterResource.createEnumeration(builder, variable, n) && (numberRange = variable.getValidRange()) != null) {
            Object object;
            MathTransform1D mathTransform1D = variable.getTransferFunction().getTransform();
            if (!mathTransform1D.isIdentity() && numberRange instanceof MeasurementRange) {
                object = mathTransform1D.inverse();
                boolean bl = numberRange.isMinIncluded();
                boolean bl2 = numberRange.isMaxIncluded();
                double d = object.transform(numberRange.getMinDouble());
                double d2 = object.transform(numberRange.getMaxDouble());
                if (d2 < d) {
                    double d3 = d2;
                    d2 = d;
                    d = d3;
                    boolean bl3 = bl2;
                    bl2 = bl;
                    bl = bl3;
                }
                numberRange = variable.getDataType().number <= 6 && d >= -9.223372036854776E18 && d2 <= 9.223372036854776E18 ? NumberRange.create((long)Math.round(d), (boolean)bl, (long)Math.round(d2), (boolean)bl2) : NumberRange.create((double)d, (boolean)bl, (double)d2, (boolean)bl2);
            }
            if (numberRange.isEmpty()) {
                variable.warning(RasterResource.class, "getSampleDimensions", (short)16, variable.getFilename(), variable.getName(), numberRange.getMinValue(), numberRange.getMaxValue());
            } else {
                object = variable.getDescription();
                if (object == null) {
                    object = variable.getName();
                }
                builder.addQuantitative((CharSequence)object, numberRange, mathTransform1D, variable.getUnit());
            }
        }
        boolean bl = true;
        int n2 = variable.hasRealValues() ? 0 : -1;
        CharSequence[] charSequenceArray = new CharSequence[2];
        for (Map.Entry<Number, Object> entry : variable.getNodataValues().entrySet()) {
            CharSequence charSequence;
            Number number = n2 >= 0 ? (Number)Float.valueOf(MathFunctions.toNanFloat((int)n2++)) : (Number)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Integer) {
                int n3 = (Integer)object;
                int n4 = n3 == 1 ? 1 : 0;
                charSequence = charSequenceArray[n4];
                if (charSequence == null) {
                    charSequenceArray[n4] = charSequence = Vocabulary.formatInternational((short)(n4 == 0 ? (short)160 : 159));
                }
                if (bl & (n3 & 1) != 0) {
                    bl = false;
                    builder.setBackground(charSequence, number);
                    continue;
                }
            } else {
                charSequence = (CharSequence)object;
            }
            builder.addQualitative(charSequence, number, number);
        }
        Object object = variable.getName();
        if (this.bandDimension >= 0) {
            object = Strings.toIndexed((String)object, (int)n);
        }
        return builder.setName((CharSequence)object).build();
    }

    private static boolean createEnumeration(SampleDimension.Builder builder, Variable variable, int n) {
        CharSequence[] charSequenceArray = variable.getAttributeAsStrings("flag_names", ' ');
        if (charSequenceArray == null && (charSequenceArray = variable.getAttributeAsStrings("flag_meanings", ' ')) == null) {
            return false;
        }
        Vector vector = variable.getAttributeAsVector("flag_values");
        if (vector == null && (vector = variable.getAttributeAsVector("flag_masks")) == null) {
            return false;
        }
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            Number number = vector.get(i);
            Object object = i < charSequenceArray.length ? charSequenceArray[i] : Vocabulary.formatInternational((short)108);
            builder.addQualitative((CharSequence)object, number, number);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        DataBuffer dataBuffer;
        Object object;
        AbstractGridResource.RangeArgument rangeArgument = this.validateRangeArgument(this.ranges.length, nArray);
        if (gridGeometry == null) {
            gridGeometry = this.gridGeometry;
        }
        Variable variable = this.data[this.bandDimension >= 0 ? 0 : rangeArgument.getFirstSpecified()];
        DataType dataType = variable.getDataType();
        if (this.bandDimension < 0) {
            for (int i = 0; i < rangeArgument.getNumBands(); ++i) {
                object = this.data[rangeArgument.getSourceIndex(i)];
                if (dataType.equals((Object)((Variable)object).getDataType())) continue;
                throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)13, this.getFilename(), variable.getName(), ((Variable)object).getName()));
            }
        }
        object = new SampleDimension[rangeArgument.getNumBands()];
        int[] nArray2 = null;
        try {
            int n;
            int n2;
            GridDerivation gridDerivation = this.gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(gridGeometry);
            GridExtent gridExtent = gridDerivation.getIntersection();
            int[] nArray3 = gridDerivation.getSubsamplings();
            int n3 = ((Object)object).length;
            gridGeometry = gridDerivation.build();
            if (this.bandDimension >= 0) {
                gridExtent = rangeArgument.insertBandDimension(gridExtent, this.bandDimension);
                nArray3 = rangeArgument.insertSubsampling(nArray3, this.bandDimension);
                if (this.bandDimension == 0) {
                    nArray2 = new int[n3];
                }
                n3 = 1;
            }
            Buffer[] bufferArray = new Buffer[n3];
            Object object2 = this.lock;
            synchronized (object2) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    n2 = rangeArgument.getSourceIndex(i);
                    n = rangeArgument.getTargetIndex(i);
                    Variable variable2 = this.getVariable(n2);
                    SampleDimension sampleDimension = this.ranges[n2];
                    if (sampleDimension == null) {
                        this.ranges[n2] = sampleDimension = this.createSampleDimension(rangeArgument.builder(), variable2, i);
                    }
                    object[n] = sampleDimension;
                    if (nArray2 != null) {
                        nArray2[n] = i;
                        n = 0;
                    }
                    if (i >= n3) continue;
                    bufferArray[n] = (Buffer)variable2.read(gridExtent, nArray3).buffer().get();
                }
            }
            if (this.bandDimension > 0) {
                int n4 = Math.toIntExact(this.data[0].getBandStride());
                Buffer buffer = bufferArray[0].limit(n4);
                bufferArray = new Buffer[((Object)object).length];
                for (n2 = 0; n2 < bufferArray.length; ++n2) {
                    if (n2 != 0) {
                        buffer = JDK9.duplicate((Buffer)buffer);
                        n = buffer.limit();
                        buffer.position(n).limit(Math.addExact(n, n4));
                    }
                    bufferArray[n2] = buffer;
                }
            }
            dataBuffer = RasterFactory.wrap((int)dataType.rasterDataType, (Buffer[])bufferArray);
        }
        catch (IOException iOException) {
            throw new DataStoreException((Throwable)iOException);
        }
        catch (TransformException transformException) {
            throw new DataStoreReferencingException((Throwable)transformException);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof TransformException) {
                throw new DataStoreReferencingException(throwable);
            }
            throw new DataStoreContentException((Throwable)runtimeException);
        }
        if (dataBuffer == null) {
            throw new DataStoreContentException(Errors.getResources((Locale)this.getLocale()).getString((short)163, (Object)dataType.name()));
        }
        return new Raster(gridGeometry, (List<SampleDimension>)UnmodifiableArrayList.wrap((Object[])object), dataBuffer, rangeArgument.getPixelStride(), nArray2, String.valueOf(this.identifier));
    }

    private String getFilename() {
        if (this.location != null) {
            return this.location.getFileName().toString();
        }
        return Vocabulary.getResources((Locale)this.getLocale()).getString((short)108);
    }

    public Path[] getComponentFiles() {
        Path[] pathArray;
        if (this.location != null) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = this.location;
        } else {
            pathArray = new Path[]{};
        }
        return pathArray;
    }
}

