/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.htl.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.sling.scripting.sightly.compiler.CompilationUnit;

public class ScriptCompilationUnit
implements CompilationUnit {
    private Reader reader;
    private File sourceDirectory;
    private File script;
    private String scriptName;
    private static final int _16K = 16384;

    public ScriptCompilationUnit(File sourceDirectory, File script) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(script), 16384);
        this.sourceDirectory = sourceDirectory;
        this.script = script;
    }

    public String getScriptName() {
        if (this.scriptName == null) {
            this.scriptName = this.script.getAbsolutePath().substring(this.sourceDirectory.getAbsolutePath().length());
        }
        return this.scriptName;
    }

    public Reader getScriptReader() {
        return this.reader;
    }

    public void dispose() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

