/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.util.Validator;
import org.codehaus.plexus.util.DirectoryScanner;

public class ValidationMojo
extends AbstractMojo {
    private MavenProject project;
    private boolean skip;
    private boolean skipJson;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Validation is skipped.");
            return;
        }
        for (Resource rsrc : this.project.getResources()) {
            File directory = new File(rsrc.getDirectory());
            if (!directory.exists()) continue;
            this.getLog().debug((CharSequence)("Scanning " + rsrc.getDirectory()));
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(directory);
            if (rsrc.getExcludes() != null && rsrc.getExcludes().size() > 0) {
                scanner.setExcludes(rsrc.getExcludes().toArray(new String[rsrc.getExcludes().size()]));
            }
            scanner.addDefaultExcludes();
            if (rsrc.getIncludes() != null && rsrc.getIncludes().size() > 0) {
                scanner.setIncludes(rsrc.getIncludes().toArray(new String[rsrc.getIncludes().size()]));
            }
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            if (files == null) continue;
            for (int m = 0; m < files.length; ++m) {
                this.validate(directory, files[m]);
            }
        }
    }

    private void validate(File directory, String fileName) throws MojoExecutionException {
        block6: {
            this.getLog().debug((CharSequence)("Validating " + fileName));
            File file = new File(directory, fileName);
            if (!file.isFile() || !fileName.endsWith(".json") || this.skipJson) break block6;
            this.getLog().debug((CharSequence)("Validation JSON file " + fileName));
            FileInputStream fis = null;
            String json = null;
            try {
                fis = new FileInputStream(file);
                json = IOUtils.toString((InputStream)fis);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("An Error occured while validating the file '" + fileName + "'", (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            try {
                Validator.validate((String)json);
            }
            catch (JSONException e) {
                throw new MojoExecutionException("An Error occured while validating the file '" + fileName + "'", (Exception)((Object)e));
            }
        }
    }
}

