/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource.path;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.resource.path.Path;

public class PathSet
implements Iterable<Path> {
    public static final PathSet EMPTY_SET = new PathSet(Collections.emptySet());
    private final Set<Path> paths;

    public static PathSet fromPathCollection(Collection<Path> paths) {
        HashSet<Path> set = new HashSet<Path>();
        for (Path p : paths) {
            set.add(p);
        }
        PathSet.optimize(set);
        return new PathSet(set);
    }

    public static PathSet fromPaths(Path ... paths) {
        HashSet<Path> set = new HashSet<Path>();
        for (Path p : paths) {
            set.add(p);
        }
        PathSet.optimize(set);
        return new PathSet(set);
    }

    public static PathSet fromStringCollection(Collection<String> paths) {
        HashSet<Path> set = new HashSet<Path>();
        for (String p : paths) {
            set.add(new Path(p));
        }
        PathSet.optimize(set);
        return new PathSet(set);
    }

    public static PathSet fromStrings(String ... strings) {
        HashSet<Path> set = new HashSet<Path>();
        for (String p : strings) {
            set.add(new Path(p));
        }
        PathSet.optimize(set);
        return new PathSet(set);
    }

    private static void optimize(Set<Path> set) {
        Iterator<Path> i = set.iterator();
        while (i.hasNext()) {
            Path next = i.next();
            boolean found = false;
            for (Path p : set) {
                if (p == next || !p.matches(next.getPath())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            i.remove();
        }
    }

    private PathSet(Set<Path> paths) {
        this.paths = paths;
    }

    public Path matches(String otherPath) {
        for (Path p : this.paths) {
            if (!p.matches(otherPath)) continue;
            return p;
        }
        return null;
    }

    public PathSet getSubset(String path) {
        return this.getSubset(new Path(path));
    }

    public PathSet getSubset(Path path) {
        HashSet<Path> result = new HashSet<Path>();
        for (Path p : this.paths) {
            if (!path.matches(p.getPath())) continue;
            result.add(p);
        }
        return new PathSet(result);
    }

    public Set<String> toStringSet() {
        HashSet<String> set = new HashSet<String>();
        for (Path p : this) {
            set.add(p.getPath());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Iterator<Path> iterator() {
        return Collections.unmodifiableSet(this.paths).iterator();
    }

    public int hashCode() {
        return this.paths.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PathSet)) {
            return false;
        }
        return this.paths.equals(((PathSet)obj).paths);
    }
}

