/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class ResourceUtil {
    @CheckForNull
    public static String normalize(@Nonnull String path) {
        if (path.length() == 0) {
            return path;
        }
        int absOffset = path.charAt(0) == '/' ? 0 : 1;
        char[] buf = new char[path.length() + 1 + absOffset];
        if (absOffset == 1) {
            buf[0] = 47;
        }
        path.getChars(0, path.length(), buf, absOffset);
        buf[buf.length - 1] = 47;
        int lastSlash = 0;
        int numDots = 0;
        int bufPos = 0;
        for (int bufIdx = lastSlash; bufIdx < buf.length; ++bufIdx) {
            int nextSlash;
            char c = buf[bufIdx];
            if (c == '/') {
                if (numDots == 2) {
                    if (bufPos == 0) {
                        return null;
                    }
                    while (--bufPos > 0 && buf[bufPos] != '/') {
                    }
                }
                lastSlash = bufIdx;
                numDots = 0;
                continue;
            }
            if (c == '.' && numDots < 2) {
                ++numDots;
                continue;
            }
            for (nextSlash = bufIdx + 1; nextSlash < buf.length && buf[nextSlash] != '/'; ++nextSlash) {
            }
            if (bufPos < lastSlash) {
                int segLen = nextSlash - bufIdx + 1;
                System.arraycopy(buf, lastSlash, buf, bufPos, segLen);
                bufPos += segLen;
            } else {
                bufPos = nextSlash;
            }
            numDots = 0;
            lastSlash = nextSlash;
            bufIdx = nextSlash;
        }
        String resolved = bufPos == 0 && numDots == 0 ? (absOffset == 0 ? "/" : "") : (bufPos - absOffset == path.length() ? path : new String(buf, absOffset, bufPos - absOffset));
        return resolved;
    }

    @CheckForNull
    public static String getParent(@Nonnull String path) {
        int lastSlash;
        if ("/".equals(path)) {
            return null;
        }
        if ((path = ResourceUtil.normalize(path)) == null || "/".equals(path)) {
            return null;
        }
        String workspaceName = null;
        int wsSepPos = path.indexOf(":/");
        if (wsSepPos != -1) {
            workspaceName = path.substring(0, wsSepPos);
            path = path.substring(wsSepPos + 1);
        }
        if ((lastSlash = path.lastIndexOf(47)) < 0) {
            return null;
        }
        if (lastSlash == 0) {
            if (workspaceName != null) {
                return workspaceName + ":/";
            }
            return "/";
        }
        String parentPath = path.substring(0, lastSlash);
        if (workspaceName != null) {
            return workspaceName + ":" + parentPath;
        }
        return parentPath;
    }

    public static String getParent(String path, int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level must be non-negative");
        }
        String result = path;
        for (int i = 0; i < level && (result = ResourceUtil.getParent(result)) != null; ++i) {
        }
        return result;
    }

    @Deprecated
    @CheckForNull
    public static Resource getParent(@Nonnull Resource rsrc) {
        return rsrc.getParent();
    }

    @Deprecated
    @Nonnull
    public static String getName(@Nonnull Resource rsrc) {
        return ResourceUtil.getName(rsrc.getPath());
    }

    @Nonnull
    public static String getName(@Nonnull String path) {
        if ("/".equals(path)) {
            return "";
        }
        if ("/".equals(path = ResourceUtil.normalize(path))) {
            return "";
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean isSyntheticResource(@Nonnull Resource res) {
        if (res instanceof SyntheticResource) {
            return true;
        }
        if (!(res instanceof ResourceWrapper)) {
            return false;
        }
        while ((res = ((ResourceWrapper)res).getResource()) instanceof ResourceWrapper) {
        }
        return res instanceof SyntheticResource;
    }

    public static boolean isStarResource(@Nonnull Resource res) {
        return res.getPath().endsWith("/*");
    }

    public static boolean isNonExistingResource(@Nonnull Resource res) {
        return "sling:nonexisting".equals(res.getResourceType());
    }

    @Deprecated
    @Nonnull
    public static Iterator<Resource> listChildren(@Nonnull Resource parent) {
        return parent.getResourceResolver().listChildren(parent);
    }

    @Nonnull
    public static ValueMap getValueMap(@Nonnull Resource res) {
        if (res == null) {
            return new ValueMapDecorator(new HashMap<String, Object>());
        }
        return res.getValueMap();
    }

    @Nonnull
    public static String resourceTypeToPath(@Nonnull String type) {
        return type.replace(':', '/');
    }

    @Deprecated
    @CheckForNull
    public static String getResourceSuperType(@Nonnull ResourceResolver resourceResolver, String resourceType) {
        return resourceResolver.getParentResourceType(resourceType);
    }

    @Deprecated
    @CheckForNull
    public static String findResourceSuperType(@Nonnull Resource resource) {
        if (resource == null) {
            return null;
        }
        return resource.getResourceResolver().getParentResourceType(resource);
    }

    @Deprecated
    public static boolean isA(@Nonnull Resource resource, String resourceType) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceResolver().isResourceType(resource, resourceType);
    }

    @Nonnull
    public static <T> Iterator<T> adaptTo(final @Nonnull Iterator<Resource> iterator, final Class<T> type) {
        return new Iterator<T>(){
            private T nextObject = this.seek();

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextObject;
                this.nextObject = this.seek();
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private T seek() {
                Object result = null;
                while (result == null && iterator.hasNext()) {
                    Resource r = (Resource)iterator.next();
                    result = r.adaptTo(type);
                }
                return result;
            }
        };
    }

    @Nonnull
    public static Resource getOrCreateResource(@Nonnull ResourceResolver resolver, @Nonnull String path, String resourceType, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        Map<String, Object> props = resourceType == null ? null : Collections.singletonMap("sling:resourceType", resourceType);
        return ResourceUtil.getOrCreateResource(resolver, path, props, intermediateResourceType, autoCommit);
    }

    @Nonnull
    public static Resource getOrCreateResource(@Nonnull ResourceResolver resolver, @Nonnull String path, Map<String, Object> resourceProperties, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        PersistenceException mostRecentPE = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return ResourceUtil.getOrCreateResourceInternal(resolver, path, resourceProperties, intermediateResourceType, autoCommit);
            }
            catch (PersistenceException pe) {
                if (!autoCommit) {
                    throw pe;
                }
                resolver.revert();
                resolver.refresh();
                mostRecentPE = pe;
                continue;
            }
        }
        throw mostRecentPE;
    }

    private static Resource getOrCreateResourceInternal(ResourceResolver resolver, String path, Map<String, Object> resourceProperties, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        Resource rsrc;
        block12: {
            rsrc = resolver.getResource(path);
            if (rsrc == null) {
                Resource parentResource;
                String name;
                block11: {
                    int lastPos = path.lastIndexOf(47);
                    name = path.substring(lastPos + 1);
                    if (lastPos == 0) {
                        parentResource = resolver.getResource("/");
                    } else {
                        String parentPath = path.substring(0, lastPos);
                        parentResource = ResourceUtil.getOrCreateResource(resolver, parentPath, intermediateResourceType, intermediateResourceType, autoCommit);
                    }
                    if (autoCommit) {
                        resolver.refresh();
                    }
                    try {
                        for (int retry = 5; retry > 0 && rsrc == null; --retry) {
                            rsrc = resolver.create(parentResource, name, resourceProperties);
                            if (name.equals(rsrc.getName())) continue;
                            resolver.refresh();
                            resolver.delete(rsrc);
                            rsrc = resolver.getResource(parentResource, name);
                        }
                        if (rsrc == null) {
                            throw new PersistenceException("Unable to create resource.");
                        }
                    }
                    catch (PersistenceException pe) {
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                        if (rsrc != null) break block11;
                        throw pe;
                    }
                }
                if (autoCommit) {
                    try {
                        resolver.commit();
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                    }
                    catch (PersistenceException pe) {
                        resolver.revert();
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                        if (rsrc != null) break block12;
                        rsrc = resolver.create(parentResource, name, resourceProperties);
                        resolver.commit();
                    }
                }
            }
        }
        return rsrc;
    }

    public static String createUniqueChildName(Resource parent, String name) throws PersistenceException {
        if (parent.getChild(name) != null) {
            String childNodeName = null;
            int i = 0;
            do {
                childNodeName = name + String.valueOf(i);
                if (i == Integer.MAX_VALUE) {
                    String message = MessageFormat.format("can not find a unique name {0} for {1}", name, parent.getPath());
                    throw new PersistenceException(message);
                }
                ++i;
            } while (parent.getChild(childNodeName) != null);
            return childNodeName;
        }
        return name;
    }

    @Nonnull
    public static Resource unwrap(@Nonnull Resource rsrc) {
        Resource result = rsrc;
        while (result instanceof ResourceWrapper) {
            result = ((ResourceWrapper)result).getResource();
        }
        return result;
    }

    @Nonnull
    public static BatchResourceRemover getBatchResourceRemover(int threshold) {
        return new BatchResourceRemover(threshold);
    }

    public static class BatchResourceRemover {
        private final int max;
        private int count;

        public BatchResourceRemover(int batchSize) {
            this.max = batchSize < 1 ? 50 : batchSize;
        }

        public void delete(@Nonnull Resource rsrc) throws PersistenceException {
            ResourceResolver resolver = rsrc.getResourceResolver();
            for (Resource child : rsrc.getChildren()) {
                this.delete(child);
            }
            resolver.delete(rsrc);
            ++this.count;
            if (this.count >= this.max) {
                resolver.commit();
                this.count = 0;
            }
        }
    }
}

