/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.util.Hashtable;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements SynchronousBundleListener,
BundleActivator {
    private static String PACKAGE_ADMIN_NAME = PackageAdmin.class.getName();
    private ServiceTracker packageAdminTracker;
    private ServiceRegistration serviceReg;
    private DynamicClassLoaderManagerFactory service;
    private BundleContext bundleContext;

    public void start(BundleContext context) {
        this.bundleContext = context;
        this.packageAdminTracker = new ServiceTracker(this.bundleContext, PACKAGE_ADMIN_NAME, null);
        this.packageAdminTracker.open();
        this.registerManagerFactory();
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    protected void registerManagerFactory() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Apache Sling Dynamic Class Loader Service");
        props.put("service.vendor", "The Apache Software Foundation");
        this.service = new DynamicClassLoaderManagerFactory(this.bundleContext, (PackageAdmin)this.packageAdminTracker.getService());
        this.serviceReg = this.bundleContext.registerService(new String[]{DynamicClassLoaderManager.class.getName()}, (Object)this.service, props);
    }

    protected void unregisterManagerFactory() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
            this.serviceReg = null;
        }
        if (this.service != null) {
            this.service = null;
        }
    }

    public void stop(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
        this.unregisterManagerFactory();
        if (this.packageAdminTracker != null) {
            this.packageAdminTracker.close();
            this.packageAdminTracker = null;
        }
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        long bundleId = event.getBundle().getBundleId();
        boolean needsUpdate = this.service.isBundleUsed(bundleId);
        if (needsUpdate) {
            this.unregisterManagerFactory();
            this.registerManagerFactory();
        }
    }
}

