/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.classloader.DynamicClassLoaderProvider;
import org.apache.sling.commons.classloader.impl.ClassLoaderFacade;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerFactory;
import org.apache.sling.commons.classloader.impl.PackageAdminClassLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DynamicClassLoaderManagerImpl
extends ServiceTracker
implements DynamicClassLoaderManager,
ServiceTrackerCustomizer {
    private final PackageAdminClassLoader pckAdminCL;
    private final ClassLoaderFacade facade;
    private final BundleContext context;
    private ClassLoader[] cache;
    private boolean updateCache = false;
    private boolean active = true;

    public DynamicClassLoaderManagerImpl(BundleContext ctx, PackageAdmin pckAdmin, ClassLoader parent, DynamicClassLoaderManagerFactory factory) {
        super(ctx, DynamicClassLoaderProvider.class.getName(), null);
        this.context = ctx;
        this.pckAdminCL = new PackageAdminClassLoader(pckAdmin, parent, factory);
        this.cache = new ClassLoader[]{this.pckAdminCL};
        this.open();
        this.facade = new ClassLoaderFacade(this);
    }

    public Object addingService(ServiceReference reference) {
        this.updateCache = true;
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.updateCache = true;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
        this.updateCache = true;
    }

    private synchronized void updateCache() {
        if (this.updateCache) {
            ServiceReference[] refs = this.getServiceReferences();
            ClassLoader[] loaders = new ClassLoader[1 + refs.length];
            Arrays.sort(refs, ServiceReferenceComparator.INSTANCE);
            int index = 0;
            for (ServiceReference ref : refs) {
                DynamicClassLoaderProvider provider = (DynamicClassLoaderProvider)this.getService(ref);
                if (provider != null) {
                    loaders[index] = provider.getClassLoader(this.pckAdminCL);
                }
                ++index;
            }
            loaders[index] = this.pckAdminCL;
            this.cache = loaders;
            this.updateCache = false;
        }
    }

    public void deactivate() {
        this.active = false;
        this.close();
    }

    public boolean isActive() {
        return this.active;
    }

    public ClassLoader getDynamicClassLoader() {
        return this.facade;
    }

    public ClassLoader[] getDynamicClassLoaders() {
        if (this.updateCache) {
            this.updateCache();
        }
        return this.cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ServiceReferenceComparator
    implements Comparator<ServiceReference> {
        public static ServiceReferenceComparator INSTANCE = new ServiceReferenceComparator();

        protected ServiceReferenceComparator() {
        }

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            return o1.compareTo((Object)o2);
        }
    }
}

