/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.compiler.impl;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import org.apache.sling.commons.compiler.ClassWriter;
import org.apache.sling.commons.compiler.CompileUnit;
import org.apache.sling.commons.compiler.CompilerEnvironment;
import org.apache.sling.commons.compiler.ErrorHandler;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseJavaCompiler
implements JavaCompiler {
    private static final Logger log = LoggerFactory.getLogger(EclipseJavaCompiler.class);
    private static IProblemFactory PROBLEM_FACTORY = new DefaultProblemFactory(Locale.getDefault());

    public boolean compile(CompileUnit[] units, CompilerEnvironment env, ClassWriter classWriter, ErrorHandler errorHandler, Options options) {
        String sourceVersion;
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        PrintWriter logWriter = null;
        if (options == null) {
            options = new Options();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (options.isGenerateDebugInfo()) {
            props.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            props.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            props.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        }
        if ((sourceVersion = options.getSourceVersion()) != null) {
            props.put("org.eclipse.jdt.core.compiler.source", sourceVersion);
        }
        CompilerOptions settings = new CompilerOptions(props);
        CompileContext context = new CompileContext(units, env, errorHandler, classWriter);
        if (log.isDebugEnabled()) {
            log.debug(settings.toString());
        }
        Compiler compiler = new Compiler((INameEnvironment)context, policy, settings, (ICompilerRequestor)context, PROBLEM_FACTORY, logWriter);
        compiler.compile(context.sourceUnits());
        context.cleanup();
        return !context.hadErrors;
    }

    private class CompilationUnitAdapter
    implements ICompilationUnit {
        CompileUnit compUnit;
        char[][] packageName;

        CompilationUnitAdapter(CompileUnit compUnit) {
            this.compUnit = compUnit;
        }

        String extractPackageName(char[] contents) {
            BufferedReader reader = new BufferedReader(new CharArrayReader(contents));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("package")) continue;
                    line = line.substring("package".length());
                    line = line.substring(0, line.lastIndexOf(59));
                    return line.trim();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "";
        }

        public char[] getContents() {
            return this.compUnit.getSourceFileContents();
        }

        public char[] getMainTypeName() {
            return this.compUnit.getMainTypeName().toCharArray();
        }

        public char[][] getPackageName() {
            if (this.packageName == null) {
                String s = this.extractPackageName(this.compUnit.getSourceFileContents());
                this.packageName = CharOperation.splitOn((char)'.', (char[])s.toCharArray());
            }
            return this.packageName;
        }

        public char[] getFileName() {
            return this.compUnit.getSourceFileName().toCharArray();
        }
    }

    private class CompileContext
    implements ICompilerRequestor,
    INameEnvironment {
        boolean hadErrors;
        HashMap<String, ICompilationUnit> compUnits;
        ErrorHandler errorHandler;
        ClassWriter classWriter;
        CompilerEnvironment compEnv;

        CompileContext(CompileUnit[] units, CompilerEnvironment compEnv, ErrorHandler errorHandler, ClassWriter classWriter) {
            this.compUnits = new HashMap(units.length);
            for (int i = 0; i < units.length; ++i) {
                CompilationUnitAdapter cua = new CompilationUnitAdapter(units[i]);
                char[][] compoundName = CharOperation.arrayConcat((char[][])cua.getPackageName(), (char[])cua.getMainTypeName());
                this.compUnits.put(CharOperation.toString((char[][])compoundName), new CompilationUnitAdapter(units[i]));
            }
            this.compEnv = compEnv;
            this.errorHandler = errorHandler;
            this.classWriter = classWriter;
            this.hadErrors = false;
        }

        ICompilationUnit[] sourceUnits() {
            return this.compUnits.values().toArray(new ICompilationUnit[this.compUnits.size()]);
        }

        public void acceptResult(CompilationResult result) {
            int i;
            if (result.hasErrors()) {
                this.hadErrors = true;
            }
            if (result.hasProblems()) {
                CategorizedProblem[] problems = result.getProblems();
                for (i = 0; i < problems.length; ++i) {
                    CategorizedProblem problem = problems[i];
                    String msg = problem.getMessage();
                    String fileName = CharOperation.charToString((char[])problem.getOriginatingFileName());
                    int line = problem.getSourceLineNumber();
                    int pos = problem.getSourceStart();
                    if (problem.isError()) {
                        this.errorHandler.onError(msg, fileName, line, pos);
                        continue;
                    }
                    if (problem.isWarning()) {
                        this.errorHandler.onWarning(msg, fileName, line, pos);
                        continue;
                    }
                    log.debug("unknown problem category: " + problem.toString());
                }
            }
            ClassFile[] classFiles = result.getClassFiles();
            for (i = 0; i < classFiles.length; ++i) {
                ClassFile classFile = classFiles[i];
                String className = CharOperation.toString((char[][])classFile.getCompoundName());
                try {
                    this.classWriter.write(className, classFile.getBytes());
                    continue;
                }
                catch (Exception e) {
                    log.error("failed to persist class " + className, (Throwable)e);
                }
            }
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            String fqn = CharOperation.toString((char[][])compoundTypeName);
            ICompilationUnit cu = this.compUnits.get(fqn);
            if (cu != null) {
                return new NameEnvironmentAnswer(cu, null);
            }
            try {
                byte[] bytes = this.compEnv.findClass(CharOperation.toString((char[][])compoundTypeName));
                if (bytes == null) {
                    return null;
                }
                ClassFileReader classFileReader = new ClassFileReader(bytes, fqn.toCharArray(), true);
                return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
            }
            catch (Exception e) {
                return null;
            }
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            return this.findType(CharOperation.arrayConcat((char[][])packageName, (char[])typeName));
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            String fqn = CharOperation.toString((char[][])CharOperation.arrayConcat((char[][])parentPackageName, (char[])packageName));
            return this.compUnits.get(fqn) == null && this.compEnv.isPackage(fqn);
        }

        public void cleanup() {
            this.compEnv.cleanup();
        }
    }
}

