/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.commons.log.logback.internal.util.SlingContextUtil;
import org.apache.sling.commons.log.logback.internal.util.SlingRollingFileAppender;

public class LogWriter {
    public static final String FILE_NAME_CONSOLE = "CONSOLE";
    private static final long FACTOR_KB = 1024L;
    private static final long FACTOR_MB = 0x100000L;
    private static final long FACTOR_GB = 0x40000000L;
    private static final Pattern SIZE_SPEC = Pattern.compile("([\\d]+)([kmg]b?)?", 2);
    private final String configurationPID;
    private final String fileName;
    private final int logNumber;
    private final String logRotation;
    private final String appenderName;
    private final boolean bufferedLogging;

    public LogWriter(String configurationPID, String appenderName, int logNumber, String logRotation, String fileName, boolean bufferedLogging) {
        this.appenderName = appenderName;
        if (fileName == null || fileName.length() == 0) {
            fileName = FILE_NAME_CONSOLE;
        }
        if (logNumber < 0) {
            logNumber = 5;
        }
        if (logRotation == null || logRotation.length() == 0) {
            logRotation = "'.'yyyy-MM-dd";
        }
        this.configurationPID = configurationPID;
        this.fileName = fileName;
        this.logNumber = logNumber;
        this.logRotation = logRotation;
        this.bufferedLogging = bufferedLogging;
    }

    public LogWriter(String appenderName, String fileName, int logNumber, String logRotation) {
        this(null, appenderName, logNumber, logRotation, fileName, false);
    }

    public String getConfigurationPID() {
        return this.configurationPID;
    }

    public String getImplicitConfigPID() {
        return "org.apache.sling.commons.log.LogManager";
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAppenderName() {
        return this.appenderName;
    }

    public int getLogNumber() {
        return this.logNumber;
    }

    public String getLogRotation() {
        return this.logRotation;
    }

    public boolean isImplicit() {
        return this.configurationPID == null;
    }

    public Appender<ILoggingEvent> createAppender(Context context, Encoder<ILoggingEvent> encoder) {
        Object appender;
        SlingContextUtil ctxUtil = new SlingContextUtil(context, this);
        if (FILE_NAME_CONSOLE.equals(this.fileName)) {
            appender = new ConsoleAppender();
            appender.setName(FILE_NAME_CONSOLE);
        } else {
            ctxUtil.addInfo("Configuring appender " + this.getFileName());
            SlingRollingFileAppender rollingAppender = new SlingRollingFileAppender();
            rollingAppender.setAppend(true);
            rollingAppender.setFile(this.getFileName());
            Matcher sizeMatcher = SIZE_SPEC.matcher(this.getLogRotation());
            if (sizeMatcher.matches()) {
                long maxSize;
                long baseSize = Long.parseLong(sizeMatcher.group(1));
                String factorString = sizeMatcher.group(2);
                if (factorString == null) {
                    maxSize = baseSize;
                } else {
                    switch (factorString.charAt(0)) {
                        case 'K': 
                        case 'k': {
                            maxSize = baseSize * 1024L;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            maxSize = baseSize * 0x100000L;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            maxSize = baseSize * 0x40000000L;
                            break;
                        }
                        default: {
                            maxSize = baseSize;
                        }
                    }
                }
                SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
                triggeringPolicy.setMaxFileSize(String.valueOf(maxSize));
                triggeringPolicy.setContext(context);
                triggeringPolicy.start();
                rollingAppender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
                FixedWindowRollingPolicy pol = new FixedWindowRollingPolicy();
                pol.setMinIndex(1);
                pol.setMaxIndex(this.getLogNumber());
                pol.setFileNamePattern(this.getFileName() + "%i");
                pol.setContext(context);
                pol.setParent(rollingAppender);
                pol.start();
                rollingAppender.setRollingPolicy((RollingPolicy)pol);
            } else {
                TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
                String fileNamePattern = LogWriter.createFileNamePattern(this.getFileName(), this.getLogRotation());
                policy.setFileNamePattern(fileNamePattern);
                policy.setMaxHistory(this.getLogNumber());
                policy.setContext(context);
                policy.setParent(rollingAppender);
                policy.start();
                rollingAppender.setTriggeringPolicy((TriggeringPolicy)policy);
                ctxUtil.addInfo("Configured TimeBasedRollingPolicy with pattern " + fileNamePattern);
            }
            rollingAppender.setLogWriter(this);
            rollingAppender.setName(this.getAppenderName());
            appender = rollingAppender;
        }
        if (this.bufferedLogging && encoder instanceof LayoutWrappingEncoder) {
            ((LayoutWrappingEncoder)encoder).setImmediateFlush(false);
            ctxUtil.addInfo("Setting immediateFlush to false");
        } else {
            ctxUtil.addInfo("immediateFlush property not modified. Defaults to true");
        }
        appender.setContext(context);
        appender.setEncoder(encoder);
        appender.start();
        ctxUtil.addInfo("Completed configuring appender with name " + this.getFileName());
        return appender;
    }

    public static String createFileNamePattern(String fileName, String pattern) {
        if (pattern.startsWith("'.'")) {
            pattern = pattern.substring(3);
            pattern = ".%d{" + pattern + "}";
        }
        if (!pattern.contains("%d{")) {
            pattern = "%d{" + pattern + "}";
        }
        return fileName + pattern;
    }

    public String toString() {
        return "LogWriter{configurationPID='" + this.configurationPID + '\'' + ", fileName='" + this.fileName + '\'' + ", logNumber=" + this.logNumber + ", logRotation='" + this.logRotation + '\'' + '}';
    }
}

