/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.util;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.LogConfig;

public class LoggerSpecificEncoder
extends PatternLayoutEncoderBase<ILoggingEvent> {
    private Map<String, Layout<ILoggingEvent>> layoutByCategory = new ConcurrentHashMap<String, Layout<ILoggingEvent>>();
    private final Layout<ILoggingEvent> defaultLayout;

    public LoggerSpecificEncoder(Layout<ILoggingEvent> defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public byte[] encode(ILoggingEvent event) {
        String txt = this.getLayout(event.getLoggerName()).doLayout((Object)event);
        return this.convertToBytes(txt);
    }

    private Layout<ILoggingEvent> getLayout(String loggerName) {
        String bestMatchLayoutKey = this.getBestMatchLayoutKey(loggerName);
        return this.layoutByCategory.getOrDefault(bestMatchLayoutKey, this.defaultLayout);
    }

    private String getBestMatchLayoutKey(String loggerName) {
        if (this.layoutByCategory.containsKey(loggerName)) {
            return loggerName;
        }
        String bestMatch = loggerName;
        int bestMatchLength = 0;
        for (String layoutKey : this.layoutByCategory.keySet()) {
            if (!loggerName.startsWith(layoutKey) || loggerName.charAt(layoutKey.length()) != '.' || layoutKey.length() <= bestMatchLength) continue;
            bestMatch = layoutKey;
            bestMatchLength = layoutKey.length();
        }
        return bestMatch;
    }

    private byte[] convertToBytes(String s) {
        Charset charset = this.getCharset();
        if (charset == null) {
            return s.getBytes();
        }
        try {
            return s.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("An existing charset cannot possibly be unsupported.");
        }
    }

    public void addLogConfig(LogConfig config) {
        PatternLayout layout = config.createLayout();
        for (String category : config.getCategories()) {
            this.layoutByCategory.put(category, (Layout<ILoggingEvent>)layout);
        }
    }
}

