/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.sling.jcr.base.internal.Configuration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;

@Component(configurationPid={"org.apache.sling.jcr.base.internal.LoginAdminWhitelist.fragment"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={WhitelistFragment.class})
@Designate(ocd=Configuration.class, factory=true)
public class WhitelistFragment {
    private String name;
    private List<String> bundles;

    public WhitelistFragment() {
    }

    WhitelistFragment(String name, String[] bundles) {
        this.name = name;
        this.bundles = Arrays.asList(bundles);
    }

    @Activate
    void activate(Configuration config) {
        this.name = config.whitelist_name();
        this.bundles = Arrays.asList(config.whitelist_bundles() == null ? new String[]{} : config.whitelist_bundles());
    }

    boolean allows(String bsn) {
        return this.bundles.contains(bsn);
    }

    public String toString() {
        return this.name + ": " + this.bundles + "";
    }
}

