/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.util;

import java.util.Hashtable;
import javax.jcr.Repository;
import javax.naming.InitialContext;
import org.apache.jackrabbit.rmi.client.ClientAdapterFactory;
import org.apache.jackrabbit.rmi.client.ClientRepositoryFactory;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAccessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String RMI_PREFIX = "rmi://";
    public static final String JNDI_PREFIX = "jndi://";
    public static final String REPOSITORY_URL_OVERRIDE_PROPERTY = "sling.repository.url";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(String repositoryName, Hashtable<String, Object> jndiContext) {
        Repository result = null;
        String tried = "";
        if (jndiContext == null || jndiContext.size() == 0) {
            this.log.info("jndiContext is null or empty, not trying JNDI");
        } else {
            this.log.debug("Trying to acquire Repository '" + repositoryName + "' via JNDI, context=" + jndiContext);
            tried = tried + "JNDI ";
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                InitialContext initialContext = new InitialContext(jndiContext);
                Object repoObject = initialContext.lookup(repositoryName);
                if (repoObject instanceof Repository) {
                    result = (Repository)repoObject;
                    this.log.info("Acquired Repository '" + repositoryName + "' via JNDI");
                } else if (repoObject instanceof RemoteRepository) {
                    RemoteRepository remoteRepo = (RemoteRepository)repoObject;
                    LocalAdapterFactory laf = this.getLocalAdapterFactory();
                    result = laf.getRepository(remoteRepo);
                    this.log.info("Acquired RemoteRepository '" + repositoryName + "' via JNDI");
                } else {
                    this.log.info("Repository '" + repositoryName + "' acquired via JDNI " + "does not implement the required interfaces, class=" + repoObject.getClass().getName());
                }
            }
            catch (Throwable t) {
                this.log.info("Unable to acquire Repository '" + repositoryName + "' via JNDI, context=" + jndiContext, t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        if (result == null) {
            if (repositoryName == null || !repositoryName.startsWith(RMI_PREFIX)) {
                this.log.info("Repository name does not start with 'rmi://', not trying RMI");
            } else {
                try {
                    tried = tried + "RMI ";
                    this.log.debug("Trying to acquire Repository '" + repositoryName + "' via RMI");
                    ClientRepositoryFactory crf = this.getClientRepositoryFactory();
                    result = crf.getRepository(repositoryName);
                    this.log.info("Acquired Repository '" + repositoryName + "' via RMI");
                }
                catch (Throwable t) {
                    this.log.info("Unable to acquire Repository '" + repositoryName + "' via RMI", t);
                }
            }
        }
        if (result == null) {
            this.log.info("Unable to acquire Repository '" + repositoryName + "', tried " + tried);
        }
        return result;
    }

    public Repository getRepositoryFromURL(String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        if (url.startsWith(JNDI_PREFIX)) {
            String name = null;
            Hashtable<String, Object> jndiContext = new Hashtable<String, Object>();
            String urlNoPrefix = url.substring(JNDI_PREFIX.length());
            int colonPos = urlNoPrefix.indexOf(58);
            if (colonPos < 0) {
                name = urlNoPrefix;
            } else {
                name = urlNoPrefix.substring(0, colonPos);
                for (String entryStr : urlNoPrefix.substring(colonPos + 1).split(",")) {
                    String[] entry = entryStr.split("=");
                    if (entry.length != 2) continue;
                    jndiContext.put(entry[0], entry[1]);
                }
            }
            return this.getRepository(name, jndiContext);
        }
        return this.getRepository(url, null);
    }

    protected LocalAdapterFactory getLocalAdapterFactory() {
        return new ClientAdapterFactory();
    }

    protected ClientRepositoryFactory getClientRepositoryFactory() {
        return new ClientRepositoryFactory(this.getLocalAdapterFactory());
    }
}

