/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Commentable;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Section;

public class ModelReader {
    private CATEGORY mode = CATEGORY.NONE;
    private final Model model = new Model();
    private Feature feature;
    private RunMode runMode;
    private ArtifactGroup artifactGroup;
    private Configuration config;
    private Section additionalSection;
    private String comment;
    private StringBuilder configBuilder;
    private LineNumberReader lineNumberReader;
    private final String exceptionPrefix;

    public static Model read(Reader reader, String location) throws IOException {
        ModelReader mr = new ModelReader(location);
        return mr.readModel(reader);
    }

    private ModelReader(String location) {
        this.model.setLocation(location);
        this.exceptionPrefix = location == null ? "" : location + " : ";
    }

    private Model readModel(Reader reader) throws IOException {
        String line;
        boolean global = true;
        this.lineNumberReader = new LineNumberReader(reader);
        while ((line = this.lineNumberReader.readLine()) != null) {
            Map<Object, Object> parameters;
            if ((line = line.trim()).isEmpty()) {
                if (this.mode == CATEGORY.ADDITIONAL) {
                    if (this.additionalSection.getContents() == null) {
                        this.additionalSection.setContents(line);
                        continue;
                    }
                    this.additionalSection.setContents(this.additionalSection.getContents() + '\n' + line);
                    continue;
                }
                this.checkConfig();
                continue;
            }
            if (line.startsWith("#")) {
                if (this.config != null) {
                    this.configBuilder.append(line);
                    this.configBuilder.append('\n');
                    continue;
                }
                if (this.mode == CATEGORY.ADDITIONAL) {
                    if (this.additionalSection.getContents() == null) {
                        this.additionalSection.setContents(line);
                        continue;
                    }
                    this.additionalSection.setContents(this.additionalSection.getContents() + '\n' + line);
                    continue;
                }
                String c = line.substring(1).trim();
                if (this.comment == null) {
                    this.comment = c;
                    continue;
                }
                this.comment = this.comment + "\n" + c;
                continue;
            }
            if (global) {
                global = false;
                if (!line.startsWith("[feature ")) {
                    throw new IOException(this.exceptionPrefix + " Model file must start with a feature category.");
                }
            }
            if (line.startsWith("[")) {
                this.additionalSection = null;
                if (!line.endsWith("]")) {
                    throw new IOException(this.exceptionPrefix + "Illegal category definition in line " + this.lineNumberReader.getLineNumber() + ": " + line);
                }
                int pos = 1;
                while (line.charAt(pos) != ']' && !Character.isWhitespace(line.charAt(pos))) {
                    ++pos;
                }
                String category = line.substring(1, pos);
                CATEGORY found = null;
                for (CATEGORY c : CATEGORY.values()) {
                    if (!category.equals(c.name)) continue;
                    found = c;
                    break;
                }
                if (found == null) {
                    if (!category.startsWith(":")) {
                        throw new IOException(this.exceptionPrefix + "Unknown category in line " + this.lineNumberReader.getLineNumber() + ": " + category);
                    }
                    found = CATEGORY.ADDITIONAL;
                }
                this.mode = found;
                parameters = Collections.emptyMap();
                if (line.charAt(pos) != ']') {
                    String parameterLine = line.substring(pos + 1, line.length() - 1).trim();
                    parameters = this.parseParameters(parameterLine, this.mode.parameters);
                }
                switch (this.mode) {
                    case NONE: {
                        break;
                    }
                    case CONFIG: {
                        break;
                    }
                    case FEATURE: {
                        String name = (String)parameters.get("name");
                        if (name == null) {
                            throw new IOException(this.exceptionPrefix + "Feature name missing in line " + this.lineNumberReader.getLineNumber() + ": " + line);
                        }
                        if (this.model.getFeature(name) != null) {
                            throw new IOException(this.exceptionPrefix + "Duplicate feature in line " + this.lineNumberReader.getLineNumber() + ": " + line);
                        }
                        this.feature = this.model.getOrCreateFeature(name);
                        this.feature.setType((String)parameters.get("type"));
                        this.init(this.feature);
                        this.runMode = null;
                        this.artifactGroup = null;
                        break;
                    }
                    case VARIABLES: {
                        this.checkFeature();
                        this.init(this.feature.getVariables());
                        break;
                    }
                    case SETTINGS: {
                        this.checkFeature();
                        this.checkRunMode(parameters);
                        this.init(this.runMode.getSettings());
                        break;
                    }
                    case ARTIFACTS: {
                        this.checkFeature();
                        this.checkRunMode(parameters);
                        int startLevel = 0;
                        String level = (String)parameters.get("startLevel");
                        if (level != null) {
                            try {
                                startLevel = Integer.valueOf(level);
                            }
                            catch (NumberFormatException nfe) {
                                throw new IOException(this.exceptionPrefix + "Invalid start level in line " + this.lineNumberReader.getLineNumber() + ": " + line + ":" + level);
                            }
                        }
                        if (this.runMode.getArtifactGroup(startLevel) != null) {
                            throw new IOException(this.exceptionPrefix + "Duplicate artifact group in line " + this.lineNumberReader.getLineNumber() + ": " + line);
                        }
                        this.artifactGroup = this.runMode.getOrCreateArtifactGroup(startLevel);
                        this.init(this.artifactGroup);
                        break;
                    }
                    case CONFIGURATIONS: {
                        this.checkFeature();
                        this.checkRunMode(parameters);
                        this.init(this.runMode.getConfigurations());
                        break;
                    }
                    case ADDITIONAL: {
                        this.checkFeature();
                        this.runMode = null;
                        this.artifactGroup = null;
                        this.additionalSection = new Section(category.substring(1));
                        this.init(this.additionalSection);
                        this.feature.getAdditionalSections().add(this.additionalSection);
                        this.additionalSection.getAttributes().putAll(parameters);
                    }
                }
                continue;
            }
            switch (this.mode) {
                case NONE: {
                    break;
                }
                case VARIABLES: {
                    String[] vars = this.parseProperty(line);
                    this.feature.getVariables().put(vars[0], vars[1]);
                    break;
                }
                case SETTINGS: {
                    String[] settings = this.parseProperty(line);
                    this.runMode.getSettings().put(settings[0], settings[1]);
                    break;
                }
                case FEATURE: {
                    this.runMode = this.feature.getOrCreateRunMode(null);
                    this.artifactGroup = this.runMode.getOrCreateArtifactGroup(0);
                }
                case ARTIFACTS: {
                    int startPos;
                    String artifactUrl = line;
                    parameters = Collections.emptyMap();
                    if (line.endsWith("]") && (startPos = line.indexOf("[")) != -1) {
                        artifactUrl = line.substring(0, startPos).trim();
                        parameters = this.parseParameters(line.substring(startPos + 1, line.length() - 1).trim(), null);
                    }
                    try {
                        Artifact artifact = Artifact.fromMvnUrl("mvn:" + artifactUrl);
                        this.init(artifact);
                        this.artifactGroup.add(artifact);
                        artifact.getMetadata().putAll(parameters);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new IOException(this.exceptionPrefix + iae.getMessage() + " in line " + this.lineNumberReader.getLineNumber(), iae);
                    }
                }
                case CONFIGURATIONS: {
                    String factoryPid;
                    String pid;
                    int factoryPos;
                    String cfgMode;
                    String format;
                    int startPos;
                    String configId = line;
                    Map<Object, Object> cfgPars = Collections.emptyMap();
                    if (line.endsWith("]") && (startPos = line.indexOf("[")) != -1) {
                        configId = line.substring(0, startPos).trim();
                        cfgPars = this.parseParameters(line.substring(startPos + 1, line.length() - 1).trim(), new String[]{"format", "mode"});
                    }
                    if ((format = (String)cfgPars.get("format")) != null) {
                        if (!"felixca".equals(format) && !"properties".equals(format)) {
                            throw new IOException(this.exceptionPrefix + "Unknown format configuration parameter in line " + this.lineNumberReader.getLineNumber() + ": " + line);
                        }
                    } else {
                        format = "felixca";
                    }
                    if ((cfgMode = (String)cfgPars.get("mode")) != null) {
                        if (!"overwrite".equals(cfgMode) && !"merge".equals(cfgMode)) {
                            throw new IOException(this.exceptionPrefix + "Unknown mode configuration parameter in line " + this.lineNumberReader.getLineNumber() + ": " + line);
                        }
                    } else {
                        cfgMode = "overwrite";
                    }
                    if ((factoryPos = configId.indexOf(45)) == -1) {
                        pid = configId;
                        factoryPid = null;
                    } else {
                        pid = configId.substring(factoryPos + 1);
                        factoryPid = configId.substring(0, factoryPos);
                    }
                    if (this.runMode.getConfiguration(pid, factoryPid) != null) {
                        throw new IOException(this.exceptionPrefix + "Duplicate configuration in line " + this.lineNumberReader.getLineNumber());
                    }
                    this.config = this.runMode.getOrCreateConfiguration(pid, factoryPid);
                    this.init(this.config);
                    this.config.getProperties().put(":rawconfig.format", format);
                    this.config.getProperties().put(":rawconfig.mode", cfgMode);
                    this.configBuilder = new StringBuilder();
                    this.mode = CATEGORY.CONFIG;
                    break;
                }
                case CONFIG: {
                    this.configBuilder.append(line);
                    this.configBuilder.append('\n');
                    break;
                }
                case ADDITIONAL: {
                    if (this.additionalSection.getContents() == null) {
                        this.additionalSection.setContents(line);
                        break;
                    }
                    this.additionalSection.setContents(this.additionalSection.getContents() + '\n' + line);
                }
            }
        }
        this.checkConfig();
        if (this.comment != null) {
            throw new IOException(this.exceptionPrefix + "Comment not allowed at the end of file");
        }
        return this.model;
    }

    private void checkFeature() throws IOException {
        if (this.feature == null) {
            throw new IOException(this.exceptionPrefix + "No preceding feature definition in line " + this.lineNumberReader.getLineNumber());
        }
    }

    private void checkRunMode(Map<String, String> parameters) throws IOException {
        String[] runModes = null;
        String rmDef = parameters.get("runModes");
        if (rmDef != null) {
            runModes = rmDef.split(",");
            for (int i = 0; i < runModes.length; ++i) {
                runModes[i] = runModes[i].trim();
            }
        }
        this.runMode = this.feature.getOrCreateRunMode(runModes);
    }

    private void init(Commentable traceable) {
        traceable.setComment(this.comment);
        this.comment = null;
        String number = String.valueOf(this.lineNumberReader.getLineNumber());
        if (this.model.getLocation() != null) {
            traceable.setLocation(this.model.getLocation() + ":" + number);
        } else {
            traceable.setLocation(number);
        }
    }

    private void checkConfig() {
        if (this.config != null) {
            this.config.getProperties().put(":rawconfig", this.configBuilder.toString());
            this.mode = CATEGORY.CONFIGURATIONS;
        }
        this.config = null;
        this.configBuilder = null;
    }

    private String[] parseProperty(String line) throws IOException {
        int equalsPos = line.indexOf(61);
        String key = line.substring(0, equalsPos).trim();
        String value = line.substring(equalsPos + 1).trim();
        if (key.isEmpty() || value.isEmpty()) {
            throw new IOException(this.exceptionPrefix + "Invalid property; " + line + " in line " + this.lineNumberReader.getLineNumber());
        }
        return new String[]{key, value};
    }

    private Map<String, String> parseParameters(String line, String[] allowedParameters) throws IOException {
        String[] keyValuePairs;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String kv : keyValuePairs = line.split(" ")) {
            if ((kv = kv.trim()).isEmpty()) continue;
            int sep = kv.indexOf(61);
            if (sep == -1) {
                throw new IOException(this.exceptionPrefix + "Invalid parameter definition in line " + this.lineNumberReader.getLineNumber() + ": " + line);
            }
            String key = kv.substring(0, sep).trim();
            parameters.put(key, kv.substring(sep + 1).trim());
            if (allowedParameters == null) continue;
            boolean found = false;
            for (String allowed : allowedParameters) {
                if (!key.equals(allowed)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IOException(this.exceptionPrefix + "Invalid parameter " + key + " in line " + this.lineNumberReader.getLineNumber());
        }
        return parameters;
    }

    private static enum CATEGORY {
        NONE(null, null),
        FEATURE("feature", new String[]{"name", "type"}),
        VARIABLES("variables", null),
        ARTIFACTS("artifacts", new String[]{"runModes", "startLevel"}),
        SETTINGS("settings", new String[]{"runModes"}),
        CONFIGURATIONS("configurations", new String[]{"runModes"}),
        CONFIG(null, null),
        ADDITIONAL(null, null);

        public final String name;
        public final String[] parameters;

        private CATEGORY(String n2, String[] p) {
            this.name = n2;
            this.parameters = p;
        }
    }
}

