/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceResolverFactoryImpl
implements ResourceResolverFactory {
    private final CommonResourceResolverFactoryImpl commonFactory;
    private final ServiceUserMapper serviceUserMapper;
    private final Bundle usingBundle;

    public ResourceResolverFactoryImpl(CommonResourceResolverFactoryImpl commonFactory, Bundle usingBundle, ServiceUserMapper serviceUserMapper) {
        this.commonFactory = commonFactory;
        this.serviceUserMapper = serviceUserMapper;
        this.usingBundle = usingBundle;
    }

    public ResourceResolver getServiceResourceResolver(Map<String, Object> passedAuthenticationInfo) throws LoginException {
        String subServiceName;
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        if (passedAuthenticationInfo != null) {
            authenticationInfo.putAll(passedAuthenticationInfo);
            authenticationInfo.remove("user.password");
            Object info = passedAuthenticationInfo.get("sling.service.subservice");
            subServiceName = info instanceof String ? (String)info : null;
        } else {
            subServiceName = null;
        }
        String userName = this.serviceUserMapper.getServiceUserID(this.usingBundle, subServiceName);
        if (userName == null) {
            throw new LoginException("Cannot derive user name for bundle " + this.usingBundle + " and sub service " + subServiceName);
        }
        authenticationInfo.put("user.name", userName);
        authenticationInfo.put("sling.service.bundle", this.usingBundle);
        return this.commonFactory.getResourceResolverInternal(authenticationInfo, false);
    }

    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.commonFactory.getResourceResolver(authenticationInfo);
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.commonFactory.getAdministrativeResourceResolver(authenticationInfo);
    }

    public ResourceResolver getThreadResourceResolver() {
        return this.commonFactory.getThreadResourceResolver();
    }
}

