/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.security.AccessSecurityException;
import org.apache.sling.api.security.ResourceAccessSecurity;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderHandler
implements Comparable<ProviderHandler> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Object> properties;
    private final Long serviceId;
    private final String[] roots;
    private final Set<String> queryLanguages;
    private final boolean ownsRoots;
    private final boolean useResourceAccessSecurity;

    public ProviderHandler(Map<String, Object> properties) {
        this.properties = properties;
        this.serviceId = (Long)properties.get("service.id");
        ArrayList<String> configuredRoots = new ArrayList<String>();
        String[] paths = PropertiesUtil.toStringArray((Object)properties.get("provider.roots"));
        if (paths != null) {
            for (String r : paths) {
                if (r == null) continue;
                String path = r.trim();
                if (path.endsWith("/") && path.length() > 1) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.length() <= 0 || configuredRoots.contains(path)) continue;
                configuredRoots.add(path);
            }
        }
        if (configuredRoots.size() == 0) {
            this.roots = null;
        } else {
            Collections.sort(configuredRoots);
            this.roots = configuredRoots.toArray(new String[configuredRoots.size()]);
        }
        this.ownsRoots = PropertiesUtil.toBoolean((Object)properties.get("provider.ownsRoots"), (boolean)false);
        this.useResourceAccessSecurity = PropertiesUtil.toBoolean((Object)properties.get("provider.useResourceAccessSecurity"), (boolean)false);
        HashSet<String> configuredLanguages = new HashSet<String>();
        String[] languages = PropertiesUtil.toStringArray((Object)properties.get("provider.query.languages"));
        if (languages != null) {
            for (String l : languages) {
                String language;
                if (l == null || (language = l.trim()).length() <= 0) continue;
                configuredLanguages.add(language);
            }
        }
        this.queryLanguages = configuredLanguages.size() == 0 ? null : configuredLanguages;
    }

    public boolean canCreate(ResourceResolverContext ctx, ResourceResolver resolver, String path) {
        ResourceAccessSecurity security;
        ResourceAccessSecurityTracker tracker = ctx.getResourceAccessSecurityTracker();
        boolean allowed = true;
        if (this.useResourceAccessSecurity) {
            security = tracker.getProviderResourceAccessSecurity();
            allowed = security != null ? security.canCreate(path, resolver) : false;
        }
        if (allowed && (security = tracker.getApplicationResourceAccessSecurity()) != null) {
            allowed = security.canCreate(path, resolver);
        }
        return allowed;
    }

    public boolean canDelete(ResourceResolverContext ctx, Resource resource) {
        ResourceAccessSecurity security;
        ResourceAccessSecurityTracker tracker = ctx.getResourceAccessSecurityTracker();
        boolean allowed = true;
        if (this.useResourceAccessSecurity) {
            security = tracker.getProviderResourceAccessSecurity();
            allowed = security != null ? security.canDelete(resource) : false;
        }
        if (allowed && (security = tracker.getApplicationResourceAccessSecurity()) != null) {
            allowed = security.canDelete(resource);
        }
        return allowed;
    }

    protected Resource getReadableResource(ResourceResolverContext ctx, Resource resource) {
        ResourceAccessSecurity resourceAccessSecurity;
        ResourceAccessSecurityTracker tracker = ctx.getResourceAccessSecurityTracker();
        Resource returnValue = null;
        if (this.useResourceAccessSecurity && resource != null) {
            resourceAccessSecurity = tracker.getProviderResourceAccessSecurity();
            if (resourceAccessSecurity != null) {
                returnValue = resourceAccessSecurity.getReadableResource(resource);
            }
        } else {
            returnValue = resource;
        }
        if (returnValue != null && (resourceAccessSecurity = tracker.getApplicationResourceAccessSecurity()) != null) {
            returnValue = resourceAccessSecurity.getReadableResource(returnValue);
        }
        return returnValue;
    }

    protected String transformQuery(ResourceResolverContext ctx, ResourceResolver resolver, String query, String language) {
        ResourceAccessSecurity resourceAccessSecurity;
        ResourceAccessSecurityTracker tracker = ctx.getResourceAccessSecurityTracker();
        String returnValue = query;
        if (this.useResourceAccessSecurity && (resourceAccessSecurity = tracker.getProviderResourceAccessSecurity()) != null) {
            try {
                returnValue = resourceAccessSecurity.transformQuery(returnValue, language, resolver);
            }
            catch (AccessSecurityException e) {
                this.logger.error("AccessSecurityException occurred while trying to transform the query {} (language {}).", (Object)new Object[]{query, language}, (Object)e);
            }
        }
        if ((resourceAccessSecurity = tracker.getApplicationResourceAccessSecurity()) != null) {
            try {
                returnValue = resourceAccessSecurity.transformQuery(returnValue, language, resolver);
            }
            catch (AccessSecurityException e) {
                this.logger.error("AccessSecurityException occurred while trying to transform the query {} (language {}).", (Object)new Object[]{query, language}, (Object)e);
            }
        }
        return returnValue;
    }

    protected Iterator<Resource> getReadableChildrenIterator(final ResourceResolverContext ctx, final Iterator<Resource> childrenIterator) {
        Iterator<Resource> returnValue = null;
        if (childrenIterator != null) {
            returnValue = new Iterator<Resource>(){
                private Resource nextResource;
                {
                    this.seek();
                }

                private void seek() {
                    while (this.nextResource == null && childrenIterator.hasNext()) {
                        this.nextResource = ProviderHandler.this.getReadableResource(ctx, (Resource)childrenIterator.next());
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.nextResource != null;
                }

                @Override
                public Resource next() {
                    if (this.nextResource == null) {
                        throw new NoSuchElementException();
                    }
                    Resource result = this.nextResource;
                    this.nextResource = null;
                    this.seek();
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return returnValue;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public boolean ownsRoots() {
        return this.ownsRoots;
    }

    public String[] getRoots() {
        return this.roots;
    }

    public boolean supportsQueryLanguages(String language) {
        return this.queryLanguages != null && this.queryLanguages.contains(language);
    }

    @Override
    public int compareTo(ProviderHandler other) {
        Integer otherRank;
        if (this.serviceId.equals(other.serviceId)) {
            return 0;
        }
        Object rankObj = this.getProperties().get("service.ranking");
        Object otherRankObj = other.getProperties().get("service.ranking");
        rankObj = rankObj == null ? new Integer(0) : rankObj;
        otherRankObj = otherRankObj == null ? new Integer(0) : otherRankObj;
        Integer rank = rankObj instanceof Integer ? (Integer)rankObj : new Integer(0);
        Integer n = otherRank = otherRankObj instanceof Integer ? (Integer)otherRankObj : new Integer(0);
        if (rank.compareTo(otherRank) < 0) {
            return -1;
        }
        if (rank.compareTo(otherRank) > 0) {
            return 1;
        }
        return this.serviceId.compareTo(other.serviceId) < 0 ? 1 : -1;
    }

    public abstract Resource getResource(ResourceResolverContext var1, ResourceResolver var2, String var3);

    public abstract Iterator<Resource> listChildren(ResourceResolverContext var1, Resource var2);

    public abstract ResourceProvider getResourceProvider(ResourceResolverContext var1);

    public String getName() {
        StringBuilder snBuilder = new StringBuilder(64);
        snBuilder.append('{');
        snBuilder.append(this.toString());
        snBuilder.append('/');
        snBuilder.append(this.serviceId.toString());
        snBuilder.append('}');
        return snBuilder.toString();
    }
}

