/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resource.path.PathBuilder;
import org.apache.sling.resourceresolver.impl.helper.ChainedIterator;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.helper.UniqueResourceIterator;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderStorage;
import org.apache.sling.resourceresolver.impl.providers.stateful.AuthenticatedResourceProvider;
import org.apache.sling.resourceresolver.impl.providers.tree.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolverControl {
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolverControl.class);
    private static final String FORBIDDEN_ATTRIBUTE = "user.password";
    private final boolean isAdmin;
    private final Map<String, Object> authenticationInfo;
    private volatile ResourceResolver resourceTypeResourceResolver;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ResourceProviderStorage storage;
    private final Map<ResourceProviderHandler, Object> authenticatedProviders = new IdentityHashMap<ResourceProviderHandler, Object>();

    public ResourceResolverControl(boolean isAdmin, Map<String, Object> authenticationInfo, ResourceProviderStorage storage) {
        this.authenticationInfo = authenticationInfo;
        this.isAdmin = isAdmin;
        this.storage = storage;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public Map<String, Object> getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    private void logout() {
        for (Map.Entry<ResourceProviderHandler, Object> entry : this.authenticatedProviders.entrySet()) {
            entry.getKey().getResourceProvider().logout(entry.getValue());
        }
        this.authenticatedProviders.clear();
    }

    public void refresh(@Nonnull ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedRefreshable()) {
            p.refresh();
        }
    }

    public boolean isLive(@Nonnull ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllAuthenticated()) {
            if (p.isLive()) continue;
            return false;
        }
        return true;
    }

    public Resource getParent(ResourceResolverContext context, Resource child) {
        Resource parentCandidate;
        String path = child.getPath();
        AuthenticatedResourceProvider provider = this.getBestMatchingProvider(context, path);
        if (provider != null && (parentCandidate = provider.getParent(child)) != null) {
            return parentCandidate;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath != null && this.isIntermediatePath(parentPath)) {
            return new SyntheticResource(context.getResourceResolver(), parentPath, "sling:syntheticResourceProviderResource");
        }
        return null;
    }

    public Resource getResource(ResourceResolverContext context, String path, Resource parent, Map<String, String> parameters, boolean isResolve) {
        Resource resourceCandidate;
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            logger.debug("Not absolute {}", (Object)path);
            return null;
        }
        AuthenticatedResourceProvider provider = this.getBestMatchingProvider(context, path);
        if (provider != null && (resourceCandidate = provider.getResource(path, parent, parameters)) != null) {
            return resourceCandidate;
        }
        if (!isResolve && this.isIntermediatePath(path)) {
            logger.debug("Resolved Synthetic {}", (Object)path);
            return new SyntheticResource(context.getResourceResolver(), path, "sling:syntheticResourceProviderResource");
        }
        logger.debug("Resource null {} ", (Object)path);
        return null;
    }

    private boolean isIntermediatePath(String fullPath) {
        return this.storage.getTree().getNode(fullPath) != null;
    }

    public Iterator<Resource> listChildren(ResourceResolverContext context, Resource parent) {
        Node<ResourceProviderHandler> node;
        String parentPath = parent.getPath();
        Iterator<Resource> realChildren = null;
        AuthenticatedResourceProvider provider = this.getBestMatchingProvider(context, parentPath);
        if (provider != null) {
            realChildren = provider.listChildren(parent);
        }
        HashSet<String> visitedNames = new HashSet<String>();
        IteratorChain chain = new IteratorChain();
        if (realChildren != null) {
            chain.addIterator(realChildren);
        }
        if ((node = this.storage.getTree().getNode(parent.getPath())) != null) {
            ArrayList<SyntheticResource> syntheticList = new ArrayList<SyntheticResource>();
            ArrayList<Resource> providerList = new ArrayList<Resource>();
            for (Map.Entry<String, Node<ResourceProviderHandler>> entry : node.getChildren().entrySet()) {
                String name = entry.getKey();
                ResourceProviderHandler handler = entry.getValue().getValue();
                PathBuilder pathBuilder = new PathBuilder(parent.getPath());
                pathBuilder.append(name);
                String childPath = pathBuilder.toString();
                if (handler == null) {
                    syntheticList.add(new SyntheticResource(context.getResourceResolver(), childPath, "sling:syntheticResourceProviderResource"));
                    continue;
                }
                Resource rsrc = null;
                try {
                    AuthenticatedResourceProvider rp = context.getProviderManager().getOrCreateProvider(handler, this);
                    rsrc = rp == null ? null : rp.getResource(childPath, parent, null);
                }
                catch (LoginException ignore) {
                    // empty catch block
                }
                if (rsrc != null) {
                    providerList.add(rsrc);
                    continue;
                }
                if (entry.getValue().getChildren().isEmpty()) {
                    syntheticList.add(new SyntheticResource(context.getResourceResolver(), childPath, "sling:syntheticResourceProviderResource"));
                    continue;
                }
                visitedNames.add(name);
            }
            if (!providerList.isEmpty()) {
                chain.addIterator(providerList.iterator());
            }
            if (!syntheticList.isEmpty()) {
                chain.addIterator(syntheticList.iterator());
            }
        }
        if (chain.size() == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new UniqueResourceIterator(visitedNames, (Iterator<Resource>)chain);
    }

    public Collection<String> getAttributeNames(ResourceResolverContext context) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.storage.getAttributableHandlers(), this)) {
            p.getAttributeNames(names);
        }
        if (this.authenticationInfo != null) {
            names.addAll(this.authenticationInfo.keySet());
        }
        names.remove(FORBIDDEN_ATTRIBUTE);
        return names;
    }

    public Object getAttribute(ResourceResolverContext context, String name) {
        if (FORBIDDEN_ATTRIBUTE.equals(name)) {
            return null;
        }
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.storage.getAttributableHandlers(), this)) {
            Object attribute = p.getAttribute(name);
            if (attribute == null) continue;
            return attribute;
        }
        return this.authenticationInfo != null ? this.authenticationInfo.get(name) : null;
    }

    public Resource create(ResourceResolverContext context, String path, Map<String, Object> properties) throws PersistenceException {
        Resource creationResultResource;
        AuthenticatedResourceProvider provider = this.getBestMatchingModifiableProvider(context, path);
        if (provider != null && (creationResultResource = provider.create(context.getResourceResolver(), path, properties)) != null) {
            return creationResultResource;
        }
        throw new UnsupportedOperationException("create '" + ResourceUtil.getName((String)path) + "' at " + ResourceUtil.getParent((String)path));
    }

    public void delete(ResourceResolverContext context, Resource resource) throws PersistenceException {
        String path = resource.getPath();
        AuthenticatedResourceProvider provider = this.getBestMatchingModifiableProvider(context, path);
        if (provider != null) {
            provider.delete(resource);
            return;
        }
        throw new UnsupportedOperationException("delete at '" + path + "'");
    }

    public void revert(ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedModifiable()) {
            p.revert();
        }
    }

    public void commit(ResourceResolverContext context) throws PersistenceException {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedModifiable()) {
            p.commit();
        }
    }

    public boolean hasChanges(ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedModifiable()) {
            if (!p.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedLanguages(ResourceResolverContext context) {
        LinkedHashSet<String> supportedLanguages = new LinkedHashSet<String>();
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.storage.getLanguageQueryableHandlers(), this)) {
            supportedLanguages.addAll(Arrays.asList(p.getSupportedLanguages()));
        }
        return supportedLanguages.toArray(new String[supportedLanguages.size()]);
    }

    public Iterator<Resource> findResources(ResourceResolverContext context, String query, String language) {
        List<AuthenticatedResourceProvider> queryableRP = this.getQueryableProviders(context, language);
        ArrayList<Iterator<Resource>> iterators = new ArrayList<Iterator<Resource>>(queryableRP.size());
        for (AuthenticatedResourceProvider p : queryableRP) {
            iterators.add(p.findResources(query, language));
        }
        return new ChainedIterator<Resource>(iterators.iterator());
    }

    private List<AuthenticatedResourceProvider> getQueryableProviders(ResourceResolverContext context, String language) {
        ArrayList<AuthenticatedResourceProvider> queryableProviders = new ArrayList<AuthenticatedResourceProvider>();
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.storage.getLanguageQueryableHandlers(), this)) {
            if (!ArrayUtils.contains((Object[])p.getSupportedLanguages(), (Object)language)) continue;
            queryableProviders.add(p);
        }
        return queryableProviders;
    }

    public Iterator<Map<String, Object>> queryResources(ResourceResolverContext context, String query, String language) {
        List<AuthenticatedResourceProvider> queryableRP = this.getQueryableProviders(context, language);
        ArrayList<Iterator<Map<String, Object>>> iterators = new ArrayList<Iterator<Map<String, Object>>>(queryableRP.size());
        for (AuthenticatedResourceProvider p : queryableRP) {
            iterators.add(p.queryResources(query, language));
        }
        return new ChainedIterator<Map<String, Object>>(iterators.iterator());
    }

    public <AdapterType> AdapterType adaptTo(ResourceResolverContext context, Class<AdapterType> type) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.storage.getAdaptableHandlers(), this)) {
            AdapterType adaptee = p.adaptTo(type);
            if (adaptee == null) continue;
            return adaptee;
        }
        return null;
    }

    private AuthenticatedResourceProvider checkSourceAndDest(ResourceResolverContext context, String srcAbsPath, String destAbsPath) throws PersistenceException {
        Node<ResourceProviderHandler> srcNode = this.storage.getTree().getBestMatchingNode(srcAbsPath);
        if (srcNode == null) {
            throw new PersistenceException("Source resource does not exist.", null, srcAbsPath, null);
        }
        AuthenticatedResourceProvider srcProvider = null;
        try {
            srcProvider = context.getProviderManager().getOrCreateProvider(srcNode.getValue(), this);
        }
        catch (LoginException e) {
            // empty catch block
        }
        if (srcProvider == null) {
            throw new PersistenceException("Source resource does not exist.", null, srcAbsPath, null);
        }
        Resource srcResource = srcProvider.getResource(srcAbsPath, null, null);
        if (srcResource == null) {
            throw new PersistenceException("Source resource does not exist.", null, srcAbsPath, null);
        }
        Node<ResourceProviderHandler> destNode = this.storage.getTree().getBestMatchingNode(destAbsPath);
        if (destNode == null) {
            throw new PersistenceException("Destination resource does not exist.", null, destAbsPath, null);
        }
        AuthenticatedResourceProvider destProvider = null;
        try {
            destProvider = context.getProviderManager().getOrCreateProvider(destNode.getValue(), this);
        }
        catch (LoginException e) {
            // empty catch block
        }
        if (destProvider == null) {
            throw new PersistenceException("Destination resource does not exist.", null, destAbsPath, null);
        }
        Resource destResource = destProvider.getResource(destAbsPath, null, null);
        if (destResource == null) {
            throw new PersistenceException("Destination resource does not exist.", null, destAbsPath, null);
        }
        if (srcProvider == destProvider && !this.collectProviders(context, srcNode) && !this.collectProviders(context, destNode)) {
            return srcProvider;
        }
        return null;
    }

    private boolean collectProviders(ResourceResolverContext context, Node<ResourceProviderHandler> parent) {
        boolean hasMoreProviders = false;
        for (Map.Entry<String, Node<ResourceProviderHandler>> entry : parent.getChildren().entrySet()) {
            if (entry.getValue().getValue() != null) {
                try {
                    context.getProviderManager().getOrCreateProvider(entry.getValue().getValue(), this);
                    hasMoreProviders = true;
                }
                catch (LoginException ignore) {
                    // empty catch block
                }
            }
            if (!this.collectProviders(context, entry.getValue())) continue;
            hasMoreProviders = true;
        }
        return hasMoreProviders;
    }

    private void copy(ResourceResolverContext context, Resource src, String dstPath, List<Resource> newNodes) throws PersistenceException {
        ValueMap vm = src.getValueMap();
        String createPath = new PathBuilder(dstPath).append(src.getName()).toString();
        newNodes.add(this.create(context, createPath, (Map<String, Object>)vm));
        for (Resource c : src.getChildren()) {
            this.copy(context, c, createPath, newNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource copy(ResourceResolverContext context, String srcAbsPath, String destAbsPath) throws PersistenceException {
        AuthenticatedResourceProvider optimizedSourceProvider = this.checkSourceAndDest(context, srcAbsPath, destAbsPath);
        if (optimizedSourceProvider != null && optimizedSourceProvider.copy(srcAbsPath, destAbsPath)) {
            return this.getResource(context, destAbsPath + '/' + ResourceUtil.getName((String)srcAbsPath), null, null, false);
        }
        Resource srcResource = this.getResource(context, srcAbsPath, null, null, false);
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        boolean rollback = true;
        try {
            this.copy(context, srcResource, destAbsPath, newResources);
            rollback = false;
            Resource resource = (Resource)newResources.get(0);
            return resource;
        }
        finally {
            if (rollback) {
                for (Resource rsrc : newResources) {
                    this.delete(context, rsrc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource move(ResourceResolverContext context, String srcAbsPath, String destAbsPath) throws PersistenceException {
        AuthenticatedResourceProvider optimizedSourceProvider = this.checkSourceAndDest(context, srcAbsPath, destAbsPath);
        if (optimizedSourceProvider != null && optimizedSourceProvider.move(srcAbsPath, destAbsPath)) {
            return this.getResource(context, destAbsPath + '/' + ResourceUtil.getName((String)srcAbsPath), null, null, false);
        }
        Resource srcResource = this.getResource(context, srcAbsPath, null, null, false);
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        boolean rollback = true;
        try {
            this.copy(context, srcResource, destAbsPath, newResources);
            this.delete(context, srcResource);
            rollback = false;
            Resource resource = (Resource)newResources.get(0);
            return resource;
        }
        finally {
            if (rollback) {
                for (Resource rsrc : newResources) {
                    this.delete(context, rsrc);
                }
            }
        }
    }

    public ResourceProviderStorage getResourceProviderStorage() {
        return this.storage;
    }

    @CheckForNull
    private AuthenticatedResourceProvider getBestMatchingProvider(ResourceResolverContext context, String path) {
        try {
            Node<ResourceProviderHandler> node = this.storage.getTree().getBestMatchingNode(path);
            return node == null ? null : context.getProviderManager().getOrCreateProvider(node.getValue(), this);
        }
        catch (LoginException le) {
            return null;
        }
    }

    @CheckForNull
    private AuthenticatedResourceProvider getBestMatchingModifiableProvider(ResourceResolverContext context, String path) {
        Node<ResourceProviderHandler> node = this.storage.getTree().getBestMatchingNode(path);
        if (node != null && node.getValue().getInfo().isModifiable()) {
            try {
                return context.getProviderManager().getOrCreateProvider(node.getValue(), this);
            }
            catch (LoginException le) {
                return null;
            }
        }
        return null;
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.logout();
            if (this.resourceTypeResourceResolver != null) {
                try {
                    this.resourceTypeResourceResolver.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.resourceTypeResourceResolver = null;
            }
        }
    }

    private ResourceResolver getResourceTypeResourceResolver(ResourceResolverFactory factory, ResourceResolver resolver) {
        if (this.isAdmin) {
            return resolver;
        }
        if (this.resourceTypeResourceResolver == null) {
            try {
                this.resourceTypeResourceResolver = factory.getAdministrativeResourceResolver(null);
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        return this.resourceTypeResourceResolver;
    }

    public String getParentResourceType(ResourceResolverFactory factory, ResourceResolver resolver, String resourceType) {
        Resource rtResource;
        ResourceResolver adminResolver;
        String rtPath = resourceType == null ? null : ResourceUtil.resourceTypeToPath((String)resourceType);
        String resourceSuperType = null;
        if (rtPath != null && (adminResolver = this.getResourceTypeResourceResolver(factory, resolver)) != null && (rtResource = adminResolver.getResource(rtPath)) != null) {
            resourceSuperType = rtResource.getResourceSuperType();
        }
        return resourceSuperType;
    }

    public static String getProperty(Resource res, String propName) {
        return ResourceResolverControl.getProperty(res, propName, String.class);
    }

    public static <Type> Type getProperty(Resource res, String propName, Class<Type> type) {
        ValueMap props = (ValueMap)res.adaptTo(ValueMap.class);
        if (props != null) {
            Object prop = props.get(propName, type);
            if (prop != null) {
                return (Type)prop;
            }
            prop = props.get("jcr:content/" + propName, type);
            return (Type)prop;
        }
        return null;
    }

    public void registerAuthenticatedProvider(@Nonnull ResourceProviderHandler handler, @CheckForNull Object providerState) {
        this.authenticatedProviders.put(handler, providerState);
    }

    public void clearAuthenticatedProviders() {
        this.authenticatedProviders.clear();
    }
}

