/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.util.Path;
import org.apache.sling.api.resource.util.PathSet;
import org.apache.sling.resourceresolver.impl.observation.BasicObserverConfiguration;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListenerInfo;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;

public class BasicObservationReporter
implements ObservationReporter {
    private final List<ObserverConfiguration> configs;
    private final Map<ListenerConfig, List<ResourceChangeListenerInfo>> listeners = new HashMap<ListenerConfig, List<ResourceChangeListenerInfo>>();

    public BasicObservationReporter(Collection<ResourceChangeListenerInfo> infos) {
        HashSet<String> paths = new HashSet<String>();
        for (ResourceChangeListenerInfo info : infos) {
            if (info.getProviderChangeTypes().isEmpty()) continue;
            for (Path p : info.getPaths()) {
                paths.add(p.getPath());
            }
            this.fillListeners(info, info.getResourceChangeTypes());
        }
        BasicObserverConfiguration cfg = new BasicObserverConfiguration(PathSet.fromStringCollection(paths));
        this.configs = Collections.singletonList(cfg);
    }

    public BasicObservationReporter(Collection<ResourceChangeListenerInfo> infos, Path providerPath, PathSet excludePaths) {
        HashMap<String, ObserverConfig> configMap = new HashMap<String, ObserverConfig>();
        for (ResourceChangeListenerInfo info : infos) {
            if (info.getResourceChangeTypes().isEmpty()) continue;
            boolean add = false;
            for (Path p : info.getPaths()) {
                if (!providerPath.matches(p.getPath()) || excludePaths.matches(p.getPath()) != null) continue;
                ObserverConfig config = (ObserverConfig)configMap.get(p);
                if (config == null) {
                    config = new ObserverConfig();
                    configMap.put(p.getPath(), config);
                }
                config.types.addAll(info.getResourceChangeTypes());
                if (info.isExternal()) {
                    config.isExternal = true;
                }
                add = true;
            }
            if (!add) continue;
            this.fillListeners(info, info.getResourceChangeTypes());
        }
        ArrayList<BasicObserverConfiguration> result = new ArrayList<BasicObserverConfiguration>();
        for (Map.Entry entry : configMap.entrySet()) {
            BasicObserverConfiguration cfg = new BasicObserverConfiguration((String)entry.getKey(), ((ObserverConfig)entry.getValue()).types, ((ObserverConfig)entry.getValue()).isExternal, excludePaths);
            result.add(cfg);
        }
        this.configs = Collections.unmodifiableList(result);
    }

    private void fillListeners(ResourceChangeListenerInfo info, Set<ResourceChange.ChangeType> types) {
        ListenerConfig cfg = new ListenerConfig(info, types);
        List<ResourceChangeListenerInfo> list = this.listeners.get(cfg);
        if (list == null) {
            list = new ArrayList<ResourceChangeListenerInfo>();
            this.listeners.put(cfg, list);
        }
        list.add(info);
    }

    public List<ObserverConfiguration> getObserverConfigurations() {
        return this.configs;
    }

    public void reportChanges(Iterable<ResourceChange> changes, boolean distribute) {
        for (Map.Entry<ListenerConfig, List<ResourceChangeListenerInfo>> entry : this.listeners.entrySet()) {
            List<ResourceChange> filtered = this.filterChanges(changes, entry.getKey());
            if (filtered.isEmpty()) continue;
            for (ResourceChangeListenerInfo info : entry.getValue()) {
                info.getListener().onChange(filtered);
            }
        }
    }

    private List<ResourceChange> filterChanges(Iterable<ResourceChange> changes, ListenerConfig config) {
        ArrayList<ResourceChange> filtered = new ArrayList<ResourceChange>();
        for (ResourceChange c : changes) {
            if (!this.matches(c, config)) continue;
            filtered.add(c);
        }
        return filtered;
    }

    private boolean matches(ResourceChange change, ListenerConfig config) {
        if (!config.types.contains(change.getType())) {
            return false;
        }
        if (!config.isExternal && change.isExternal()) {
            return false;
        }
        return config.paths.matches(change.getPath()) != null;
    }

    private static final class ListenerConfig {
        public final PathSet paths;
        public final boolean isExternal;
        public final Set<ResourceChange.ChangeType> types;

        public ListenerConfig(ResourceChangeListenerInfo info, Set<ResourceChange.ChangeType> types) {
            this.paths = info.getPaths();
            this.isExternal = info.isExternal();
            this.types = types;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isExternal ? 1231 : 1237);
            result = 31 * result + this.paths.hashCode();
            result = 31 * result + this.types.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerConfig other = (ListenerConfig)obj;
            if (this.isExternal != other.isExternal) {
                return false;
            }
            if (!this.paths.equals((Object)other.paths)) {
                return false;
            }
            return this.types.equals(other.types);
        }
    }

    private static final class ObserverConfig {
        public final Set<ResourceChange.ChangeType> types = new HashSet<ResourceChange.ChangeType>();
        public boolean isExternal;

        private ObserverConfig() {
        }
    }
}

