/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.runtime.dto.FailureReason;
import org.apache.sling.api.resource.runtime.dto.ResourceProviderDTO;
import org.apache.sling.api.resource.runtime.dto.ResourceProviderFailureDTO;
import org.apache.sling.api.resource.runtime.dto.RuntimeDTO;
import org.apache.sling.api.resource.util.Path;
import org.apache.sling.api.resource.util.PathSet;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderStorage;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceProviderTracker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ServiceReference, ResourceProviderInfo> infos = new ConcurrentHashMap<ServiceReference, ResourceProviderInfo>();
    private volatile BundleContext bundleContext;
    private volatile ServiceTracker tracker;
    private final Map<String, List<ResourceProviderHandler>> handlers = new HashMap<String, List<ResourceProviderHandler>>();
    private final Map<ResourceProviderInfo, FailureReason> invalidProviders = new ConcurrentHashMap<ResourceProviderInfo, FailureReason>();
    private volatile EventAdmin eventAdmin;
    private volatile ObservationReporterGenerator reporterGenerator;
    private volatile ResourceProviderStorage storage;
    private volatile ObservationReporter providerReporter;
    private volatile ChangeListener listener;

    public void activate(BundleContext bundleContext, EventAdmin eventAdmin, ChangeListener listener) {
        this.bundleContext = bundleContext;
        this.eventAdmin = eventAdmin;
        this.listener = listener;
        this.tracker = new ServiceTracker(bundleContext, ResourceProvider.class.getName(), new ServiceTrackerCustomizer(){

            public void removedService(ServiceReference reference, Object service) {
                ServiceReference ref = (ServiceReference)service;
                ResourceProviderInfo info = (ResourceProviderInfo)ResourceProviderTracker.this.infos.remove(ref);
                if (info != null) {
                    ResourceProviderTracker.this.unregister(info);
                }
            }

            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            public Object addingService(ServiceReference reference) {
                ResourceProviderInfo info = new ResourceProviderInfo(reference);
                ResourceProviderTracker.this.infos.put(reference, info);
                ResourceProviderTracker.this.register(info);
                return reference;
            }
        });
        this.tracker.open();
    }

    public void deactivate() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        this.infos.clear();
        this.handlers.clear();
        this.invalidProviders.clear();
        this.listener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationReporterGenerator(ObservationReporterGenerator generator) {
        this.providerReporter = generator.createProviderReporter();
        Map<String, List<ResourceProviderHandler>> map = this.handlers;
        synchronized (map) {
            this.reporterGenerator = generator;
            for (List<ResourceProviderHandler> list : this.handlers.values()) {
                ResourceProviderHandler h = list.get(0);
                if (h == null) continue;
                this.updateProviderContext(h);
                h.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ResourceProviderInfo info) {
        if (info.isValid()) {
            this.logger.debug("Registering new resource provider {}", (Object)info);
            ArrayList<ProviderEvent> events = new ArrayList<ProviderEvent>();
            Map<String, List<ResourceProviderHandler>> map = this.handlers;
            synchronized (map) {
                List<ResourceProviderHandler> matchingHandlers = this.handlers.get(info.getPath());
                if (matchingHandlers == null) {
                    matchingHandlers = new ArrayList<ResourceProviderHandler>();
                    this.handlers.put(info.getPath(), matchingHandlers);
                }
                ResourceProviderHandler handler = new ResourceProviderHandler(this.bundleContext, info);
                matchingHandlers.add(handler);
                Collections.sort(matchingHandlers);
                if (matchingHandlers.get(0) == handler) {
                    if (!this.activate(handler)) {
                        matchingHandlers.remove(handler);
                        if (matchingHandlers.isEmpty()) {
                            this.handlers.remove(info.getPath());
                        }
                    } else {
                        events.add(new ProviderEvent(true, info));
                        if (matchingHandlers.size() > 1) {
                            this.deactivate(matchingHandlers.get(1));
                            events.add(new ProviderEvent(false, matchingHandlers.get(1).getInfo()));
                        }
                    }
                }
            }
            this.storage = null;
            this.postEvents(events);
        } else {
            this.logger.warn("Ignoring invalid resource provider {}", (Object)info);
            this.invalidProviders.put(info, FailureReason.invalid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(ResourceProviderInfo info) {
        boolean isInvalid;
        Map<ResourceProviderInfo, FailureReason> map = this.invalidProviders;
        synchronized (map) {
            isInvalid = this.invalidProviders.remove(info) != null;
        }
        if (!isInvalid) {
            this.logger.debug("Unregistering resource provider {}", (Object)info);
            ArrayList<ProviderEvent> events = new ArrayList<ProviderEvent>();
            Map<String, List<ResourceProviderHandler>> map2 = this.handlers;
            synchronized (map2) {
                List<ResourceProviderHandler> matchingHandlers = this.handlers.get(info.getPath());
                if (matchingHandlers != null) {
                    boolean doActivateNext = false;
                    if (matchingHandlers.get(0).getInfo() == info) {
                        doActivateNext = true;
                        this.deactivate(matchingHandlers.get(0));
                        events.add(new ProviderEvent(false, matchingHandlers.get(0).getInfo()));
                    }
                    if (this.removeHandlerByInfo(info, matchingHandlers)) {
                        while (doActivateNext && !matchingHandlers.isEmpty()) {
                            if (this.activate(matchingHandlers.get(0))) {
                                doActivateNext = false;
                                events.add(new ProviderEvent(true, matchingHandlers.get(0).getInfo()));
                                continue;
                            }
                            matchingHandlers.remove(0);
                        }
                    }
                    if (matchingHandlers.isEmpty()) {
                        this.handlers.remove(info.getPath());
                    }
                }
            }
            this.storage = null;
            this.postEvents(events);
        } else {
            this.logger.debug("Unregistering invalid resource provider {}", (Object)info);
        }
    }

    private boolean removeHandlerByInfo(ResourceProviderInfo info, List<ResourceProviderHandler> infos) {
        Iterator<ResourceProviderHandler> it = infos.iterator();
        boolean removed = false;
        while (it.hasNext()) {
            if (it.next().getInfo() != info) continue;
            it.remove();
            removed = true;
            break;
        }
        return removed;
    }

    private boolean activate(ResourceProviderHandler handler) {
        this.updateProviderContext(handler);
        if (!handler.activate()) {
            this.logger.warn("Activating resource provider {} failed", (Object)handler.getInfo());
            this.invalidProviders.put(handler.getInfo(), FailureReason.service_not_gettable);
            return false;
        }
        this.logger.debug("Activated resource provider {}", (Object)handler.getInfo());
        return true;
    }

    private void deactivate(ResourceProviderHandler handler) {
        handler.deactivate();
        this.logger.debug("Deactivated resource provider {}", (Object)handler.getInfo());
    }

    private void postOSGiEvent(ProviderEvent event) {
        Hashtable<String, String> eventProps = new Hashtable<String, String>();
        ((Dictionary)eventProps).put("path", event.path);
        if (event.pid != null) {
            ((Dictionary)eventProps).put("service.pid", event.pid);
        }
        this.eventAdmin.postEvent(new Event(event.isAdd ? "org/apache/sling/api/resource/ResourceProvider/ADDED" : "org/apache/sling/api/resource/ResourceProvider/REMOVED", eventProps));
    }

    private void postResourceProviderChange(ProviderEvent event) {
        ResourceChange change = new ResourceChange(event.isAdd ? ResourceChange.ChangeType.PROVIDER_ADDED : ResourceChange.ChangeType.PROVIDER_REMOVED, event.path, false, null, null, null);
        this.providerReporter.reportChanges(Collections.singletonList(change), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(RuntimeDTO dto) {
        ArrayList<ResourceProviderDTO> dtos = new ArrayList<ResourceProviderDTO>();
        ArrayList<ResourceProviderFailureDTO> failures = new ArrayList<ResourceProviderFailureDTO>();
        Map<Object, List<ResourceProviderHandler>> map = this.handlers;
        synchronized (map) {
            for (List<ResourceProviderHandler> list : this.handlers.values()) {
                boolean isFirst = true;
                for (ResourceProviderHandler h : list) {
                    ResourceProviderDTO d;
                    if (isFirst) {
                        d = new ResourceProviderDTO();
                        dtos.add(d);
                        isFirst = false;
                    } else {
                        d = new ResourceProviderFailureDTO();
                        ((ResourceProviderFailureDTO)d).reason = FailureReason.shadowed;
                        failures.add((ResourceProviderFailureDTO)d);
                    }
                    this.fill(d, h);
                }
            }
        }
        map = this.invalidProviders;
        synchronized (map) {
            for (Map.Entry entry : this.invalidProviders.entrySet()) {
                ResourceProviderFailureDTO d = new ResourceProviderFailureDTO();
                this.fill((ResourceProviderDTO)d, (ResourceProviderInfo)entry.getKey());
                d.reason = (FailureReason)entry.getValue();
                failures.add(d);
            }
        }
        dto.providers = dtos.toArray(new ResourceProviderDTO[dtos.size()]);
        dto.failedProviders = failures.toArray(new ResourceProviderFailureDTO[failures.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceProviderStorage getResourceProviderStorage() {
        ResourceProviderStorage result = this.storage;
        if (result == null) {
            Map<String, List<ResourceProviderHandler>> map = this.handlers;
            synchronized (map) {
                if (this.storage == null) {
                    ArrayList<ResourceProviderHandler> handlerList = new ArrayList<ResourceProviderHandler>();
                    for (List<ResourceProviderHandler> list : this.handlers.values()) {
                        ResourceProviderHandler h = list.get(0);
                        if (h == null) continue;
                        handlerList.add(h);
                    }
                    this.storage = new ResourceProviderStorage(handlerList);
                }
                result = this.storage;
            }
        }
        return result;
    }

    private void fill(ResourceProviderDTO d, ResourceProviderInfo info) {
        d.adaptable = info.isAdaptable();
        d.attributable = info.isAttributable();
        d.authType = info.getAuthType();
        d.modifiable = info.isModifiable();
        d.name = info.getName();
        d.path = info.getPath();
        d.refreshable = info.isRefreshable();
        d.serviceId = (Long)info.getServiceReference().getProperty("service.id");
        d.supportsQueryLanguage = false;
        d.useResourceAccessSecurity = info.getUseResourceAccessSecurity();
    }

    private void fill(ResourceProviderDTO d, ResourceProviderHandler handler) {
        this.fill(d, handler.getInfo());
        ResourceProvider<Object> provider = handler.getResourceProvider();
        if (provider != null) {
            d.supportsQueryLanguage = provider.getQueryLanguageProvider() != null;
        }
    }

    private void updateProviderContext(ResourceProviderHandler handler) {
        HashSet<String> excludedPaths = new HashSet<String>();
        Path handlerPath = new Path(handler.getPath());
        for (String otherPath : this.handlers.keySet()) {
            if (handler.getPath().equals(otherPath) || !handlerPath.matches(otherPath)) continue;
            excludedPaths.add(otherPath);
        }
        PathSet excludedPathSet = PathSet.fromStringCollection(excludedPaths);
        handler.getProviderContext().update(this.reporterGenerator.create(handlerPath, excludedPathSet), excludedPathSet);
    }

    private void postEvents(final List<ProviderEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                for (ProviderEvent e : events) {
                    ResourceProviderTracker.this.postOSGiEvent(e);
                    ResourceProviderTracker.this.postResourceProviderChange(e);
                    if (e.pid == null) continue;
                    ResourceProviderTracker.this.listener.providerChanged(e.pid);
                }
            }
        });
        t.setName("Apache Sling Resource Provider Change Notifier");
        t.setDaemon(true);
        t.start();
    }

    private static final class ProviderEvent {
        public final boolean isAdd;
        public final String pid;
        public final String path;

        public ProviderEvent(boolean isAdd, ResourceProviderInfo info) {
            this.isAdd = isAdd;
            this.path = info.getPath();
            String pid = (String)info.getServiceReference().getProperty("service.pid");
            if (pid == null) {
                pid = (String)info.getServiceReference().getProperty("original.service.pid");
            }
            this.pid = pid;
        }
    }

    public static interface ChangeListener {
        public void providerChanged(String var1);
    }

    public static interface ObservationReporterGenerator {
        public ObservationReporter create(Path var1, PathSet var2);

        public ObservationReporter createProviderReporter();
    }
}

