/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.BidiMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.console.ResourceResolverWebConsolePlugin;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverControl;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntries;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonResourceResolverFactoryImpl
implements ResourceResolverFactory,
MapConfigurationProvider {
    private MapEntries mapEntries = MapEntries.EMPTY;
    private ResourceResolverWebConsolePlugin plugin;
    private final ResourceResolverFactoryActivator activator;
    private ThreadLocal<Stack<WeakReference<ResourceResolver>>> resolverStackHolder = new ThreadLocal();
    private final AtomicBoolean isActive = new AtomicBoolean(true);
    private final ReferenceQueue<ResourceResolver> resolverReferenceQueue = new ReferenceQueue();
    private final Map<Integer, ResolverWeakReference> refs = new ConcurrentHashMap<Integer, ResolverWeakReference>();
    private final Thread refQueueThread;
    private boolean logResourceResolverClosing = false;

    public CommonResourceResolverFactoryImpl(ResourceResolverFactoryActivator activator) {
        this.activator = activator;
        this.logResourceResolverClosing = activator.shouldLogResourceResolverClosing();
        this.refQueueThread = new Thread("Apache Sling Resource Resolver Finalizer Thread"){

            @Override
            public void run() {
                while (CommonResourceResolverFactoryImpl.this.isActive.get()) {
                    try {
                        ResolverWeakReference ref = (ResolverWeakReference)CommonResourceResolverFactoryImpl.this.resolverReferenceQueue.remove();
                        try {
                            ref.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        CommonResourceResolverFactoryImpl.this.refs.remove(ref.control.hashCode());
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                for (ResolverWeakReference ref : CommonResourceResolverFactoryImpl.this.refs.values()) {
                    ref.close();
                }
                CommonResourceResolverFactoryImpl.this.refs.clear();
            }
        };
        this.refQueueThread.setDaemon(true);
        this.refQueueThread.start();
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> passedAuthenticationInfo) throws LoginException {
        if (!this.isActive.get()) {
            throw new LoginException("ResourceResolverFactory is deactivated.");
        }
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        authenticationInfo.put("provider.auth.admin", Boolean.TRUE);
        if (passedAuthenticationInfo != null) {
            authenticationInfo.putAll(passedAuthenticationInfo);
            authenticationInfo.remove("sling.service.bundle");
            authenticationInfo.remove("sling.service.subservice");
        }
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    public ResourceResolver getResourceResolver(Map<String, Object> passedAuthenticationInfo) throws LoginException {
        if (!this.isActive.get()) {
            throw new LoginException("ResourceResolverFactory is deactivated.");
        }
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        if (passedAuthenticationInfo != null) {
            authenticationInfo.putAll(passedAuthenticationInfo);
            authenticationInfo.remove("sling.service.bundle");
            authenticationInfo.remove("sling.service.subservice");
        }
        ResourceResolver result = this.getResourceResolverInternal(authenticationInfo, false);
        Stack<WeakReference<Object>> resolverStack = this.resolverStackHolder.get();
        if (resolverStack == null) {
            resolverStack = new Stack();
            this.resolverStackHolder.set(resolverStack);
        }
        resolverStack.push(new WeakReference<ResourceResolver>(result));
        return result;
    }

    public ResourceResolver getThreadResourceResolver() {
        if (!this.isActive.get()) {
            return null;
        }
        ResourceResolver result = null;
        Stack<WeakReference<ResourceResolver>> resolverStack = this.resolverStackHolder.get();
        if (resolverStack != null) {
            while (result == null && !resolverStack.isEmpty()) {
                result = (ResourceResolver)resolverStack.peek().get();
                if (result != null) continue;
                resolverStack.pop();
            }
        }
        return result;
    }

    public void register(ResourceResolver resolver, ResourceResolverControl ctrl) {
        this.refs.put(ctrl.hashCode(), new ResolverWeakReference(resolver, this.resolverReferenceQueue, ctrl));
    }

    public void unregister(ResourceResolver resourceResolverImpl, ResourceResolverControl ctrl) {
        Stack<WeakReference<ResourceResolver>> resolverStack;
        ctrl.close();
        this.refs.remove(ctrl.hashCode());
        ThreadLocal<Stack<WeakReference<ResourceResolver>>> tl = this.resolverStackHolder;
        if (tl != null && (resolverStack = tl.get()) != null) {
            Iterator i = resolverStack.iterator();
            while (i.hasNext()) {
                WeakReference ref = (WeakReference)i.next();
                if (ref.get() != null && ref.get() != resourceResolverImpl) continue;
                i.remove();
            }
            if (resolverStack.isEmpty()) {
                tl.remove();
            }
        }
    }

    public ResourceResolver getResourceResolverInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws LoginException {
        if (!this.isActive.get()) {
            throw new LoginException("ResourceResolverFactory is deactivated.");
        }
        return new ResourceResolverImpl(this, isAdmin, authenticationInfo);
    }

    public MapEntries getMapEntries() {
        return this.mapEntries;
    }

    protected void activate(BundleContext bundleContext) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            this.plugin = new ResourceResolverWebConsolePlugin(bundleContext, this, this.activator.getRuntimeService());
        }
        catch (Throwable ignore) {
            logger.debug("activate: unable to setup web console plugin.", ignore);
        }
        try {
            this.mapEntries = new MapEntries(this, bundleContext, this.activator.getEventAdmin());
        }
        catch (Exception e) {
            logger.error("activate: Cannot access repository, failed setting up Mapping Support", (Throwable)e);
        }
    }

    protected void deactivate() {
        this.isActive.set(false);
        this.refQueueThread.interrupt();
        if (this.plugin != null) {
            this.plugin.dispose();
            this.plugin = null;
        }
        if (this.mapEntries != null) {
            this.mapEntries.dispose();
            this.mapEntries = MapEntries.EMPTY;
        }
        this.resolverStackHolder = null;
    }

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.activator.getResourceDecoratorTracker();
    }

    public String[] getSearchPath() {
        return this.activator.getSearchPath();
    }

    public boolean isMangleNamespacePrefixes() {
        return this.activator.isMangleNamespacePrefixes();
    }

    @Override
    public String getMapRoot() {
        return this.activator.getMapRoot();
    }

    @Override
    public Mapping[] getMappings() {
        return this.activator.getMappings();
    }

    public BidiMap getVirtualURLMap() {
        return this.activator.getVirtualURLMap();
    }

    @Override
    public int getDefaultVanityPathRedirectStatus() {
        return this.activator.getDefaultVanityPathRedirectStatus();
    }

    public ResourceAccessSecurityTracker getResourceAccessSecurityTracker() {
        return this.activator.getResourceAccessSecurityTracker();
    }

    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        throw new IllegalStateException("This method is not implemented.");
    }

    @Override
    public boolean isVanityPathEnabled() {
        return this.activator.isVanityPathEnabled();
    }

    @Override
    public long getMaxCachedVanityPathEntries() {
        return this.activator.getMaxCachedVanityPathEntries();
    }

    @Override
    public boolean isMaxCachedVanityPathEntriesStartup() {
        return this.activator.isMaxCachedVanityPathEntriesStartup();
    }

    @Override
    public int getVanityBloomFilterMaxBytes() {
        return this.activator.getVanityBloomFilterMaxBytes();
    }

    @Override
    public boolean isOptimizeAliasResolutionEnabled() {
        return this.activator.isOptimizeAliasResolutionEnabled();
    }

    @Override
    public boolean hasVanityPathPrecedence() {
        return this.activator.hasVanityPathPrecedence();
    }

    @Override
    public List<MapConfigurationProvider.VanityPathConfig> getVanityPathConfig() {
        String[] includes = this.activator.getVanityPathWhiteList();
        String[] excludes = this.activator.getVanityPathBlackList();
        if (includes == null && excludes == null) {
            return null;
        }
        ArrayList<MapConfigurationProvider.VanityPathConfig> configs = new ArrayList<MapConfigurationProvider.VanityPathConfig>();
        if (includes != null) {
            for (String val : includes) {
                configs.add(new MapConfigurationProvider.VanityPathConfig(val, false));
            }
        }
        if (excludes != null) {
            for (String val : excludes) {
                configs.add(new MapConfigurationProvider.VanityPathConfig(val, true));
            }
        }
        Collections.sort(configs);
        return configs;
    }

    public boolean isLive() {
        return this.isActive.get();
    }

    public boolean shouldLogResourceResolverClosing() {
        return this.logResourceResolverClosing;
    }

    public ResourceProviderTracker getResourceProviderTracker() {
        return this.activator.getResourceProviderTracker();
    }

    private static final class ResolverWeakReference
    extends WeakReference<ResourceResolver> {
        private final ResourceResolverControl control;

        public ResolverWeakReference(ResourceResolver referent, ReferenceQueue<? super ResourceResolver> q, ResourceResolverControl ctrl) {
            super(referent, q);
            this.control = ctrl;
        }

        public void close() {
            this.control.close();
        }
    }
}

