/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import org.apache.commons.lang3.StringEscapeUtils;

public class JavaSource {
    private static final String INDENT = "    ";
    private int indentLevel;
    private final StringBuilder builder = new StringBuilder();

    public JavaSource prepend(String str) {
        this.builder.insert(0, str);
        return this;
    }

    public JavaSource beginIf() {
        this.indent().append("if (");
        return this;
    }

    public JavaSource completeIf() {
        this.append(") {\n");
        this.incIndent();
        return this;
    }

    public JavaSource endBlock() {
        this.decIndent();
        this.indent().append("}\n");
        return this;
    }

    public JavaSource comment(String text) {
        this.indent().append("//").append(text).append("\n");
        return this;
    }

    public JavaSource assign() {
        return this.append(" = ");
    }

    public JavaSource number(int value) {
        return this.append(Integer.toString(value));
    }

    public JavaSource increment() {
        return this.append("++");
    }

    public JavaSource beginAssignment(String variable, String type) {
        return this.declare(variable, type).assign();
    }

    public JavaSource beginAssignment(String variable) {
        return this.beginAssignment(variable, "Object");
    }

    public JavaSource declare(String variable, String type) {
        return this.startStatement().append(type).append(" ").append(variable);
    }

    public JavaSource declare(String variable) {
        return this.declare(variable, "Object");
    }

    public JavaSource equality() {
        return this.append(" == ");
    }

    public JavaSource startCall(String methodName, boolean useDot) {
        if (useDot) {
            this.builder.append('.');
        }
        this.builder.append(methodName).append('(');
        return this;
    }

    public JavaSource startCall(String methodName) {
        return this.startCall(methodName, false);
    }

    public JavaSource startMethodCall(String target, String method) {
        return this.append(target).startCall(method, true);
    }

    public JavaSource startArray() {
        return this.append("new Object[] {");
    }

    public JavaSource endArray() {
        return this.append("}");
    }

    public JavaSource startStatement() {
        this.indent();
        return this;
    }

    public JavaSource nullLiteral() {
        return this.append("null");
    }

    public JavaSource separateArgument() {
        this.builder.append(", ");
        return this;
    }

    public JavaSource stringLiteral(String text) {
        this.builder.append('\"').append(StringEscapeUtils.escapeJava((String)text)).append('\"');
        return this;
    }

    public JavaSource startExpression() {
        this.builder.append('(');
        return this;
    }

    public JavaSource endExpression() {
        this.builder.append(')');
        return this;
    }

    public JavaSource endCall() {
        this.builder.append(')');
        return this;
    }

    public JavaSource startBlock() {
        this.indent().append("{\n");
        this.incIndent();
        return this;
    }

    public JavaSource beginFor(String itemVariable, String listVariable) {
        this.startStatement().append("for (Object ").append(itemVariable).append(" : ").append(listVariable).append(") {\n");
        this.incIndent();
        return this;
    }

    public JavaSource endFor() {
        return this.endBlock();
    }

    public JavaSource endIf() {
        return this.endBlock();
    }

    public JavaSource beginNewInstanceCall(String className) {
        return this.append("new ").append(className).append("(");
    }

    public JavaSource append(String str) {
        this.builder.append(str);
        return this;
    }

    public JavaSource endStatement() {
        this.builder.append(";\n");
        return this;
    }

    public JavaSource cast(String type) {
        return this.append("(").append(type).append(")");
    }

    public JavaSource operator(String op) {
        return this.append(" ").append(op).append(" ");
    }

    public JavaSource beginAnonymousInstance(String className) {
        this.append("new ").append(className).append("() {\n");
        this.incIndent();
        return this;
    }

    public JavaSource endAnonymousInstance() {
        this.decIndent();
        this.append("}");
        return this;
    }

    public JavaSource beginMethod(String name, String returnType) {
        return this.startStatement().append("public ").append(returnType).append(" ").append(name).append("(");
    }

    public JavaSource methodParameter(String name, String type) {
        return this.append(type).append(" ").append(name);
    }

    public JavaSource completeMethodSignature() {
        this.append(") {\n");
        this.incIndent();
        return this;
    }

    public JavaSource endMethod() {
        return this.endBlock();
    }

    public JavaSource conditional() {
        return this.append(" ? ");
    }

    public JavaSource conditionalBranchSep() {
        return this.append(" : ");
    }

    public JavaSource negation() {
        return this.append("!");
    }

    public JavaSource newLine() {
        return this.append("\n");
    }

    public JavaSource objectModel() {
        return this.startMethodCall("renderContext", "getObjectModel").endCall();
    }

    public JavaSource property(String target, String property) {
        return this.append(target).append(".").append(property);
    }

    public JavaSource className(String className) {
        return this.property(className, "class").startCall("getName", true).endCall();
    }

    private StringBuilder indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.builder.append(INDENT);
        }
        return this.builder;
    }

    private void incIndent() {
        ++this.indentLevel;
    }

    private void decIndent() {
        --this.indentLevel;
    }

    public String toString() {
        return this.builder.toString();
    }
}

