/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.Stack;
import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.StatefulVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.CompileTimeObjectModel;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.EmitterVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.Streams;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.StatefulRangeIgnore;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.TrackingVisitor;

public class DeadCodeRemoval
extends TrackingVisitor<Boolean>
implements EmitterVisitor {
    private final PushStream outStream = new PushStream();
    private final StatefulVisitor.StateControl stateControl;
    private final Stack<Boolean> keepConditionalEndStack = new Stack();

    public static StreamTransformer transformer() {
        return new StreamTransformer(){

            @Override
            public CommandStream transform(CommandStream inStream) {
                StatefulVisitor visitor = new StatefulVisitor();
                DeadCodeRemoval dcr = new DeadCodeRemoval(visitor.getControl());
                visitor.initializeWith(dcr);
                Streams.connect(inStream, dcr.getOutputStream(), visitor);
                return dcr.getOutputStream();
            }
        };
    }

    public DeadCodeRemoval(StatefulVisitor.StateControl stateControl) {
        this.stateControl = stateControl;
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        Boolean truthValue = null;
        ExpressionNode node = variableBindingStart.getExpression();
        if (node instanceof StringConstant) {
            truthValue = CompileTimeObjectModel.toBoolean(((StringConstant)node).getText());
        }
        if (node instanceof BooleanConstant) {
            truthValue = ((BooleanConstant)node).getValue();
        }
        if (node instanceof NumericConstant) {
            truthValue = CompileTimeObjectModel.toBoolean(((NumericConstant)node).getValue());
        }
        if (node instanceof NullLiteral) {
            truthValue = CompileTimeObjectModel.toBoolean(null);
        }
        this.tracker.pushVariable(variableBindingStart.getVariableName(), truthValue);
        this.outStream.write(variableBindingStart);
    }

    @Override
    public void visit(Conditional.Start conditionalStart) {
        boolean keepConditionalEnd;
        Boolean truthValue = (Boolean)this.tracker.get(conditionalStart.getVariable());
        if (truthValue == null) {
            keepConditionalEnd = true;
            this.outStream.write(conditionalStart);
        } else {
            keepConditionalEnd = false;
            if (truthValue.booleanValue() != conditionalStart.getExpectedTruthValue()) {
                this.stateControl.push(new StatefulRangeIgnore(this.stateControl, Conditional.Start.class, Conditional.End.class));
                return;
            }
        }
        this.keepConditionalEndStack.push(keepConditionalEnd);
    }

    @Override
    public void visit(Conditional.End conditionalEnd) {
        boolean keep = this.keepConditionalEndStack.pop();
        if (keep) {
            this.outStream.write(conditionalEnd);
        }
    }

    @Override
    public PushStream getOutputStream() {
        return this.outStream;
    }

    @Override
    protected Boolean assignDefault(Command command) {
        return false;
    }

    @Override
    protected void onCommand(Command command) {
        this.outStream.write(command);
    }
}

