/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectModel.class);
    public static final Set<Class<?>> PRIMITIVE_CLASSES;
    private static final String TO_STRING_METHOD = "toString";

    private ObjectModel() {
    }

    public static boolean isPrimitive(Object object) {
        return PRIMITIVE_CLASSES.contains(object.getClass());
    }

    public static Object resolveProperty(Object target, Object property) {
        String propertyName;
        if (target == null || property == null) {
            return null;
        }
        Object resolved = null;
        if (property instanceof Number) {
            resolved = ObjectModel.getIndex(target, ((Number)property).intValue());
        }
        if (resolved == null && StringUtils.isNotEmpty((CharSequence)(propertyName = ObjectModel.toString(property)))) {
            if (target instanceof Map) {
                resolved = ((Map)target).get(propertyName);
            }
            if (resolved == null) {
                resolved = ObjectModel.getField(target, propertyName);
            }
            if (resolved == null) {
                resolved = ObjectModel.invokeBeanMethod(target, propertyName);
            }
        }
        return resolved;
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue() != 0.0;
        }
        String s = object.toString().trim();
        if ("".equals(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
            return Boolean.parseBoolean(s);
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() > 0;
        }
        if (object instanceof Iterable) {
            return ((Iterable)object).iterator().hasNext();
        }
        if (object instanceof Iterator) {
            return ((Iterator)object).hasNext();
        }
        return !(object instanceof Object[]) || ((Object[])object).length > 0;
    }

    public static Number toNumber(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        String stringValue = ObjectModel.toString(object);
        try {
            return NumberUtils.createNumber((String)stringValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String toString(Object object) {
        String output = "";
        if (object != null) {
            if (object instanceof String) {
                output = (String)object;
            } else if (ObjectModel.isPrimitive(object)) {
                output = object.toString();
            } else {
                if (object instanceof Enum) {
                    return ((Enum)object).name();
                }
                Collection<Object> col = ObjectModel.toCollection(object);
                output = ObjectModel.collectionToString(col);
            }
        }
        return output;
    }

    public static Collection<Object> toCollection(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object instanceof Map) {
            return ((Map)object).keySet();
        }
        if (object instanceof Enumeration) {
            return Collections.list((Enumeration)object);
        }
        if (object instanceof Iterator) {
            return ObjectModel.fromIterator((Iterator)object);
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return ObjectModel.fromIterator(iterable.iterator());
        }
        if (object instanceof String || object instanceof Number) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(object);
            return list;
        }
        return Collections.emptyList();
    }

    public static String collectionToString(Collection<?> collection) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (Object o : collection) {
            builder.append(prefix).append(ObjectModel.toString(o));
            prefix = ",";
        }
        return builder.toString();
    }

    public static Collection<Object> fromIterator(Iterator<Object> iterator) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static Object getIndex(Object object, int index) {
        Class<?> cls = object.getClass();
        if (cls.isArray() && index >= 0 && index < Array.getLength(object)) {
            return Array.get(object, index);
        }
        Collection<Object> collection = ObjectModel.toCollection(object);
        if (collection instanceof List && index >= 0 && index < collection.size()) {
            return ((List)collection).get(index);
        }
        return null;
    }

    public static Object getField(Object object, String fieldName) {
        Class<?> cls = object.getClass();
        if (cls.isArray() && "length".equals(fieldName)) {
            return Array.getLength(object);
        }
        try {
            Field field = cls.getField(fieldName);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeBeanMethod(Object object, String methodName) {
        Class<?> cls = object.getClass();
        Method method = ObjectModel.findBeanMethod(cls, methodName);
        if (method != null) {
            try {
                method = ObjectModel.extractMethodInheritanceChain(cls, method);
                return method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot access method " + methodName + " on object " + object.toString(), (Throwable)e);
            }
        }
        return null;
    }

    public static Method findBeanMethod(Class<?> cls, String baseName) {
        Method[] publicMethods = cls.getMethods();
        String capitalized = StringUtils.capitalize((String)baseName);
        for (Method method : publicMethods) {
            String methodName;
            if (method.getParameterTypes().length != 0 || !baseName.equals(methodName = method.getName()) && !("get" + capitalized).equals(methodName) && !("is" + capitalized).equals(methodName)) continue;
            if (!ObjectModel.isMethodAllowed(method)) break;
            return method;
        }
        return null;
    }

    public static boolean isMethodAllowed(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass != Object.class || TO_STRING_METHOD.equals(method.getName());
    }

    private static Method extractMethodInheritanceChain(Class type, Method method) throws NoSuchMethodException {
        Class<?>[] interfaces;
        if (method == null || Modifier.isPublic(type.getModifiers())) {
            return method;
        }
        for (Class<?> iface : interfaces = type.getInterfaces()) {
            Method parentMethod = ObjectModel.getClassMethod(iface, method);
            if (parentMethod == null) continue;
            return parentMethod;
        }
        return ObjectModel.getClassMethod(type.getSuperclass(), method);
    }

    private static Method getClassMethod(Class<?> type, Method method) throws NoSuchMethodException {
        Method parentMethod = type.getMethod(method.getName(), method.getParameterTypes());
        if ((parentMethod = ObjectModel.extractMethodInheritanceChain(parentMethod.getDeclaringClass(), parentMethod)) != null) {
            return parentMethod;
        }
        return null;
    }

    static {
        HashSet<Class<Void>> primitivesBuilder = new HashSet<Class<Void>>();
        primitivesBuilder.add(Boolean.class);
        primitivesBuilder.add(Boolean.class);
        primitivesBuilder.add(Character.class);
        primitivesBuilder.add(Byte.class);
        primitivesBuilder.add(Short.class);
        primitivesBuilder.add(Integer.class);
        primitivesBuilder.add(Long.class);
        primitivesBuilder.add(Float.class);
        primitivesBuilder.add(Double.class);
        primitivesBuilder.add(Void.class);
        PRIMITIVE_CLASSES = Collections.unmodifiableSet(primitivesBuilder);
    }
}

