/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.AbstractFilter;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;

public class FormatFilter
extends AbstractFilter {
    public static final String FORMAT_OPTION = "format";
    public static final String TYPE_OPTION = "type";
    public static final String FORMAT_LOCALE_OPTION = "formatLocale";
    public static final String TIMEZONE_OPTION = "timezone";

    private FormatFilter() {
        if (FormatFilterLoader.INSTANCE != null) {
            throw new IllegalStateException("INSTANCE was already defined.");
        }
    }

    public static FormatFilter getInstance() {
        return FormatFilterLoader.INSTANCE;
    }

    @Override
    public Expression apply(Expression expression, ExpressionContext expressionContext) {
        if (!expression.containsOption(FORMAT_OPTION) || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_USE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_CALL) {
            return expression;
        }
        RuntimeCall translation = new RuntimeCall(FORMAT_OPTION, expression.getRoot(), new MapLiteral(this.getFilterOptions(expression, FORMAT_OPTION, TYPE_OPTION, "locale", FORMAT_LOCALE_OPTION, TIMEZONE_OPTION)));
        return expression.withNode(translation);
    }

    private static final class FormatFilterLoader {
        private static final FormatFilter INSTANCE = new FormatFilter();

        private FormatFilterLoader() {
        }
    }
}

