/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class UnwrapPlugin
extends AbstractPlugin {
    public UnwrapPlugin() {
        this.name = "unwrap";
        this.priority = 125;
    }

    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private final String variable;
            private final Command unwrapTest;
            private boolean isSlyTag;
            {
                this.variable = compilerContext.generateVariable("unwrapCondition");
                this.unwrapTest = new Conditional.Start(this.variable, false);
                this.isSlyTag = false;
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                this.isSlyTag = "sly".equals(tagName.toLowerCase());
                stream.write(new VariableBinding.Start(this.variable, this.testNode()));
            }

            @Override
            public void beforeTagOpen(PushStream stream) {
                if (this.isSlyTag) {
                    Patterns.endStreamIgnore(stream);
                }
                stream.write(this.unwrapTest);
            }

            @Override
            public void afterTagOpen(PushStream stream) {
                stream.write(Conditional.END);
                if (this.isSlyTag) {
                    Patterns.beginStreamIgnore(stream);
                }
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                if (this.isSlyTag) {
                    Patterns.endStreamIgnore(stream);
                }
                stream.write(this.unwrapTest);
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                stream.write(Conditional.END);
                if (this.isSlyTag) {
                    Patterns.beginStreamIgnore(stream);
                }
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(VariableBinding.END);
            }

            private ExpressionNode testNode() {
                return this.isEmptyExpression(expression.getRoot()) ? BooleanConstant.TRUE : expression.getRoot();
            }

            private boolean isEmptyExpression(ExpressionNode node) {
                return node instanceof StringConstant && ((StringConstant)node).getText().isEmpty();
            }
        };
    }
}

