/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncExtractor;
import org.apache.sling.scripting.sightly.js.impl.jsapi.ProxyAsyncScriptableFactory;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsValueAdapter;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.js.impl.JsUseProvider"}, property={"service.ranking:Integer=80"})
public class JsUseProvider
implements UseProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsUseProvider.class);
    private static final String JS_ENGINE_NAME = "javascript";
    private static final JsValueAdapter jsValueAdapter = new JsValueAdapter(new AsyncExtractor());
    @Reference
    private ScriptEngineManager scriptEngineManager = null;
    @Reference
    private ProxyAsyncScriptableFactory proxyAsyncScriptableFactory = null;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        Bindings globalBindings = renderContext.getBindings();
        if (!Utils.isJsScript(identifier)) {
            return ProviderOutcome.failure();
        }
        ScriptEngine jsEngine = this.scriptEngineManager.getEngineByName(JS_ENGINE_NAME);
        if (jsEngine == null) {
            return ProviderOutcome.failure((Throwable)new SightlyException("No JavaScript engine was defined."));
        }
        SlingScriptHelper scriptHelper = Utils.getHelper(globalBindings);
        JsEnvironment environment = null;
        try {
            environment = new JsEnvironment(jsEngine);
            environment.initialize();
            ResourceResolver slingScriptingResolver = this.scriptingResourceResolverProvider.getRequestScopedResourceResolver();
            Resource callerScript = slingScriptingResolver.getResource(scriptHelper.getScript().getScriptResource().getPath());
            Resource scriptResource = Utils.getScriptResource(callerScript, identifier, globalBindings);
            globalBindings.put("javax.script.filename", (Object)scriptResource.getPath());
            this.proxyAsyncScriptableFactory.registerProxies(globalBindings);
            AsyncContainer asyncContainer = environment.runResource(scriptResource, globalBindings, arguments);
            ProviderOutcome providerOutcome = ProviderOutcome.success((Object)jsValueAdapter.adapt(asyncContainer));
            return providerOutcome;
        }
        finally {
            if (environment != null) {
                environment.cleanup();
            }
        }
    }

    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default 80;
    }
}

