/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled.operator;

import org.apache.sling.scripting.sightly.impl.compiled.ExpressionTranslator;
import org.apache.sling.scripting.sightly.impl.compiled.JavaSource;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.OpHelper;
import org.apache.sling.scripting.sightly.impl.compiled.operator.TypedNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.util.expression.SideEffectVisitor;

public class EquivalenceOpGen
implements BinaryOpGen {
    private final boolean negated;

    public EquivalenceOpGen(boolean negated) {
        this.negated = negated;
    }

    @Override
    public Type returnType(Type left, Type right) {
        return Type.BOOLEAN;
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        Type type = OpHelper.sameType(left, right);
        if (type != null && OpHelper.isNumericType(type) || type == Type.BOOLEAN || type == Type.UNKNOWN) {
            this.generateEqualsOperator(source, visitor, left.getNode(), right.getNode());
        } else if (type != Type.UNKNOWN) {
            this.generateEqualsMethod(source, visitor, left, right);
        }
    }

    private void generateCheckedEquals(JavaSource source, SideEffectVisitor visitor, TypedNode leftNode, TypedNode rightNode) {
        source.startExpression();
        leftNode.getNode().accept(visitor);
        source.equality().nullLiteral().conditional();
        rightNode.getNode().accept(visitor);
        source.equality().nullLiteral();
        source.conditionalBranchSep();
        this.generateEqualsMethod(source, visitor, leftNode, rightNode);
        source.endExpression();
    }

    private void generateEqualsMethod(JavaSource source, SideEffectVisitor visitor, TypedNode leftNode, TypedNode rightNode) {
        boolean performCast = leftNode.getType().isPrimitive();
        if (performCast) {
            source.startExpression();
            source.cast(Type.UNKNOWN.getNativeClass());
        }
        leftNode.getNode().accept(visitor);
        if (performCast) {
            source.endExpression();
        }
        source.startCall("equals", true);
        rightNode.getNode().accept(visitor);
        source.endCall();
    }

    private void generateEqualsOperator(JavaSource source, SideEffectVisitor visitor, ExpressionNode leftNode, ExpressionNode rightNode) {
        leftNode.accept(visitor);
        source.append(this.operator());
        rightNode.accept(visitor);
    }

    private String operator() {
        return this.negated ? "!=" : "==";
    }
}

