/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.CompilerMessage;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.compiler.CompilerException;
import org.apache.sling.scripting.sightly.impl.compiler.UnitChangeMonitor;
import org.apache.sling.scripting.sightly.impl.compiler.Utils;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.engine.extension.use.UseProviderUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={SightlyJavaCompilerService.class})
public class SightlyJavaCompilerService {
    private static final Logger LOG = LoggerFactory.getLogger(SightlyJavaCompilerService.class);
    public static final Pattern PACKAGE_DECL_PATTERN = Pattern.compile("(\\s*)package\\s+([a-zA-Z_$][a-zA-Z\\d_$]*\\.?)+;");
    @Reference
    private ClassLoaderWriter classLoaderWriter = null;
    @Reference
    private JavaCompiler javaCompiler = null;
    @Reference
    private UnitChangeMonitor unitChangeMonitor = null;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;
    private Options options;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();

    public Object getInstance(RenderContext renderContext, String className) {
        if (className.contains(".")) {
            if (this.unitChangeMonitor.getLastModifiedDateForJavaUseObject(className) > 0L) {
                Object result = this.compileRepositoryJavaClass(renderContext.getScriptResourceResolver(), className);
                this.unitChangeMonitor.clearJavaUseObject(className);
                return result;
            }
            try {
                return this.loadObject(className);
            }
            catch (CompilerException cex) {
                return this.compileRepositoryJavaClass(renderContext.getScriptResourceResolver(), className);
            }
        }
        Resource pojoResource = UseProviderUtils.locateScriptResource(renderContext, className + ".java");
        if (pojoResource != null) {
            return this.getInstance(renderContext, Utils.getJavaNameFromPath(pojoResource.getPath()));
        }
        throw new SightlyException("Cannot find class " + className + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object compileSource(SourceIdentifier sourceIdentifier, String sourceCode) {
        this.readLock.lock();
        try {
            if (sourceIdentifier.needsUpdate()) {
                this.readLock.unlock();
                this.writeLock.lock();
                Object object = this.internalCompileSource(sourceCode, sourceIdentifier.getFullyQualifiedName());
                return object;
            }
            Object obj = this.classLoaderWriter.getClassLoader().loadClass(sourceIdentifier.getFullyQualifiedName()).newInstance();
            return obj;
        }
        catch (Exception e) {}
        {
            finally {
                this.readLock.lock();
                this.writeLock.unlock();
            }
        }
        {
            throw new CompilerException(CompilerException.CompilerExceptionCause.COMPILER_ERRORS, (Throwable)e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Object internalCompileSource(String sourceCode, String fqcn) throws Exception {
        if (this.sightlyEngineConfiguration.keepGenerated()) {
            String path = "/" + fqcn.replaceAll("\\.", "/") + ".java";
            OutputStream os = this.classLoaderWriter.getOutputStream(path);
            IOUtils.write((String)sourceCode, (OutputStream)os, (String)"UTF-8");
            IOUtils.closeQuietly((OutputStream)os);
        }
        String[] sourceCodeLines = sourceCode.split("\\r\\n|[\\n\\x0B\\x0C\\r\\u0085\\u2028\\u2029]");
        boolean foundPackageDeclaration = false;
        for (String line : sourceCodeLines) {
            Matcher matcher = PACKAGE_DECL_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            foundPackageDeclaration = true;
            break;
        }
        if (!foundPackageDeclaration) {
            sourceCode = "package " + Utils.getPackageNameFromFQCN(fqcn) + ";\n" + sourceCode;
        }
        SightlyCompilationUnit compilationUnit = new SightlyCompilationUnit(sourceCode, fqcn);
        long start = System.currentTimeMillis();
        CompilationResult compilationResult = this.javaCompiler.compile(new CompilationUnit[]{compilationUnit}, this.options);
        long end = System.currentTimeMillis();
        List errors = compilationResult.getErrors();
        if (errors != null && errors.size() > 0) {
            throw new CompilerException(CompilerException.CompilerExceptionCause.COMPILER_ERRORS, this.createErrorMsg(errors));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("script compiled: {}", (Object)compilationResult.didCompile());
            LOG.debug("compilation took {}ms", (Object)(end - start));
        }
        return this.classLoaderWriter.getClassLoader().loadClass(fqcn).newInstance();
    }

    private Object compileRepositoryJavaClass(ResourceResolver resolver, String className) {
        String pojoPath = this.getPathFromJavaName(resolver, className);
        Resource pojoResource = resolver.getResource(pojoPath);
        if (pojoResource != null) {
            try {
                SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, this.unitChangeMonitor, this.classLoaderWriter, pojoResource);
                return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (String)"UTF-8"));
            }
            catch (IOException e) {
                throw new SightlyException(String.format("Unable to compile class %s from %s.", className, pojoPath), e);
            }
        }
        throw new SightlyException("Cannot find a a file corresponding to class " + className + " in the repository.");
    }

    private Set<String> getPossiblePojoPaths(String originalPath) {
        AmbiguousPathSymbol[] symbols;
        LinkedHashSet<String> possiblePaths = new LinkedHashSet<String>();
        possiblePaths.add(originalPath);
        HashMap<Integer, String> chars = new HashMap<Integer, String>();
        for (AmbiguousPathSymbol symbol : symbols = AmbiguousPathSymbol.values()) {
            String pathCopy = originalPath.substring(0, originalPath.lastIndexOf("/"));
            int actualIndex = 0;
            boolean firstPass = true;
            while (pathCopy.indexOf(symbol.getSymbol().charValue()) != -1) {
                int pos = pathCopy.indexOf(symbol.getSymbol().charValue());
                actualIndex += pos;
                if (!firstPass) {
                    ++actualIndex;
                }
                chars.put(actualIndex, symbol.getSymbol().toString());
                pathCopy = pathCopy.substring(pos + 1);
                firstPass = false;
            }
        }
        if (chars.size() > 0) {
            ArrayList<AmbiguousPathSymbol[]> possibleArrangements = new ArrayList<AmbiguousPathSymbol[]>();
            this.populateArray(possibleArrangements, new AmbiguousPathSymbol[chars.size()], 0);
            Integer[] indexes = chars.keySet().toArray(new Integer[chars.size()]);
            for (AmbiguousPathSymbol[] arrangement : possibleArrangements) {
                char[] possiblePath = originalPath.toCharArray();
                for (int i = 0; i < arrangement.length; ++i) {
                    char currentSymbol = arrangement[i].getSymbol().charValue();
                    int currentIndex = indexes[i];
                    possiblePath[currentIndex] = currentSymbol;
                }
                possiblePaths.add(new String(possiblePath));
            }
        }
        return possiblePaths;
    }

    private void populateArray(ArrayList<AmbiguousPathSymbol[]> arrayCollection, AmbiguousPathSymbol[] symbolsArrangementArray, int index) {
        if (symbolsArrangementArray.length > 0) {
            if (index == symbolsArrangementArray.length) {
                arrayCollection.add((AmbiguousPathSymbol[])symbolsArrangementArray.clone());
            } else {
                AmbiguousPathSymbol[] arr$ = AmbiguousPathSymbol.values();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    AmbiguousPathSymbol symbol;
                    symbolsArrangementArray[index] = symbol = arr$[i$];
                    this.populateArray(arrayCollection, symbolsArrangementArray, index + 1);
                }
            }
        }
    }

    private Object loadObject(String className) {
        try {
            if (this.classLoaderWriter != null) {
                return this.classLoaderWriter.getClassLoader().loadClass(className).newInstance();
            }
            return Class.forName(className).newInstance();
        }
        catch (Throwable t) {
            throw new CompilerException(CompilerException.CompilerExceptionCause.COMPILER_ERRORS, t);
        }
    }

    @Activate
    protected void activate() {
        LOG.info("Activating {}", (Object)this.getClass().getName());
        String version = System.getProperty("java.specification.version");
        this.options = new Options();
        this.options.put((Object)"generateDebugInfo", (Object)true);
        this.options.put((Object)"sourceVersion", (Object)version);
        this.options.put((Object)"targetVersion", (Object)version);
        this.options.put((Object)"classLoaderWriter", (Object)this.classLoaderWriter);
        this.options.put((Object)"forceCompilation", (Object)true);
    }

    private String getPathFromJavaName(ResourceResolver resolver, String className) {
        boolean sightlyGeneratedClass = false;
        if (className.contains(".SightlyJava_")) {
            sightlyGeneratedClass = true;
        }
        String packageName = className.substring(0, className.lastIndexOf(46));
        String shortClassName = className.substring(packageName.length() + 1);
        String path = "/" + packageName.replace(".", "/").replace("_", "-") + "/" + shortClassName + ".java";
        if (sightlyGeneratedClass) {
            return path;
        }
        Set<String> possiblePaths = this.getPossiblePojoPaths(path);
        for (String possiblePath : possiblePaths) {
            if (resolver.getResource(possiblePath) == null) continue;
            return possiblePath;
        }
        return path;
    }

    private String createErrorMsg(List<CompilerMessage> errors) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Compilation errors in ");
        buffer.append(errors.get(0).getFile());
        buffer.append(":");
        StringBuilder errorsBuffer = new StringBuilder();
        boolean duplicateVariable = false;
        for (CompilerMessage e : errors) {
            if (!duplicateVariable && e.getMessage().contains("Duplicate local variable")) {
                duplicateVariable = true;
                buffer.append(" Maybe you defined more than one identical block elements without defining a different variable for each one?");
            }
            errorsBuffer.append("\nLine ");
            errorsBuffer.append(e.getLine());
            errorsBuffer.append(", column ");
            errorsBuffer.append(e.getColumn());
            errorsBuffer.append(" : ");
            errorsBuffer.append(e.getMessage());
        }
        buffer.append((CharSequence)errorsBuffer);
        return buffer.toString();
    }

    protected void bindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    protected void unbindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        if (this.classLoaderWriter == classLoaderWriter) {
            this.classLoaderWriter = null;
        }
    }

    protected void bindJavaCompiler(JavaCompiler javaCompiler) {
        this.javaCompiler = javaCompiler;
    }

    protected void unbindJavaCompiler(JavaCompiler javaCompiler) {
        if (this.javaCompiler == javaCompiler) {
            this.javaCompiler = null;
        }
    }

    protected void bindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        this.unitChangeMonitor = unitChangeMonitor;
    }

    protected void unbindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        if (this.unitChangeMonitor == unitChangeMonitor) {
            this.unitChangeMonitor = null;
        }
    }

    protected void bindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        this.sightlyEngineConfiguration = sightlyEngineConfiguration;
    }

    protected void unbindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        if (this.sightlyEngineConfiguration == sightlyEngineConfiguration) {
            this.sightlyEngineConfiguration = null;
        }
    }

    static enum AmbiguousPathSymbol {
        DASH(Character.valueOf('-')),
        UNDERSCORE(Character.valueOf('_'));

        private Character symbol;

        private AmbiguousPathSymbol(Character symbol) {
            this.symbol = symbol;
        }

        public Character getSymbol() {
            return this.symbol;
        }
    }

    private static class SightlyCompilationUnit
    implements CompilationUnit {
        private String fqcn;
        private String sourceCode;

        SightlyCompilationUnit(String sourceCode, String fqcn) throws Exception {
            this.sourceCode = sourceCode;
            this.fqcn = fqcn;
        }

        public Reader getSource() throws IOException {
            return new InputStreamReader(IOUtils.toInputStream((String)this.sourceCode, (String)"UTF-8"), "UTF-8");
        }

        public String getMainClassName() {
            return this.fqcn;
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }
    }
}

